/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.oracle.OraDmlParsing;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.OracleReservedKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.ObjectUtils;

public class OraGeneratedParserUtil
extends SqlGeneratedParserUtil {
    public static boolean parseSimpleRefOrFunction(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser extra) {
        if (OraGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType[])new IElementType[]{OracleReservedKeywords.ORA_ROWNUM, OracleReservedKeywords.ORA_ROWID, OracleReservedKeywords.ORA_LEVEL})) {
            return SqlParserUtil.advanceAsRefExpression(builder, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
        }
        if (OraGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType[])new IElementType[]{OraTypes.ORA_FINAL, OraTypes.ORA_RUNNING}) && OraGeneratedParserUtil.isOn(builder, level, "ROW_PATTERN")) {
            PsiBuilder.Marker mark2 = builder.mark();
            if (OraDmlParsing.row_pattern_function_modifier(builder, level) && OraGeneratedParserUtil.parseDatabaseFunction(builder, level, false, false)) {
                mark2.drop();
                return true;
            }
            mark2.rollbackTo();
        }
        return SqlGeneratedParserUtil.parseSimpleRefOrFunction(builder, level, extra);
    }

    public static boolean divOperatorCondition(PsiBuilder b2, int l) {
        int start;
        IElementType type;
        if (b2.getTokenType() != OraTypes.ORA_OP_DIV) {
            return false;
        }
        int idx = -1;
        int end = b2.getCurrentOffset();
        while (true) {
            if ((type = b2.rawLookup(idx)) == null) {
                return false;
            }
            start = b2.rawTokenTypeStart(idx);
            if (!SqlTokens.WS_TOKENS.contains(type)) {
                return true;
            }
            if (StringUtil.containsLineBreak((CharSequence)b2.getOriginalText().subSequence(start, end))) break;
            --idx;
            end = start;
        }
        idx = 1;
        start = b2.getCurrentOffset();
        while ((type = b2.rawLookup(idx)) != null) {
            end = b2.rawTokenTypeStart(idx + 1);
            if (!SqlTokens.COMMENT_TOKENS.contains(type)) {
                if (!SqlTokens.WS_TOKENS.contains(type)) {
                    return true;
                }
                if (StringUtil.containsLineBreak((CharSequence)b2.getOriginalText().subSequence(start, end))) break;
            }
            ++idx;
            start = end;
        }
        return false;
    }

    public static boolean remapReference(PsiBuilder b2, int l, SqlReferenceElementType ref) {
        IElementType elem;
        PsiBuilderImpl.ProductionMarker node = (PsiBuilderImpl.ProductionMarker)ObjectUtils.tryCast((Object)b2.getLatestDoneMarker(), PsiBuilderImpl.ProductionMarker.class);
        IElementType iElementType = elem = node == null ? null : node.getTokenType();
        if (elem instanceof SqlReferenceElementType) {
            node.remapTokenType((IElementType)ref);
        }
        return true;
    }
}

