/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.highlighting.SqlHighlightLoopJumpsHandler;
import com.intellij.sql.psi.SqlConditionalJumpStatement;
import com.intellij.sql.psi.SqlLoopStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.slicer.SqlPsiUtilKt;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J*\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\u0011H\u0014R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/highlighting/SqlHighlightLoopJumpsHandler;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/PsiElement;)V", "computeUsages", "", "targets", "", "getTargets", "", "selectTargets", "selectionConsumer", "Lcom/intellij/util/Consumer;", "intellij.database.sql.impl"})
public final class SqlHighlightLoopJumpsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement target;

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Arrays.asList(this.target);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(target)");
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets2, @NotNull Consumer<List<PsiElement>> selectionConsumer) {
        Intrinsics.checkParameterIsNotNull(targets2, (String)"targets");
        Intrinsics.checkParameterIsNotNull(selectionConsumer, (String)"selectionConsumer");
        selectionConsumer.consume(targets2);
    }

    public void computeUsages(@NotNull List<PsiElement> targets2) {
        Intrinsics.checkParameterIsNotNull(targets2, (String)"targets");
        PsiElement psiElement = this.target.getParent();
        if (!(psiElement instanceof SqlConditionalJumpStatement)) {
            psiElement = null;
        }
        SqlConditionalJumpStatement sqlConditionalJumpStatement = (SqlConditionalJumpStatement)psiElement;
        if (sqlConditionalJumpStatement == null) {
            return;
        }
        SqlConditionalJumpStatement jumpStatement = sqlConditionalJumpStatement;
        SqlLoopStatement sqlLoopStatement = SqlPsiUtilKt.getLoopStatement(jumpStatement);
        if (sqlLoopStatement == null) {
            return;
        }
        SqlLoopStatement loopStatement = sqlLoopStatement;
        for (PsiElement element2 : (SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)loopStatement).expand((Condition)computeUsages.1.INSTANCE)) {
            if (!(element2 instanceof SqlConditionalJumpStatement) || !Intrinsics.areEqual((Object)SqlPsiUtilKt.getLoopStatement((SqlConditionalJumpStatement)element2), (Object)loopStatement)) continue;
            this.addOccurrence(element2);
        }
    }

    public SqlHighlightLoopJumpsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        super(editor, file);
        this.target = target;
    }
}

