/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.dockerjava.api.model.AccessMode;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class VolumesFrom
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String container;
    private AccessMode accessMode;

    public VolumesFrom(String container) {
        this(container, AccessMode.DEFAULT);
    }

    public VolumesFrom(String container, AccessMode accessMode) {
        this.container = container;
        this.accessMode = accessMode;
    }

    public String getContainer() {
        return this.container;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public static VolumesFrom parse(String serialized) {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 1: {
                    return new VolumesFrom(parts[0]);
                }
                case 2: {
                    return new VolumesFrom(parts[0], AccessMode.valueOf(parts[1]));
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Bind '" + serialized + "'");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof VolumesFrom) {
            VolumesFrom other = (VolumesFrom)obj;
            return new EqualsBuilder().append((Object)this.container, (Object)other.getContainer()).append((Object)this.accessMode, (Object)other.getAccessMode()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.container).append((Object)this.accessMode).toHashCode();
    }

    public String toString() {
        return this.container + ":" + this.accessMode.toString();
    }

    public static class Deserializer
    extends JsonDeserializer<VolumesFrom> {
        public VolumesFrom deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            return VolumesFrom.parse(node.asText());
        }
    }

    public static class Serializer
    extends JsonSerializer<VolumesFrom> {
        public void serialize(VolumesFrom volumeFrom, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeString(volumeFrom.toString());
        }
    }
}

