/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BitwiseXORComposite
implements Composite {
    protected Color xorColor;

    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        if (IntContext.isSupported(srcColorModel, dstColorModel, hints)) {
            return new IntContext(srcColorModel, this.xorColor);
        }
        return new GeneralContext(srcColorModel, dstColorModel, this.xorColor);
    }

    public BitwiseXORComposite(Color xorColor) {
        this.xorColor = xorColor;
    }

    private static class IntContext
    extends GeneralContext {
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            int aX = src.getMinX();
            int aY = src.getMinY();
            int bX = dstIn.getMinX();
            int bY = dstIn.getMinY();
            int dstX = dstOut.getMinX();
            int dstY = dstOut.getMinY();
            int width = Math.min(Math.min(src.getWidth(), dstIn.getWidth()), dstOut.getWidth());
            int height = Math.min(Math.min(src.getHeight(), dstIn.getHeight()), dstOut.getHeight());
            if (width < 1 || height < 1) {
                return;
            }
            int[] srcLine = new int[width];
            int[] dstLine = new int[width];
            this.srcColorModel.getDataElements(this.xorColor.getRGB(), srcLine);
            int xorPixel = srcLine[0];
            int y = 0;
            while (y < height) {
                src.getDataElements(aX, y + aY, width, 1, srcLine);
                dstIn.getDataElements(bX, y + bY, width, 1, dstLine);
                int x = 0;
                while (x < width) {
                    int n = x;
                    dstLine[n] = dstLine[n] ^ (srcLine[x] ^ xorPixel);
                    ++x;
                }
                dstOut.setDataElements(dstX, y + dstY, width, 1, dstLine);
                ++y;
            }
        }

        public static boolean isSupported(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
            int transferType = srcColorModel.getTransferType();
            if (transferType != dstColorModel.getTransferType()) {
                return false;
            }
            return transferType == 3;
        }

        public IntContext(ColorModel colorModel, Color xorColor) {
            super(colorModel, colorModel, xorColor);
        }
    }

    private static class GeneralContext
    implements CompositeContext {
        ColorModel srcColorModel;
        ColorModel dstColorModel;
        Color xorColor;

        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            Rectangle srcRect = src.getBounds();
            Rectangle dstInRect = dstIn.getBounds();
            Rectangle dstOutRect = dstOut.getBounds();
            int xp = this.xorColor.getRGB();
            int w = Math.min(Math.min(srcRect.width, dstOutRect.width), dstInRect.width);
            int h = Math.min(Math.min(srcRect.height, dstOutRect.height), dstInRect.height);
            Object srcPix = null;
            Object dstPix = null;
            Object rpPix = null;
            int y = 0;
            while (y < h) {
                int x = 0;
                while (x < w) {
                    srcPix = src.getDataElements(x + srcRect.x, y + srcRect.y, srcPix);
                    dstPix = dstIn.getDataElements(x + dstInRect.x, y + dstInRect.y, dstPix);
                    int sp = this.srcColorModel.getRGB(srcPix);
                    int dp = this.dstColorModel.getRGB(dstPix);
                    int rp = sp ^ xp ^ dp;
                    dstOut.setDataElements(x + dstOutRect.x, y + dstOutRect.y, this.dstColorModel.getDataElements(rp, rpPix));
                    ++x;
                }
                ++y;
            }
        }

        public void dispose() {
        }

        public GeneralContext(ColorModel srcColorModel, ColorModel dstColorModel, Color xorColor) {
            this.srcColorModel = srcColorModel;
            this.dstColorModel = dstColorModel;
            this.xorColor = xorColor;
        }
    }
}

