/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnQuadLineGenerator;
import net.sourceforge.napkinlaf.util.NapkinUtil;
import net.sourceforge.napkinlaf.util.RandomValue;
import net.sourceforge.napkinlaf.util.RandomXY;

public class DrawnCheckGenerator
extends AbstractDrawnGenerator {
    private final RandomXY dim;
    private final DrawnQuadLineGenerator leftLineGen;
    private final DrawnQuadLineGenerator rightLineGen;
    private final RandomXY midScale;
    private final RandomXY leftScale;
    private final RandomXY rightScale;

    public DrawnCheckGenerator() {
        this(10.0);
    }

    public DrawnCheckGenerator(double size) {
        this(new RandomValue(size), new RandomValue(size));
    }

    public DrawnCheckGenerator(RandomValue widthVal, RandomValue heightVal) {
        this.dim = new RandomXY(widthVal, heightVal);
        this.leftLineGen = new DrawnQuadLineGenerator();
        this.leftLineGen.getCtl().getY().setMid(2.0);
        this.leftLineGen.getCtl().getY().setRange(0.3);
        this.rightLineGen = new DrawnQuadLineGenerator();
        this.rightLineGen.getCtl().getY().setMid(-2.0);
        this.rightLineGen.getCtl().getY().setRange(0.3);
        this.leftScale = new RandomXY(0.5, 0.075, 0.5, 0.075);
        this.midScale = new RandomXY(0.5, 0.1, 0.1, 0.05);
        this.rightScale = new RandomXY(1.1, 0.1, 0.9, 0.1);
    }

    public Shape generate(AffineTransform matrix) {
        GeneralPath check = new GeneralPath();
        Point2D lScale = this.leftScale.generate();
        Point2D mScale = this.midScale.generate();
        Point2D rScale = this.rightScale.generate();
        Point2D size = this.dim.getMid();
        double boxWidth = size.getX();
        double boxHeight = size.getY();
        double mx = mScale.getX() * boxWidth;
        double my = boxHeight - mScale.getY() * boxHeight;
        double lx = mx - lScale.getX() * boxWidth;
        double ly = my - lScale.getY() * boxHeight;
        double rx = mx + rScale.getX() * boxWidth;
        double ry = my - rScale.getY() * boxHeight;
        NapkinUtil.drawStroke(check, matrix, mx, my, lx, ly, -Math.PI, this.leftLineGen);
        NapkinUtil.drawStroke(check, matrix, mx, my, rx, ry, 0.0, this.rightLineGen);
        return check;
    }

    public RandomXY getLeftScale() {
        return this.leftScale;
    }

    public RandomXY getRightScale() {
        return this.rightScale;
    }

    public RandomXY getMidScale() {
        return this.midScale;
    }

    private static double rootOfSquares(double ... numbers) {
        double sum = 0.0;
        for (double number : numbers) {
            sum += number * number;
        }
        return Math.sqrt(sum);
    }

    public double getMeanWidth() {
        return this.getRightScale().getX().getMid() + this.getLeftScale().getX().getMid();
    }

    public double getWidthRange() {
        return DrawnCheckGenerator.rootOfSquares(this.getRightScale().getX().getRange(), this.getMidScale().getX().getRange(), this.getMidScale().getX().getRange(), this.getLeftScale().getX().getRange());
    }

    public double getMaxWidth() {
        return this.getMeanWidth() + this.getWidthRange();
    }

    public double getMinWidth() {
        return this.getMeanWidth() - this.getWidthRange();
    }

    public double getMeanHeight() {
        return this.getRightScale().getY().getMid() + this.getMidScale().getY().getMid();
    }

    public double getHeightRange() {
        return DrawnCheckGenerator.rootOfSquares(this.getRightScale().getY().getRange(), this.getMidScale().getY().getRange());
    }

    public double getMaxHeight() {
        return this.getMeanHeight() + this.getHeightRange();
    }

    public double getMinHeight() {
        return this.getMeanHeight() - this.getHeightRange();
    }
}

