/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;

public class LunaIcons
extends BaseIcons {
    public static Icon getComboBoxIcon() {
        if (comboBoxIcon == null) {
            comboBoxIcon = new LazyImageIcon("luna/icons/DownArrow.gif");
        }
        return comboBoxIcon;
    }

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacIconIcon() : new TitleButtonIcon(0);
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMinIcon() : new TitleButtonIcon(1);
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMaxIcon() : new TitleButtonIcon(2);
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacCloseIcon() : new TitleButtonIcon(3);
        }
        return closeIcon;
    }

    private static class TitleButtonIcon
    implements Icon {
        private static Color blueFrameColor = Color.white;
        private static Color blueColorLight = new Color(154, 183, 250);
        private static Color blueColorDark = new Color(0, 69, 211);
        private static Color closerColorLight = new Color(241, 172, 154);
        private static Color closerColorDark = new Color(224, 56, 2);
        public static final int ICON_ICON_TYP = 0;
        public static final int MIN_ICON_TYP = 1;
        public static final int MAX_ICON_TYP = 2;
        public static final int CLOSE_ICON_TYP = 3;
        private int iconTyp = 0;

        public TitleButtonIcon(int typ) {
            this.iconTyp = typ;
        }

        public int getIconHeight() {
            return 20;
        }

        public int getIconWidth() {
            return 20;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = c.getWidth();
            int h = c.getHeight();
            JButton b = (JButton)c;
            Graphics2D g2D = (Graphics2D)g;
            boolean isActive = JTattooUtilities.isActive(b);
            boolean isPressed = b.getModel().isPressed();
            boolean isArmed = b.getModel().isArmed();
            boolean isRollover = b.getModel().isRollover();
            Color fc = blueFrameColor;
            Color cHi = blueColorLight;
            Color cLo = blueColorDark;
            if (this.iconTyp == 3) {
                cHi = closerColorLight;
                cLo = closerColorDark;
            }
            if (!isActive) {
                cHi = ColorHelper.brighter(cHi, 20.0);
                cLo = ColorHelper.brighter(cLo, 10.0);
            }
            if (isPressed && isArmed) {
                Color cTemp = ColorHelper.darker(cLo, 10.0);
                cLo = ColorHelper.darker(cHi, 10.0);
                cHi = cTemp;
            } else if (isRollover) {
                cHi = ColorHelper.brighter(cHi, 30.0);
                cLo = ColorHelper.brighter(cLo, 30.0);
            }
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, cHi, w, h, cLo));
            g.fillRect(1, 1, w - 2, h - 2);
            g.setColor(fc);
            g.drawLine(1, 0, w - 2, 0);
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.2f);
            g2D.setComposite(alpha);
            g2D.setColor(cLo);
            g.drawLine(2, 1, w - 2, 1);
            g.drawLine(1, 2, 1, h - 2);
            g2D.setColor(ColorHelper.darker(cLo, 40.0));
            g.drawLine(2, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 2, w - 2, h - 2);
            g2D.setComposite(composite);
            cHi = Color.white;
            cLo = ColorHelper.darker(cLo, 30.0);
            Icon icon = null;
            if (this.iconTyp == 0) {
                icon = new BaseIcons.IconSymbol(cHi, cLo, null, new Insets(0, 0, 0, 1));
            } else if (this.iconTyp == 1) {
                icon = new BaseIcons.MinSymbol(cHi, cLo, null, new Insets(0, 0, 0, 0));
            } else if (this.iconTyp == 2) {
                icon = new BaseIcons.MaxSymbol(cHi, cLo, null, new Insets(0, 0, 0, 1));
            } else if (this.iconTyp == 3) {
                icon = new BaseIcons.CloseSymbol(cHi, cLo, null, new Insets(0, 0, 0, 1));
            }
            if (icon != null) {
                icon.paintIcon(c, g, 0, 0);
            }
        }
    }
}

