/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences.codereformat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlPanel;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlPref;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlPrefReader;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.KeywordBehaviourPref;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.KeywordBehaviourPrefCtrl;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;

public class FormatSqlController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FormatSqlController.class);
    private FormatSqlPanel _formatSqlPanel;
    private FormatSqlPref _formatSqlPref;
    private IApplication _app;

    public FormatSqlController(IApplication app) {
        this._app = app;
        this._formatSqlPref = FormatSqlPrefReader.loadPref();
        this._formatSqlPanel = new FormatSqlPanel(this._formatSqlPref.getKeywordBehaviourPrefs());
        FontInfo fontInfo = app.getSquirrelPreferences().getSessionProperties().getFontInfo();
        this._formatSqlPanel.txtExampleSqls.setEditable(false);
        this._formatSqlPanel.txtExampleSqls.setFont(fontInfo.createFont());
        this.refreshExampleSql(this._formatSqlPref);
        this._formatSqlPanel.txtIndentCount.setValue(this._formatSqlPref.getIndent());
        this._formatSqlPanel.txtIndentCount.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FormatSqlController.this.refreshExampleSql(FormatSqlController.this.createFormatSqlPrefFromGui());
            }
        });
        this._formatSqlPanel.txtPreferedLineLength.setValue(this._formatSqlPref.getPreferedLineLength());
        this._formatSqlPanel.txtPreferedLineLength.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FormatSqlController.this.refreshExampleSql(FormatSqlController.this.createFormatSqlPrefFromGui());
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatSqlController.this.refreshExampleSql(FormatSqlController.this.createFormatSqlPrefFromGui());
            }
        };
        for (KeywordBehaviourPrefCtrl keywordBehaviourPrefCtrl : this._formatSqlPanel.keywordBehaviourPrefCtrls) {
            keywordBehaviourPrefCtrl.addKeyWordBehaviourChangedListener(actionListener);
        }
        this._formatSqlPanel.chkDoInsertValuesAlign.setSelected(this._formatSqlPref.isDoInsertValuesAlign());
        this._formatSqlPanel.chkDoInsertValuesAlign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatSqlController.this.adjustInsertValuesState();
            }
        });
        this.adjustInsertValuesState();
    }

    private void adjustInsertValuesState() {
        for (KeywordBehaviourPrefCtrl keywordBehaviourPrefCtrl : this._formatSqlPanel.keywordBehaviourPrefCtrls) {
            String keyWord = keywordBehaviourPrefCtrl.getKeywordBehaviourPref().getKeyWord();
            if ("INSERT".equals(keyWord)) {
                if (this._formatSqlPanel.chkDoInsertValuesAlign.isSelected()) {
                    keywordBehaviourPrefCtrl.setBehaviour(FormatSqlPanel.KeywordBehaviour.START_NEW_LINE);
                    keywordBehaviourPrefCtrl.setEnabled(false);
                    continue;
                }
                keywordBehaviourPrefCtrl.setEnabled(true);
                continue;
            }
            if (!"VALUES".equals(keyWord)) continue;
            if (this._formatSqlPanel.chkDoInsertValuesAlign.isSelected()) {
                keywordBehaviourPrefCtrl.setBehaviour(FormatSqlPanel.KeywordBehaviour.NO_INFLUENCE_ON_NEW_LINE);
                keywordBehaviourPrefCtrl.setEnabled(false);
                continue;
            }
            keywordBehaviourPrefCtrl.setEnabled(true);
        }
        this.refreshExampleSql(this.createFormatSqlPrefFromGui());
    }

    private void refreshExampleSql(FormatSqlPref formatSqlPref) {
        CodeReformator codeReformator = new CodeReformator(CodeReformatorConfigFactory.createConfig(formatSqlPref));
        String sqls = codeReformator.reformat("SELECT table1.id, table2.number, SUM(table1.amount) FROM table1 INNER JOIN table2 ON table.id = table2.table1_id WHERE table1.id IN (SELECT table1_id FROM table3 WHERE table3.name = 'Foo Bar' and table3.type = 'unknown_type') GROUP BY table1.id, table2.number ORDER BY table1.id");
        sqls = sqls + "\n\n";
        sqls = sqls + codeReformator.reformat("UPDATE table1 SET name = 'Hello', number = '1456-789' WHERE id = 42");
        sqls = sqls + "\n\n";
        sqls = sqls + codeReformator.reformat("INSERT INTO table1 (name, number) SELECT name, number FROM table1_bak");
        sqls = sqls + "\n\n";
        sqls = sqls + codeReformator.reformat("INSERT INTO table1 (name, number, type) VALUES ('Foo', 42, 'VA')");
        sqls = sqls + "\n\n";
        sqls = sqls + codeReformator.reformat("DELETE FROM table1 WHERE  name = 'Hello' OR number = '1456-789'");
        this._formatSqlPanel.txtExampleSqls.setText(sqls);
    }

    public void applyChanges() {
        try {
            this._formatSqlPref = this.createFormatSqlPrefFromGui();
            XMLBeanWriter bw = new XMLBeanWriter(this._formatSqlPref);
            bw.save(FormatSqlPrefReader.getPrefsFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FormatSqlPref createFormatSqlPrefFromGui() {
        FormatSqlPref ret = new FormatSqlPref();
        if (null != this._formatSqlPanel.txtIndentCount.getText()) {
            try {
                Integer indent = Integer.valueOf(this._formatSqlPanel.txtIndentCount.getText());
                if (indent >= 0) {
                    ret.setIndent(indent);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (null != this._formatSqlPanel.txtPreferedLineLength.getText()) {
            try {
                Integer preferedLineLength = Integer.valueOf(this._formatSqlPanel.txtPreferedLineLength.getText());
                if (preferedLineLength >= 0) {
                    ret.setPreferedLineLength(preferedLineLength);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ArrayList<KeywordBehaviourPref> buf = new ArrayList<KeywordBehaviourPref>();
        for (KeywordBehaviourPrefCtrl keywordBehaviourPrefCtrl : this._formatSqlPanel.keywordBehaviourPrefCtrls) {
            keywordBehaviourPrefCtrl.applyChanges();
            buf.add(keywordBehaviourPrefCtrl.getKeywordBehaviourPref());
        }
        ret.setKeywordBehaviourPrefs(buf.toArray(new KeywordBehaviourPref[buf.size()]));
        ret.setDoInsertValuesAlign(this._formatSqlPanel.chkDoInsertValuesAlign.isSelected());
        return ret;
    }

    public FormatSqlPanel getPanel() {
        return this._formatSqlPanel;
    }
}

