/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

import java.util.LinkedList;

public final class ByteArrayBuilder {
    private static final byte[] NO_BYTES = new byte[0];
    private static final int INITIAL_BLOCK_SIZE = 500;
    private static final int MAX_BLOCK_SIZE = 262144;
    static final int DEFAULT_BLOCK_ARRAY_SIZE = 40;
    private LinkedList<byte[]> _pastBlocks = new LinkedList();
    private int _pastLen;
    private byte[] _currBlock = new byte[500];
    private int _currBlockPtr;

    public void reset() {
        this._pastLen = 0;
        this._currBlockPtr = 0;
        if (!this._pastBlocks.isEmpty()) {
            this._currBlock = this._pastBlocks.getLast();
            this._pastBlocks.clear();
        }
    }

    public void append(int n) {
        byte by = (byte)n;
        if (this._currBlockPtr < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = by;
        } else {
            this._allocMoreAndAppend(by);
        }
    }

    public void appendTwoBytes(int n) {
        if (this._currBlockPtr + 1 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n;
        } else {
            this.append(n >> 8);
            this.append(n);
        }
    }

    public void appendThreeBytes(int n) {
        if (this._currBlockPtr + 2 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 16);
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n;
        } else {
            this.append(n >> 16);
            this.append(n >> 8);
            this.append(n);
        }
    }

    public byte[] toByteArray() {
        int n = this._pastLen + this._currBlockPtr;
        if (n == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (byte[] byArray2 : this._pastBlocks) {
            int n3 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
        }
        System.arraycopy(this._currBlock, 0, byArray, n2, this._currBlockPtr);
        if ((n2 += this._currBlockPtr) != n) {
            throw new RuntimeException("Internal error: total len assumed to be " + n + ", copied " + n2 + " bytes");
        }
        if (!this._pastBlocks.isEmpty()) {
            this.reset();
        }
        return byArray;
    }

    private void _allocMoreAndAppend(byte by) {
        this._pastLen += this._currBlock.length;
        int n = Math.max(this._pastLen >> 1, 1000);
        if (n > 262144) {
            n = 262144;
        }
        this._pastBlocks.add(this._currBlock);
        this._currBlock = new byte[n];
        this._currBlockPtr = 0;
        this._currBlock[this._currBlockPtr++] = by;
    }
}

