/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import io.netty.util.Recycler;
import java.util.Comparator;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.NodeBuilder;
import org.apache.cassandra.utils.btree.UpdateFunction;

final class TreeBuilder {
    private static final Recycler<TreeBuilder> builderRecycler = new Recycler<TreeBuilder>(){

        protected TreeBuilder newObject(Recycler.Handle handle) {
            return new TreeBuilder(handle);
        }
    };
    private final Recycler.Handle recycleHandle;
    private final NodeBuilder rootBuilder = new NodeBuilder();

    public static TreeBuilder newInstance() {
        return (TreeBuilder)builderRecycler.get();
    }

    private TreeBuilder(Recycler.Handle handle) {
        this.recycleHandle = handle;
    }

    public <C, K extends C, V extends C> Object[] update(Object[] btree, Comparator<C> comparator, Iterable<K> source, UpdateFunction<K, V> updateF) {
        NodeBuilder next;
        assert (updateF != null);
        NodeBuilder current = this.rootBuilder;
        current.reset(btree, BTree.POSITIVE_INFINITY, updateF, comparator);
        block0: for (K key : source) {
            while (true) {
                if (updateF.abortEarly()) {
                    this.rootBuilder.clear();
                    return null;
                }
                NodeBuilder next2 = current.update(key);
                if (next2 == null) continue block0;
                current = next2;
            }
        }
        while ((next = current.finish()) != null) {
            current = next;
        }
        assert (current.isRoot());
        Object[] r = current.toNode();
        current.clear();
        builderRecycler.recycle((Object)this, this.recycleHandle);
        return r;
    }

    public <C, K extends C, V extends C> Object[] build(Iterable<K> source, UpdateFunction<K, V> updateF, int size) {
        assert (updateF != null);
        NodeBuilder current = this.rootBuilder;
        while ((size >>= BTree.FAN_SHIFT) > 0) {
            current = current.ensureChild();
        }
        current.reset(BTree.EMPTY_LEAF, BTree.POSITIVE_INFINITY, updateF, null);
        for (K key : source) {
            current.addNewKey(key);
        }
        current = current.ascendToRoot();
        Object[] r = current.toNode();
        current.clear();
        builderRecycler.recycle((Object)this, this.recycleHandle);
        return r;
    }
}

