/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.List;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.LinkedAlignment;
import org.broad.igv.sam.ReadMate;

public class Row
implements Comparable<Row> {
    int nextIdx = 0;
    private double score = 0.0;
    List<Alignment> alignments = new ArrayList<Alignment>(100);
    public double y;
    public double h;

    public void addAlignment(Alignment alignment) {
        this.alignments.add(alignment);
    }

    public void updateScore(AlignmentTrack.SortOption option, double center, AlignmentInterval interval, String tag) {
        this.setScore(this.calculateScore(option, center, interval, tag));
    }

    public double calculateScore(AlignmentTrack.SortOption option, double center, AlignmentInterval interval, String tag) {
        int adjustedCenter = (int)center;
        Alignment centerAlignment = AlignmentInterval.getFeatureContaining(this.alignments, adjustedCenter);
        if (centerAlignment == null) {
            return 2.147483647E9;
        }
        switch (option) {
            case START: {
                return centerAlignment.getAlignmentStart();
            }
            case STRAND: {
                if (centerAlignment instanceof LinkedAlignment) {
                    return ((LinkedAlignment)centerAlignment).getStrandAtPosition(center) == Strand.NEGATIVE ? 1.0 : -1.0;
                }
                return centerAlignment.isNegativeStrand() ? -1.0 : 1.0;
            }
            case FIRST_OF_PAIR_STRAND: {
                Strand strand = centerAlignment.getFirstOfPairStrand();
                int score = 2;
                if (strand != Strand.NONE) {
                    score = strand == Strand.NEGATIVE ? 1 : -1;
                }
                return score;
            }
            case READ_ORDER: {
                int score = centerAlignment.isPaired() && centerAlignment.isFirstOfPair() ? -1 : (centerAlignment.isPaired() && centerAlignment.isSecondOfPair() ? 1 : 0);
                return score;
            }
            case NUCLEOTIDE: {
                float baseScore;
                AlignmentBlock[] insertions;
                byte base = centerAlignment.getBase(adjustedCenter);
                byte ref = interval.getReference(adjustedCenter);
                int insertionScore = 0;
                for (AlignmentBlock ins : insertions = centerAlignment.getInsertions()) {
                    int s = ins.getStart();
                    if (s != adjustedCenter && s - 1 != adjustedCenter) continue;
                    insertionScore += ins.getLength();
                }
                if (base == 78 || base == 110) {
                    baseScore = 2.0f;
                } else if (base == ref) {
                    baseScore = 3.0f;
                } else if (base == 0) {
                    int delCount = interval.getDelCount(adjustedCenter);
                    baseScore = delCount > 0 ? (float)(-delCount) : 1.0f;
                } else {
                    int count = interval.getCount(adjustedCenter, base);
                    byte phred = centerAlignment.getPhred(adjustedCenter);
                    baseScore = -((float)count + (float)phred / 1000.0f);
                }
                return baseScore - (float)insertionScore;
            }
            case QUALITY: {
                return -centerAlignment.getMappingQuality();
            }
            case SAMPLE: {
                String sample = centerAlignment.getSample();
                int score = sample == null ? 0 : sample.hashCode();
                return score;
            }
            case READ_GROUP: {
                String readGroup = centerAlignment.getReadGroup();
                int score = readGroup == null ? 0 : readGroup.hashCode();
                return score;
            }
            case INSERT_SIZE: {
                return -Math.abs(centerAlignment.getInferredInsertSize());
            }
            case MATE_CHR: {
                ReadMate mate = centerAlignment.getMate();
                if (mate == null) {
                    return 2.147483647E9;
                }
                if (mate.getChr().equals(centerAlignment.getChr())) {
                    return 2.147483646E9;
                }
                return mate.getChr().hashCode();
            }
            case SUPPLEMENTARY: {
                return centerAlignment.isSupplementary() ? 0.0 : 1.0;
            }
            case TAG: {
                Object tagValue = centerAlignment.getAttribute(tag);
                int score = tagValue == null ? 0 : tagValue.hashCode();
                return score;
            }
            case HAPLOTYPE: {
                return centerAlignment.getHapDistance();
            }
            case READ_NAME: {
                String readName = centerAlignment.getReadName();
                int score = readName == null ? 0 : readName.hashCode();
                return score;
            }
        }
        return 2.147483647E9;
    }

    public Alignment nextAlignment() {
        if (this.nextIdx < this.alignments.size()) {
            Alignment tmp = this.alignments.get(this.nextIdx);
            ++this.nextIdx;
            return tmp;
        }
        return null;
    }

    public int getNextStartPos() {
        if (this.nextIdx < this.alignments.size()) {
            return this.alignments.get(this.nextIdx).getStart();
        }
        return Integer.MAX_VALUE;
    }

    public boolean hasNext() {
        return this.nextIdx < this.alignments.size();
    }

    public void resetIdx() {
        this.nextIdx = 0;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public int compareTo(Row o) {
        return (int)Math.signum(this.getScore() - o.getScore());
    }
}

