/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import java.util.List;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class BasicServerEndpointConfigurator
extends ServerEndpointConfig.Configurator {
    private static final Logger LOG = Log.getLogger(BasicServerEndpointConfigurator.class);
    private static final String NO_SUBPROTOCOL = "";
    public static final ServerEndpointConfig.Configurator INSTANCE = new BasicServerEndpointConfigurator();

    public boolean checkOrigin(String originHeaderValue) {
        return true;
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(".getEndpointInstance({})", new Object[]{endpointClass});
        }
        try {
            return endpointClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException(String.format("%s: %s", e.getClass().getName(), e.getMessage()));
        }
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        return requested;
    }

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        if (requested == null || requested.size() == 0) {
            return NO_SUBPROTOCOL;
        }
        if (supported == null || supported.isEmpty()) {
            LOG.warn("Client requested Subprotocols on endpoint with none supported: {}", new Object[]{QuoteUtil.join(requested, (String)",")});
            return NO_SUBPROTOCOL;
        }
        for (String possible : requested) {
            if (possible == null || !supported.contains(possible)) continue;
            return possible;
        }
        LOG.warn("Client requested subprotocols {} do not match any endpoint supported subprotocols {}", new Object[]{QuoteUtil.join(requested, (String)","), QuoteUtil.join(supported, (String)",")});
        return NO_SUBPROTOCOL;
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
    }
}

