/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.PumpThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class RawTelnet {
    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 2) {
            RawTelnet.printUsage();
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Bad port value: " + stringArray[1]);
            RawTelnet.printUsage();
            System.exit(2);
            return;
        }
        try {
            Socket socket = new Socket(string, n);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            PumpThread pumpThread = new PumpThread(inputStream, System.out);
            PumpThread pumpThread2 = new PumpThread(System.in, outputStream);
            pumpThread.start();
            pumpThread2.start();
            new ProcessKillerThread(pumpThread).start();
            new ProcessKillerThread(pumpThread2).start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(3);
        }
    }

    private static void printUsage() {
        System.err.println("RawTelnet Utility");
        System.err.println("Copyright (C) 2002 Alexander Maryanovsky");
        System.err.println();
        System.err.println("Usage: java free.util.RawTelnet hostname port");
        System.out.println();
        System.out.println("Version 1.00 - 20 Jul. 2002");
    }

    private static class ProcessKillerThread
    extends Thread {
        private final Thread target;

        public ProcessKillerThread(Thread thread) {
            super("ProcessKillerThread(" + thread.getName() + ")");
            this.target = thread;
            this.setDaemon(true);
        }

        public void run() {
            try {
                this.target.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            System.err.println("Connection died");
            System.exit(0);
        }
    }
}

