/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.BoardPainter;
import free.chess.DefaultBoardPainter;
import free.chess.ResourceBoardPainter;
import free.util.IOUtilities;
import free.util.ImageUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class BoardImageBoardPainter
implements ResourceBoardPainter {
    private static final BoardPainter whileLoadingDelegate = new DefaultBoardPainter();
    private static volatile boolean asyncImageLoad = false;
    private Image boardImage = null;
    private Image scaledBoardImage = null;
    private URL boardImageUrl = null;
    private ImageDataReceiver imageDataReceiver = null;

    public BoardImageBoardPainter() {
    }

    public BoardImageBoardPainter(Image image) {
        this.boardImage = image;
    }

    public static void setAsyncImageLoad(boolean bl) {
        asyncImageLoad = bl;
    }

    public BoardPainter freshInstance() {
        return this;
    }

    public void load(URL uRL) throws IOException {
        if (this.boardImageUrl != null) {
            throw new IllegalStateException("This BoardImageBoardPainter has already been loaded");
        }
        URL uRL2 = new URL(uRL, "definition");
        Properties properties = IOUtilities.loadProperties((URL)uRL2, (boolean)true);
        if (properties == null) {
            properties = new Properties();
        }
        String string = properties.getProperty("ext", "gif");
        this.boardImageUrl = new URL(uRL, "board." + string);
    }

    protected synchronized boolean prepareBoardImage(int n, int n2, Component component) {
        if (this.boardImage == null) {
            if (this.imageDataReceiver != null) {
                this.imageDataReceiver.addComponentToRepaint(component);
                return false;
            }
            if (asyncImageLoad) {
                this.imageDataReceiver = new ImageDataReceiver(component);
                IOUtilities.loadAsynchronously((URL[])new URL[]{this.boardImageUrl}, null, (IOUtilities.DataReceiver)this.imageDataReceiver, (boolean)true);
                return false;
            }
            this.imageDataReceiver = new ImageDataReceiver(null);
            IOUtilities.loadSynchronously((URL[])new URL[]{this.boardImageUrl}, null, (IOUtilities.DataReceiver)this.imageDataReceiver, (boolean)true);
            if (this.boardImage == null) {
                return false;
            }
            this.scaleBoardImage(n, n2);
            return true;
        }
        this.scaleBoardImage(n, n2);
        return true;
    }

    private void scaleBoardImage(int n, int n2) {
        if (this.scaledBoardImage != null && this.scaledBoardImage.getWidth(null) == n && this.scaledBoardImage.getHeight(null) == n2) {
            return;
        }
        this.scaledBoardImage = this.boardImage.getScaledInstance(n, n2, 4);
        ImageUtilities.preload((Image)this.scaledBoardImage);
    }

    public void paintBoard(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (this.prepareBoardImage(n3, n4, component)) {
            graphics.drawImage(this.scaledBoardImage, n, n2, component);
        } else {
            whileLoadingDelegate.paintBoard(graphics, component, n, n2, n3, n4);
        }
    }

    private class ImageDataReceiver
    implements IOUtilities.DataReceiver {
        private final Set componentsToRepaint = new HashSet(2);

        public ImageDataReceiver(Component component) {
            this.componentsToRepaint.add(component);
        }

        public void addComponentToRepaint(Component component) {
            this.componentsToRepaint.add(component);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataRead(URL[] uRLArray, Object object, byte[][] byArray, IOException[] iOExceptionArray) {
            for (int i = 0; i < iOExceptionArray.length; ++i) {
                if (iOExceptionArray[i] == null) continue;
                return;
            }
            BoardImageBoardPainter boardImageBoardPainter = BoardImageBoardPainter.this;
            synchronized (boardImageBoardPainter) {
                BoardImageBoardPainter.this.boardImage = Toolkit.getDefaultToolkit().createImage(byArray[0]);
                ImageUtilities.preload((Image)BoardImageBoardPainter.this.boardImage);
                BoardImageBoardPainter.this.imageDataReceiver = null;
                Iterator iterator = this.componentsToRepaint.iterator();
                while (iterator.hasNext()) {
                    Component component = (Component)iterator.next();
                    if (component == null) continue;
                    component.repaint();
                }
            }
        }
    }
}

