/*
 * Decompiled with CFR 0.152.
 */
package free.chess.variants.fischerrandom;

import free.chess.ChessMove;
import free.chess.ChessPiece;
import free.chess.ChesslikeGenericVariant;
import free.chess.Move;
import free.chess.Piece;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;

public class FischerRandom
extends ChesslikeGenericVariant {
    private static final FischerRandom INSTANCE = new FischerRandom();

    public static FischerRandom getInstance() {
        return INSTANCE;
    }

    private FischerRandom() {
        super("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Fischer random");
    }

    public boolean isShortCastling(Position position, Square square, Square square2, ChessPiece chessPiece) {
        block14: {
            ChessPiece chessPiece2;
            ChessPiece chessPiece3;
            block13: {
                if (chessPiece != null) {
                    return false;
                }
                chessPiece3 = (ChessPiece)position.getPieceAt(square);
                chessPiece2 = (ChessPiece)position.getPieceAt(square2);
                if (chessPiece3 != ChessPiece.WHITE_KING) break block13;
                if (square.getRank() != 0) {
                    return false;
                }
                if (chessPiece2 != null && chessPiece2 != ChessPiece.WHITE_ROOK) {
                    return false;
                }
                if (!square2.equals("g1")) {
                    return false;
                }
                if (square.equals("f1")) {
                    return chessPiece2 == ChessPiece.WHITE_ROOK;
                }
                int n = square.getRank();
                for (int i = square.getFile() + 1; i <= 7; ++i) {
                    Piece piece = position.getPieceAt(i, n);
                    if (piece == null) continue;
                    if (piece == ChessPiece.WHITE_ROOK) {
                        return chessPiece2 != ChessPiece.WHITE_ROOK || square2.equals(i, n);
                    }
                    return false;
                }
                break block14;
            }
            if (chessPiece3 != ChessPiece.BLACK_KING) break block14;
            if (square.getRank() != 7) {
                return false;
            }
            if (chessPiece2 != null && chessPiece2 != ChessPiece.BLACK_ROOK) {
                return false;
            }
            if (!square2.equals("g8")) {
                return false;
            }
            if (square.equals("f8")) {
                return chessPiece2 == ChessPiece.BLACK_ROOK;
            }
            int n = square.getRank();
            for (int i = square.getFile() + 1; i <= 7; ++i) {
                Piece piece = position.getPieceAt(i, n);
                if (piece == null) continue;
                if (piece == ChessPiece.BLACK_ROOK) {
                    return chessPiece2 != ChessPiece.BLACK_ROOK || square2.equals(i, n);
                }
                return false;
            }
        }
        return false;
    }

    public boolean isLongCastling(Position position, Square square, Square square2, ChessPiece chessPiece) {
        block16: {
            ChessPiece chessPiece2;
            ChessPiece chessPiece3;
            block15: {
                if (chessPiece != null) {
                    return false;
                }
                chessPiece3 = (ChessPiece)position.getPieceAt(square);
                chessPiece2 = (ChessPiece)position.getPieceAt(square2);
                if (chessPiece3 != ChessPiece.WHITE_KING) break block15;
                if (square.getRank() != 0) {
                    return false;
                }
                if (chessPiece2 != null && chessPiece2 != ChessPiece.WHITE_ROOK) {
                    return false;
                }
                if (!square2.equals("c1")) {
                    return false;
                }
                if (square.equals("b1")) {
                    return false;
                }
                if (square.equals("d1")) {
                    return chessPiece2 == ChessPiece.WHITE_ROOK;
                }
                int n = square.getRank();
                for (int i = square.getFile() - 1; i >= 0; --i) {
                    Piece piece = position.getPieceAt(i, n);
                    if (piece == null) continue;
                    if (piece == ChessPiece.WHITE_ROOK) {
                        return chessPiece2 != ChessPiece.WHITE_ROOK || square2.equals(i, n);
                    }
                    return false;
                }
                break block16;
            }
            if (chessPiece3 != ChessPiece.BLACK_KING) break block16;
            if (square.getRank() != 7) {
                return false;
            }
            if (chessPiece2 != null && chessPiece2 != ChessPiece.BLACK_ROOK) {
                return false;
            }
            if (!square2.equals("c8")) {
                return false;
            }
            if (square.equals("b8")) {
                return false;
            }
            if (square.equals("d8")) {
                return chessPiece2 == ChessPiece.BLACK_ROOK;
            }
            int n = square.getRank();
            for (int i = square.getFile() - 1; i >= 0; --i) {
                Piece piece = position.getPieceAt(i, n);
                if (piece == null) continue;
                if (piece == ChessPiece.BLACK_ROOK) {
                    return chessPiece2 != ChessPiece.BLACK_ROOK || square2.equals(i, n);
                }
                return false;
            }
        }
        return false;
    }

    public Move createShortCastling(Position position) {
        this.checkPosition(position);
        Player player = position.getCurrentPlayer();
        if (player.isWhite()) {
            Square square = FischerRandom.findPieceOnRow(position, ChessPiece.WHITE_KING, 0);
            if (square == null) {
                throw new IllegalArgumentException("Castling is not allowed in the specified position");
            }
            return new ChessMove(square, Square.parseSquare("g1"), Player.WHITE_PLAYER, false, true, false, null, -1, null, "O-O");
        }
        Square square = FischerRandom.findPieceOnRow(position, ChessPiece.BLACK_KING, 7);
        if (square == null) {
            throw new IllegalArgumentException("Castling is not allowed in the specified position");
        }
        return new ChessMove(square, Square.parseSquare("g8"), Player.BLACK_PLAYER, false, true, false, null, -1, null, "O-O");
    }

    public Move createLongCastling(Position position) {
        this.checkPosition(position);
        Player player = position.getCurrentPlayer();
        if (player.isWhite()) {
            Square square = FischerRandom.findPieceOnRow(position, ChessPiece.WHITE_KING, 0);
            if (square == null) {
                throw new IllegalArgumentException("Castling is not allowed in the specified position");
            }
            return new ChessMove(square, Square.parseSquare("c1"), Player.WHITE_PLAYER, false, false, true, null, -1, null, "O-O");
        }
        Square square = FischerRandom.findPieceOnRow(position, ChessPiece.BLACK_KING, 7);
        if (square == null) {
            throw new IllegalArgumentException("Castling is not allowed in the specified position");
        }
        return new ChessMove(square, Square.parseSquare("c8"), Player.BLACK_PLAYER, false, false, true, null, -1, null, "O-O");
    }

    private static Square findPieceOnRow(Position position, Piece piece, int n) {
        for (int i = 0; i < 8; ++i) {
            if (!piece.equals(position.getPieceAt(i, n))) continue;
            return Square.getInstance(i, n);
        }
        return null;
    }

    public void init(Position position) {
        this.checkPosition(position);
        position.setFEN(FischerRandom.createRandomInitialFEN());
    }

    private static String createRandomInitialFEN() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("--------");
        while ((n = FischerRandom.randomInt(8)) % 2 != 0 || stringBuffer.charAt(n) != '-') {
        }
        stringBuffer.setCharAt(n, 'B');
        while ((n = FischerRandom.randomInt(8)) % 2 != 1 || stringBuffer.charAt(n) != '-') {
        }
        stringBuffer.setCharAt(n, 'B');
        while (stringBuffer.charAt(n = FischerRandom.randomInt(8)) != '-') {
        }
        stringBuffer.setCharAt(n, 'N');
        while (stringBuffer.charAt(n = FischerRandom.randomInt(8)) != '-') {
        }
        stringBuffer.setCharAt(n, 'N');
        while (stringBuffer.charAt(n = FischerRandom.randomInt(8)) != '-') {
        }
        stringBuffer.setCharAt(n, 'Q');
        for (n = 0; n < 6 && stringBuffer.charAt(n) != '-'; ++n) {
        }
        stringBuffer.setCharAt(n++, 'R');
        while (n < 7 && stringBuffer.charAt(n) != '-') {
            ++n;
        }
        stringBuffer.setCharAt(n++, 'K');
        while (n < 8 && stringBuffer.charAt(n) != '-') {
            ++n;
        }
        stringBuffer.setCharAt(n, 'R');
        String string = stringBuffer.toString();
        String string2 = string.toLowerCase();
        return string2 + "/pppppppp/8/8/8/8/PPPPPPPP/" + string + " w KQkq - 0 1";
    }

    private static int randomInt(int n) {
        return (int)(Math.random() * (double)n);
    }

    public void makeMove(Move move, Position position, Position.Modifier modifier) {
        this.checkPosition(position);
        if (!(move instanceof ChessMove)) {
            throw new IllegalArgumentException("The given move must be an instance of " + ChessMove.class.getName());
        }
        ChessMove chessMove = (ChessMove)move;
        Square square = chessMove.getStartingSquare();
        Square square2 = chessMove.getEndingSquare();
        ChessPiece chessPiece = (ChessPiece)position.getPieceAt(square);
        if (chessMove.isCastling()) {
            int n;
            int n2 = chessMove.isShortCastling() ? 1 : -1;
            int n3 = square.getRank();
            for (n = square.getFile() + n2; n >= 0 && n <= 7; n += n2) {
                ChessPiece chessPiece2 = (ChessPiece)position.getPieceAt(n, n3);
                if (chessPiece2 == null) continue;
                if (chessPiece2.isRook() && chessPiece2.isSameColorAs(chessPiece)) break;
                throw new IllegalArgumentException("The given move may not be a castling move");
            }
            int n4 = n;
            int n5 = chessMove.isShortCastling() ? 5 : 3;
            Square square3 = Square.getInstance(n4, square.getRank());
            Square square4 = Square.getInstance(n5, square.getRank());
            ChessPiece chessPiece3 = (ChessPiece)position.getPieceAt(square3);
            modifier.setPieceAt(null, square);
            modifier.setPieceAt(null, square3);
            modifier.setPieceAt(chessPiece, square2);
            modifier.setPieceAt(chessPiece3, square4);
            modifier.setCurrentPlayer(position.getCurrentPlayer().getOpponent());
        } else {
            super.makeMove(move, position, modifier);
        }
    }
}

