/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AncestorQualifiedPattern
extends Pattern {
    private Pattern basePattern;
    private Pattern upperPattern;
    private byte upwardsAxis = (byte)9;
    private ItemType refinedItemType;

    public AncestorQualifiedPattern(Pattern base, Pattern upper, byte axis) {
        this.basePattern = base;
        this.upperPattern = upper;
        this.upwardsAxis = axis;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        this.basePattern.setLineNumber(lineNumber);
        this.upperPattern.setLineNumber(lineNumber);
    }

    @Override
    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.basePattern.setSystemId(systemId);
        this.upperPattern.setSystemId(systemId);
    }

    @Override
    public void setExecutable(Executable executable) {
        super.setExecutable(executable);
        this.basePattern.setExecutable(executable);
        this.upperPattern.setExecutable(executable);
    }

    @Override
    public void bindCurrent(Binding binding) {
        this.basePattern.bindCurrent(binding);
        this.upperPattern.bindCurrent(binding);
    }

    public Pattern getBasePattern() {
        return this.basePattern;
    }

    public Pattern getUpperPattern() {
        return this.upperPattern;
    }

    public byte getUpwardsAxis() {
        return this.upwardsAxis;
    }

    @Override
    public boolean isMotionless(boolean allowExtensions) {
        return this.basePattern.isMotionless(allowExtensions) && this.upperPattern.isMotionless(allowExtensions);
    }

    @Override
    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        this.upperPattern = this.upperPattern.simplify(visitor);
        this.basePattern = this.basePattern.simplify(visitor);
        return this;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        ItemType type;
        this.basePattern = this.basePattern.analyze(visitor, contextItemType);
        this.upperPattern = this.upperPattern.analyze(visitor, contextItemType);
        if (this.upwardsAxis == 9 && (type = this.basePattern.getItemType()) instanceof NodeTest) {
            AxisExpression step = type.getPrimitiveType() == 2 ? new AxisExpression(2, (NodeTest)type) : new AxisExpression(3, (NodeTest)type);
            StaticContext env = visitor.getStaticContext();
            step.setLocationId(env.getLocationMap().allocateLocationId(env.getSystemId(), this.getLineNumber()));
            step.setContainer(this);
            Expression exp = visitor.typeCheck(step, new ExpressionVisitor.ContextItemType(this.upperPattern.getItemType(), false));
            this.refinedItemType = exp.getItemType(env.getConfiguration().getTypeHierarchy());
        }
        return this;
    }

    @Override
    public int getDependencies() {
        return this.basePattern.getDependencies() | this.upperPattern.getDependencies();
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        Iterator[] pair = new Iterator[]{this.basePattern.iterateSubExpressions(), this.upperPattern.iterateSubExpressions()};
        return new MultiIterator<Expression>(pair);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = this.upperPattern.replaceSubExpression(original, replacement);
        return found |= this.basePattern.replaceSubExpression(original, replacement);
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        nextFree = this.upperPattern.allocateSlots(slotManager, nextFree);
        nextFree = this.basePattern.allocateSlots(slotManager, nextFree);
        return nextFree;
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        this.basePattern.promote(offer, parent);
        this.upperPattern.promote(offer, parent);
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        return item instanceof NodeInfo && this.matchesBeneathAnchor((NodeInfo)item, null, context);
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        if (!this.basePattern.matches(node, context)) {
            return false;
        }
        if (this.upperPattern != null) {
            block0 : switch (this.upwardsAxis) {
                case 9: {
                    NodeInfo par = node.getParent();
                    if (par == null) {
                        return false;
                    }
                    if (this.upperPattern.matchesBeneathAnchor(par, anchor, context)) break;
                    return false;
                }
                case 0: {
                    NodeInfo anc = node.getParent();
                    while (true) {
                        if (anc == null) {
                            return false;
                        }
                        if (this.upperPattern.matchesBeneathAnchor(anc, anchor, context)) break block0;
                        anc = anc.getParent();
                    }
                }
                case 1: {
                    NodeInfo anc = node;
                    while (true) {
                        if (anc == null) {
                            return false;
                        }
                        if (this.upperPattern.matchesBeneathAnchor(anc, anchor, context)) break block0;
                        anc = anc.getParent();
                    }
                }
                default: {
                    throw new XPathException("Unsupported axis " + AxisInfo.axisName[this.upwardsAxis] + " in pattern");
                }
            }
        }
        return true;
    }

    @Override
    public int getNodeKind() {
        return this.basePattern.getNodeKind();
    }

    @Override
    public int getFingerprint() {
        return this.basePattern.getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        if (this.refinedItemType != null) {
            return this.refinedItemType;
        }
        return this.basePattern.getItemType();
    }

    public boolean equals(Object other) {
        if (other instanceof AncestorQualifiedPattern) {
            AncestorQualifiedPattern aqp = (AncestorQualifiedPattern)other;
            return this.basePattern.equals(aqp.basePattern) && this.upperPattern.equals(aqp.upperPattern) && this.upwardsAxis == aqp.upwardsAxis;
        }
        return false;
    }

    public int hashCode() {
        return 0x158CB ^ this.basePattern.hashCode() ^ this.upperPattern.hashCode() ^ this.upwardsAxis << 22;
    }
}

