/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.util.Date;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public class ChannelSubsystem
extends ChannelSession {
    private final String subsystem;

    public ChannelSubsystem(String subsystem) {
        this.subsystem = ValidateUtils.checkNotNullAndNotEmpty((String)subsystem, (String)"Subsystem may not be null/empty");
    }

    public final String getSubsystem() {
        return this.subsystem;
    }

    @Override
    protected void doOpen() throws IOException {
        String systemName = this.getSubsystem();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({}) SSH_MSG_CHANNEL_REQUEST subsystem={}", (Object)this, (Object)systemName);
        }
        Session session = this.getSession();
        boolean wantReply = (Boolean)CoreModuleProperties.REQUEST_SUBSYSTEM_REPLY.getRequired((PropertyResolver)this);
        Buffer buffer = session.createBuffer((byte)98, "subsystem".length() + systemName.length() + 32);
        buffer.putInt((long)this.getRecipient());
        buffer.putString("subsystem");
        buffer.putBoolean(wantReply);
        buffer.putString(systemName);
        this.addPendingRequest("subsystem", wantReply);
        this.writePacket(buffer);
        super.doOpen();
    }

    @Override
    public void handleSuccess() throws IOException {
        String systemName = this.getSubsystem();
        Date pending = this.removePendingRequest("subsystem");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSuccess({}) subsystem={}, pending since={}", new Object[]{this, systemName, pending});
        }
    }

    @Override
    public void handleFailure() throws IOException {
        String systemName = this.getSubsystem();
        Date pending = this.removePendingRequest("subsystem");
        if (pending != null) {
            this.log.warn("handleFailure({}) subsystem={}, pending since={}", new Object[]{this, systemName, pending});
            this.close(true);
        }
    }

    public void onClose(Runnable run) {
        this.closeFuture.addListener(future -> run.run());
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.getSubsystem() + "]";
    }
}

