/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.restrictions.ForwardingPrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.PrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.exceptions.InvalidRequestException;

final class ReversedPrimaryKeyRestrictions
extends ForwardingPrimaryKeyRestrictions {
    private PrimaryKeyRestrictions restrictions;

    public ReversedPrimaryKeyRestrictions(PrimaryKeyRestrictions restrictions) {
        this.restrictions = restrictions;
    }

    @Override
    public PrimaryKeyRestrictions mergeWith(Restriction restriction) throws InvalidRequestException {
        return new ReversedPrimaryKeyRestrictions(this.restrictions.mergeWith(restriction));
    }

    @Override
    public List<ByteBuffer> bounds(CFMetaData cfm, Bound bound, QueryOptions options) throws InvalidRequestException {
        List<ByteBuffer> buffers = this.restrictions.bounds(cfm, bound.reverse(), options);
        Collections.reverse(buffers);
        return buffers;
    }

    @Override
    public List<Composite> boundsAsComposites(CFMetaData cfm, Bound bound, QueryOptions options) throws InvalidRequestException {
        List<Composite> composites = this.restrictions.boundsAsComposites(cfm, bound.reverse(), options);
        Collections.reverse(composites);
        return composites;
    }

    @Override
    public boolean isInclusive(Bound bound) {
        return this.restrictions.isInclusive(bound.reverse());
    }

    @Override
    protected PrimaryKeyRestrictions getDelegate() {
        return this.restrictions;
    }
}

