/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso;

import com.epam.parso.Column;
import com.epam.parso.ColumnFormat;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;

public final class DataWriterUtil {
    private static final int ACCURACY = 15;
    private static final String BYTE_ARRAY_CLASS_NAME = new byte[0].getClass().getName();
    private static final String ENCODING = "CP1252";
    private static final int ROUNDING_LENGTH = 13;
    private static final String DOUBLE_INFINITY_STRING = "Infinity";
    private static final String HOURS_OUTPUT_FORMAT = "%02d";
    private static final String MINUTES_OUTPUT_FORMAT = "%02d";
    private static final String SECONDS_OUTPUT_FORMAT = "%02d";
    private static final String TIME_DELIMETER = ":";
    private static final List<String> TIME_FORMAT_STRINGS = Arrays.asList("TIME", "HHMM");
    private static final String PERCENT_FORMAT = "PERCENT";
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int MINUTES_IN_HOUR = 60;
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final String UNKNOWN_DATE_FORMAT_EXCEPTION = "Unknown date format";
    private static final Map<String, String> DATE_OUTPUT_FORMAT_STRINGS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("B8601DA", "yyyyMMdd");
            this.put("E8601DA", "yyyy-MM-dd");
            this.put("DATE", "ddMMMyyyy");
            this.put("DAY", "dd");
            this.put("DDMMYY", "dd/MM/yyyy");
            this.put("DDMMYYB", "dd MM yyyy");
            this.put("DDMMYYC", "dd:MM:yyyy");
            this.put("DDMMYYD", "dd-MM-yyyy");
            this.put("DDMMYYN", "ddMMyyyy");
            this.put("DDMMYYP", "dd.MM.yyyy");
            this.put("DDMMYYS", "dd/MM/yyyy");
            this.put("JULDAY", "D");
            this.put("JULIAN", "yyyyD");
            this.put("MMDDYY", "MM/dd/yyyy");
            this.put("MMDDYYB", "MM dd yyyy");
            this.put("MMDDYYC", "MM:dd:yyyy");
            this.put("MMDDYYD", "MM-dd-yyyy");
            this.put("MMDDYYN", "MMddyyyy");
            this.put("MMDDYYP", "MM.dd.yyyy");
            this.put("MMDDYYS", "MM/dd/yyyy");
            this.put("MMYY", "MM'M'yyyy");
            this.put("MMYYC", "MM:yyyy");
            this.put("MMYYD", "MM-yyyy");
            this.put("MMYYN", "MMyyyy");
            this.put("MMYYP", "MM.yyyy");
            this.put("MMYYS", "MM/yyyy");
            this.put("MONNAME", "MMMM");
            this.put("MONTH", "M");
            this.put("MONYY", "MMMyyyy");
            this.put("WEEKDATE", "EEEE, MMMM dd, yyyy");
            this.put("WEEKDATX", "EEEE, dd MMMM, yyyy");
            this.put("WEEKDAY", "u");
            this.put("DOWNAME", "EEEE");
            this.put("WORDDATE", "MMMM d, yyyy");
            this.put("WORDDATX", "d MMMM yyyy");
            this.put("YYMM", "yyyy'M'MM");
            this.put("YYMMC", "yyyy:MM");
            this.put("YYMMD", "yyyy-MM");
            this.put("YYMMN", "yyyyMM");
            this.put("YYMMP", "yyyy.MM");
            this.put("YYMMS", "yyyy/MM");
            this.put("YYMMDD", "yyyy-MM-dd");
            this.put("YYMMDDB", "yyyy MM dd");
            this.put("YYMMDDC", "yyyy:MM:dd");
            this.put("YYMMDDD", "yyyy-MM-dd");
            this.put("YYMMDDN", "yyyyMMdd");
            this.put("YYMMDDP", "yyyy.MM.dd");
            this.put("YYMMDDS", "yyyy/MM/dd");
            this.put("YYMON", "yyyyMMM");
            this.put("YEAR", "yyyy");
            this.put("B8601DN", "yyyyMMdd");
            this.put("B8601DT", "yyyyMMdd'T'HHmmssSSS");
            this.put("B8601DX", "yyyyMMdd'T'HHmmssZ");
            this.put("B8601DZ", "yyyyMMdd'T'HHmmssZ");
            this.put("B8601LX", "yyyyMMdd'T'HHmmssZ");
            this.put("E8601DN", "yyyy-MM-dd");
            this.put("E8601DT", "yyyy-MM-dd'T'HH:mm:ss.SSS");
            this.put("E8601DX", "yyyy-MM-dd'T'HH:mm:ssZ");
            this.put("E8601DZ", "yyyy-MM-dd'T'HH:mm:ssZ");
            this.put("E8601LX", "yyyy-MM-dd'T'HH:mm:ssZ");
            this.put("DATEAMPM", "ddMMMyyyy:HH:mm:ss.SS a");
            this.put("DATETIME", "ddMMMyyyy:HH:mm:ss.SS");
            this.put("DTDATE", "ddMMMyyyy");
            this.put("DTMONYY", "MMMyyyy");
            this.put("DTWKDATX", "EEEE, dd MMMM, yyyy");
            this.put("DTYEAR", "yyyy");
            this.put("MDYAMPM", "MM/dd/yyyy H:mm a");
            this.put("TOD", "HH:mm:ss.SS");
        }
    });

    private DataWriterUtil() {
    }

    private static String processEntry(Column column, Object entry, Locale locale, Map<Integer, Format> columnFormatters) throws IOException {
        if (!String.valueOf(entry).contains(DOUBLE_INFINITY_STRING)) {
            String valueToPrint;
            if (entry.getClass() == Date.class) {
                valueToPrint = DataWriterUtil.convertDateElementToString((Date)entry, (SimpleDateFormat)columnFormatters.computeIfAbsent(column.getId(), e -> DataWriterUtil.getDateFormatProcessor(column.getFormat(), locale)));
            } else if (TIME_FORMAT_STRINGS.contains(column.getFormat().getName())) {
                valueToPrint = DataWriterUtil.convertTimeElementToString((Long)entry);
            } else if (PERCENT_FORMAT.equals(column.getFormat().getName())) {
                valueToPrint = DataWriterUtil.convertPercentElementToString(entry, (DecimalFormat)columnFormatters.computeIfAbsent(column.getId(), e -> DataWriterUtil.getPercentFormatProcessor(column.getFormat(), locale)));
            } else {
                valueToPrint = String.valueOf(entry);
                if (entry.getClass() == Double.class) {
                    valueToPrint = DataWriterUtil.convertDoubleElementToString((Double)entry);
                }
            }
            return valueToPrint;
        }
        return "";
    }

    private static String convertDateElementToString(Date currentDate, SimpleDateFormat dateFormat) {
        return currentDate.getTime() != 0L ? dateFormat.format(currentDate.getTime()) : "";
    }

    private static String convertTimeElementToString(Long secondsFromMidnight) {
        return String.format("%02d", secondsFromMidnight / 60L / 60L) + TIME_DELIMETER + String.format("%02d", secondsFromMidnight / 60L % 60L) + TIME_DELIMETER + String.format("%02d", secondsFromMidnight % 60L);
    }

    private static String convertDoubleElementToString(Double value) {
        String valueToPrint = String.valueOf(value);
        if (valueToPrint.length() > 13) {
            int lengthBeforeDot = (int)Math.ceil(Math.log10(Math.abs(value)));
            BigDecimal bigDecimal = new BigDecimal(value);
            bigDecimal = bigDecimal.setScale(15 - lengthBeforeDot, 4);
            valueToPrint = String.valueOf(bigDecimal.doubleValue());
        }
        valueToPrint = DataWriterUtil.trimZerosFromEnd(valueToPrint);
        return valueToPrint;
    }

    private static String convertPercentElementToString(Object value, DecimalFormat decimalFormat) {
        Double doubleValue = value instanceof Long ? ((Long)value).doubleValue() : ((Double)value).doubleValue();
        return decimalFormat.format(doubleValue);
    }

    private static String trimZerosFromEnd(String string) {
        return string.contains(".") ? string.replaceAll("0*$", "").replaceAll("\\.$", "") : string;
    }

    public static List<String> getRowValues(List<Column> columns, Object[] row, Locale locale, Map<Integer, Format> columnFormatters) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        for (int currentColumnIndex = 0; currentColumnIndex < columns.size(); ++currentColumnIndex) {
            values.add(DataWriterUtil.getValue(columns.get(currentColumnIndex), row[currentColumnIndex], locale, columnFormatters));
        }
        return values;
    }

    public static List<String> getRowValues(List<Column> columns, Object[] row, Map<Integer, Format> columnFormatters) throws IOException {
        return DataWriterUtil.getRowValues(columns, row, DEFAULT_LOCALE, columnFormatters);
    }

    public static String getValue(Column column, Object entry, Locale locale, Map<Integer, Format> columnFormatters) throws IOException {
        String value = "";
        if (entry != null) {
            value = entry.getClass().getName().compareTo(BYTE_ARRAY_CLASS_NAME) == 0 ? new String((byte[])entry, ENCODING) : DataWriterUtil.processEntry(column, entry, locale, columnFormatters);
        }
        return value;
    }

    private static Format getPercentFormatProcessor(ColumnFormat columnFormat, Locale locale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        if (columnFormat.getPrecision() == 0) {
            return new DecimalFormat("0%", dfs);
        }
        String pattern = "0%." + new String(new char[columnFormat.getPrecision()]).replace("\u0000", "0");
        return new DecimalFormat(pattern, dfs);
    }

    private static Format getDateFormatProcessor(ColumnFormat columnFormat, Locale locale) {
        if (!DATE_OUTPUT_FORMAT_STRINGS.containsKey(columnFormat.getName())) {
            throw new NoSuchElementException(UNKNOWN_DATE_FORMAT_EXCEPTION);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_OUTPUT_FORMAT_STRINGS.get(columnFormat.getName()), locale);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }
}

