/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.igoweb.go.Rules;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.Spinner;

public class RulesWidget
extends JPanel {
    public static final int FIELD_RULES = 0;
    public static final int FIELD_SIZE = 1;
    public static final int FIELD_HANDICAP = 2;
    public static final int FIELD_KOMI = 3;
    public static final int FIELD_TIMESYSTEM = 4;
    public static final int FIELD_MAINTIME = 5;
    public static final int FIELD_BYTIME = 6;
    public static final int FIELD_BYPERIODS = 7;
    public static final int FIELD_BYSTONES = 8;
    public static final int NUM_FIELDS = 9;
    private final Errout[] errorShown = new Errout[9];
    private final JComponent[] outs = new JComponent[9];
    private final JLabel[] disabled = new JLabel[9];
    private final JLabel[] labels = new JLabel[9];
    private final CardLayout byFlipper = new CardLayout();
    private final JPanel byPanel = new JPanel(this.byFlipper);
    private final boolean isEditable;
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    protected final TitledBorder timeSystemBorder = BorderFactory.createTitledBorder(Defs.getString(-451068480));
    private final InternalListener internalListener = new InternalListener();
    private Rules rules;
    private boolean ignoreGuiEvents = false;
    private boolean ignoreRulesEvents = false;
    private static final int[] errs = new int[9];
    private static final int[] minMaxSizes;

    protected RulesWidget(Rules newRules, boolean isEditable) {
        this.rules = newRules;
        this.isEditable = isEditable;
    }

    public RulesWidget(Rules rules, boolean showRules, boolean showTime, boolean isEditable) {
        this(rules, isEditable);
        this.addWidgets(showRules, showTime);
    }

    protected void addWidgets(boolean showRules, boolean showTime) {
        if (showTime) {
            if (showRules) {
                this.setLayout(new GridLayout(1, 2));
                JPanel panel = new JPanel();
                this.setupGroup(panel, true);
                this.add(panel);
                panel = new JPanel();
                this.setupGroup(panel, false);
                this.add(panel);
            } else {
                this.setupGroup(this, false);
            }
            this.newTimeSystem();
        } else {
            this.setupGroup(this, true);
        }
    }

    private void handleComboBoxAction(JComboBox box) {
        int val = box.getSelectedIndex();
        if (box == this.outs[0]) {
            this.rules.setType(val);
            SpinModel hcapModel = (SpinModel)((Spinner)this.outs[2]).getModel();
            hcapModel.setLimits(0, this.getMaxHandicap());
            hcapModel.setErrorMessage(Defs.getString(-451068512, new Object[]{"{0}", new Integer(this.getMaxHandicap())}));
            this.disabled[0].setText(box.getSelectedItem().toString());
        } else {
            this.rules.setTimeSystem(val);
            this.disabled[4].setText(box.getSelectedItem().toString());
        }
    }

    protected void setupGroup(JPanel panel, boolean isRules) {
        int[] nArray;
        int field;
        panel.setLayout(new GCLayout());
        panel.setBorder(isRules ? BorderFactory.createTitledBorder(Defs.getString(-451068486)) : this.timeSystemBorder);
        int n = field = isRules ? 0 : 4;
        if (this.isEditable) {
            JComboBox<String> box;
            this.outs[field] = box = new JComboBox<String>();
            StringTokenizer tokens = new StringTokenizer(Defs.getString(isRules ? -1337055799 : -451068479), "|");
            while (tokens.hasMoreElements()) {
                box.addItem(tokens.nextToken());
            }
            this.setField(field);
            box.addActionListener(this.internalListener);
            this.disabled[field] = new JLabel();
            this.disabled[field].setOpaque(true);
            this.disabled[field].setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0x999999)), BorderFactory.createEmptyBorder(0, 3, 3, 0)));
            this.disabled[field].setEnabled(false);
            CardLayout cards = new CardLayout();
            JPanel underPanel = new JPanel(cards);
            underPanel.add("|", box);
            underPanel.add("x=0", this.disabled[field]);
            panel.add("x=0,xGrow=t,yGrow=f", underPanel);
        } else {
            ATextField out = new ATextField(this.getContents(field));
            out.setEditable(false);
            out.getDocument().addDocumentListener(this.internalListener);
            this.outs[field] = out;
            panel.add("x=0,xGrow=t,yGrow=f", out);
        }
        ++field;
        if (isRules) {
            int[] nArray2 = new int[3];
            nArray2[0] = -451068515;
            nArray2[1] = -451068502;
            nArray = nArray2;
            nArray2[2] = -451068501;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = -451068497;
            nArray3[1] = -451068507;
            nArray3[2] = -451068508;
            nArray = nArray3;
            nArray3[3] = -451068481;
        }
        int[] labelIds = nArray;
        for (int i = 0; i < labelIds.length; ++i) {
            this.labels[field] = new JLabel(Defs.getString(labelIds[i]), 0);
            if (this.isEditable) {
                this.outs[field] = this.buildWidget(field);
            } else {
                ATextField out = new ATextField();
                out.setEditable(false);
                this.outs[field] = out;
            }
            if (field >= 7) {
                JPanel innerPanel = new JPanel(new GCLayout());
                this.byPanel.add(Integer.toString(field), innerPanel);
                innerPanel.add("x=0,yGrow=f,xGrow=t", this.labels[field]);
                innerPanel.add("x=0", this.outs[field]);
            } else {
                panel.add("x=0,yGrow=f", this.labels[field]);
                panel.add("x=0,yGrow=t", this.outs[field]);
            }
            this.setField(field);
            ++field;
        }
        if (this.byPanel != null) {
            panel.add("x=0,yGrow=f", this.byPanel);
        }
    }

    private JComponent buildWidget(final int field) {
        Spinner spinner = new Spinner(new SpinModel(field), "", 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RulesWidget.this.userInputError(field, event.getActionCommand());
            }
        });
        spinner.addActionListener(this.internalListener);
        return spinner;
    }

    public boolean verifyInput() {
        return this.verifyInput(true);
    }

    public boolean verifyInput(boolean showErrors) {
        for (int field = 0; field < 9; ++field) {
            if (this.outs[field] == null || !(this.outs[field] instanceof Spinner) || !this.isEditable(field)) continue;
            Spinner spinner = (Spinner)this.outs[field];
            SpinModel model = (SpinModel)spinner.model;
            try {
                int result = model.getVal(spinner);
                switch (field) {
                    case 1: {
                        this.rules.setSize(result);
                        break;
                    }
                    case 2: {
                        this.rules.setHandicap(result);
                        break;
                    }
                    case 3: {
                        this.rules.setKomi(0.5f * (float)result);
                        break;
                    }
                    case 5: {
                        this.rules.setMainTime(result);
                        break;
                    }
                    case 6: {
                        this.rules.setByoYomiTime(result);
                        break;
                    }
                    case 7: {
                        this.rules.setByoYomiPeriods(result);
                        break;
                    }
                    case 8: {
                        this.rules.setByoYomiStones(result);
                    }
                }
                continue;
            }
            catch (IllegalArgumentException excep) {
                if (showErrors) {
                    this.userInputError(field, Defs.getString(-451068465));
                }
                return false;
            }
            catch (Spinner.BadInputException excep) {
                if (showErrors) {
                    this.userInputError(field, excep.getMessage());
                }
                return false;
            }
        }
        return true;
    }

    private void newTimeSystem() {
        if (this.byPanel != null) {
            int timeSystem = this.rules.getTimeSystem();
            if (timeSystem == 2) {
                this.byFlipper.first(this.byPanel);
            } else {
                this.byFlipper.last(this.byPanel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setField(int field) {
        JComponent toSet = this.outs[field];
        if (toSet == null) {
            return;
        }
        boolean usable = this.isUsable(field);
        toSet.setEnabled(usable && (this.isEditable(field) || toSet instanceof ATextField));
        if (this.labels[field] != null) {
            this.labels[field].setEnabled(usable);
        }
        if (this.disabled[field] != null) {
            Container parent = toSet.getParent();
            CardLayout layout = (CardLayout)parent.getLayout();
            if (toSet.isEnabled()) {
                layout.first(parent);
            } else {
                layout.last(parent);
            }
        }
        if (!usable) {
            return;
        }
        this.ignoreGuiEvents = true;
        try {
            String val = this.getContents(field);
            if (toSet instanceof ATextField) {
                ((ATextField)toSet).setText(val);
            } else if (toSet instanceof Spinner) {
                ((Spinner)toSet).setText(val);
            } else {
                JComboBox combo = (JComboBox)toSet;
                combo.setSelectedIndex(field == 0 ? this.rules.getType() : this.rules.getTimeSystem());
                if (this.disabled[field] != null) {
                    this.disabled[field].setText((String)combo.getSelectedItem());
                }
            }
        }
        finally {
            this.ignoreGuiEvents = false;
        }
    }

    private String getContents(int field) {
        switch (field) {
            case 0: {
                StringTokenizer tokens = new StringTokenizer(Defs.getString(-1337055799), "|");
                for (int i = 0; i < this.rules.getType(); ++i) {
                    tokens.nextToken();
                }
                return tokens.nextToken();
            }
            case 1: {
                return this.numberFormat.format(this.rules.getSize());
            }
            case 2: {
                return this.numberFormat.format(this.rules.getHandicap());
            }
            case 3: {
                return this.numberFormat.format(this.rules.getKomi());
            }
            case 4: {
                StringTokenizer tokens = new StringTokenizer(Defs.getString(-451068479), "|");
                for (int i = 0; i < this.rules.getTimeSystem(); ++i) {
                    tokens.nextToken();
                }
                return tokens.nextToken();
            }
            case 5: {
                return Defs.formatTime(this.rules.getMainTime());
            }
            case 6: {
                return Defs.formatTime(this.rules.getByoYomiTime());
            }
            case 7: {
                return this.numberFormat.format(this.rules.getByoYomiPeriods());
            }
            case 8: {
                return this.numberFormat.format(this.rules.getByoYomiStones());
            }
        }
        throw new IllegalArgumentException();
    }

    protected boolean isEditable(int field) {
        return this.isUsable(field);
    }

    protected boolean isUsable(int field) {
        switch (field) {
            case 5: {
                return this.rules.getTimeSystem() != 0;
            }
            case 6: {
                return this.rules.getTimeSystem() > 1;
            }
            case 7: {
                return this.rules.getTimeSystem() == 2;
            }
            case 8: {
                return this.rules.getTimeSystem() == 3;
            }
        }
        return true;
    }

    @Override
    public void removeNotify() {
        this.rules.removeListener(this.internalListener);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        for (int i = 0; i < 9; ++i) {
            this.setField(i);
        }
        this.rules.addListener(this.internalListener);
        super.addNotify();
    }

    protected float getMaxKomi() {
        return 1444.0f;
    }

    protected int getMaxHandicap() {
        return this.rules.isFixedHandicap() ? 9 : 10000;
    }

    private void userInputError(int field, String message) {
        if (this.errorShown[field] != null) {
            this.errorShown[field].dispose();
        }
        this.errorShown[field] = new Errout(message, (JFrame)this.getTopLevelAncestor());
    }

    public Rules getRules() {
        return this.rules;
    }

    public void setRules(Rules newRules) {
        if (newRules != this.rules) {
            this.rules.removeListener(this.internalListener);
            this.rules = newRules;
            this.rules.addListener(this.internalListener);
            for (int i = 0; i < 9; ++i) {
                this.setField(i);
            }
            this.newTimeSystem();
        }
    }

    public void setHighlight(int field, boolean isHighlight) {
        if (this.outs[field] instanceof Spinner) {
            ((Spinner)this.outs[field]).getTextWidget().setBackground(isHighlight ? UIManager.getColor("org.igoweb.highlightBg") : UIManager.getColor("org.igoweb.inputBg"));
        } else if (this.outs[field] instanceof JComboBox) {
            Color color = isHighlight ? UIManager.getColor("org.igoweb.highlightBg") : UIManager.getColor("ComboBox.background");
            this.outs[field].setBackground(color);
            this.disabled[field].setBackground(color);
        } else {
            this.outs[field].setBackground(isHighlight ? UIManager.getColor("org.igoweb.highlightBg") : UIManager.getColor("ComboBox.background"));
        }
    }

    protected TitledBorder getTimeSystemBorder() {
        return this.timeSystemBorder;
    }

    protected void addFieldChangeListener(int field, ActionListener listener) {
        if (this.outs[field] instanceof JComboBox) {
            ((JComboBox)this.outs[field]).addActionListener(listener);
        } else {
            ((Spinner)this.outs[field]).addActionListener(listener);
        }
    }

    public JComponent getWidget(int fieldNum) {
        return this.outs[fieldNum];
    }

    static {
        RulesWidget.errs[1] = -451068514;
        RulesWidget.errs[5] = -451068509;
        RulesWidget.errs[6] = -451068509;
        RulesWidget.errs[7] = -451068513;
        RulesWidget.errs[8] = -451068513;
        minMaxSizes = new int[]{-1, -1, 2, 38, 0, 0, 0, 0, -1, -1, 0, Integer.MAX_VALUE, 1, Integer.MAX_VALUE, 1, Integer.MAX_VALUE, 1, Integer.MAX_VALUE};
    }

    private class SpinModel
    extends Spinner.DefaultModel {
        private final int field;

        public SpinModel(int field) {
            this.field = field;
            if (field == 3) {
                this.setErrorMessage(Defs.getString(-451068511, new Object[]{"{0}", new Float(-RulesWidget.this.getMaxKomi()), new Float(RulesWidget.this.getMaxKomi())}));
                this.setLimits(-2 * (int)RulesWidget.this.getMaxKomi(), 2 * (int)RulesWidget.this.getMaxKomi());
            } else if (field == 2) {
                this.setErrorMessage(Defs.getString(-451068512, new Object[]{"{0}", new Integer(RulesWidget.this.getMaxHandicap())}));
                this.setLimits(0, RulesWidget.this.getMaxHandicap());
            } else {
                this.setErrorMessage(Defs.getString(errs[field]));
                this.setLimits(minMaxSizes[field * 2], minMaxSizes[field * 2 + 1]);
            }
        }

        @Override
        public boolean incrementOK(Spinner spinner) {
            if (this.field != 1) {
                return super.incrementOK(spinner);
            }
            try {
                return this.getVal(spinner) < 19;
            }
            catch (Spinner.BadInputException excep) {
                return true;
            }
        }

        @Override
        public boolean decrementOK(Spinner spinner) {
            if (this.field != 1) {
                return super.decrementOK(spinner);
            }
            try {
                return this.getVal(spinner) > 9;
            }
            catch (Spinner.BadInputException excep) {
                return true;
            }
        }

        @Override
        public String increment(Spinner spinner) throws Spinner.BadInputException {
            int val = this.getVal(spinner);
            switch (this.field) {
                case 1: {
                    if (val < 9) {
                        val = 9;
                        break;
                    }
                    if (val < 13) {
                        val = 13;
                        break;
                    }
                    if (val >= 19) break;
                    val = 19;
                    break;
                }
                case 2: {
                    if (++val == 1) {
                        val = 2;
                    }
                    if (val <= 9) break;
                    val = 9;
                    break;
                }
                case 3: {
                    float fVal = (float)val * 0.5f;
                    if (fVal < RulesWidget.this.rules.getDefaultKomi() && fVal >= 0.5f) {
                        fVal = RulesWidget.this.rules.getDefaultKomi();
                    } else if ((fVal = (float)Math.ceil((double)(fVal * 0.2f) + 0.1) * 5.0f + 0.5f) > RulesWidget.this.getMaxKomi()) {
                        fVal = RulesWidget.this.getMaxKomi();
                    }
                    return RulesWidget.this.numberFormat.format(fVal);
                }
                case 5: {
                    val = val < 60 ? 60 : (val / 300 + 1) * 300;
                    return Defs.formatTime(val);
                }
                case 6: {
                    val = RulesWidget.this.rules.getTimeSystem() == 2 ? (val / 10 + 1) * 10 : (val / 60 + 1) * 60;
                    return Defs.formatTime(val);
                }
                case 7: {
                    ++val;
                    break;
                }
                case 8: {
                    val = (val / 5 + 1) * 5;
                }
            }
            return RulesWidget.this.numberFormat.format(val);
        }

        @Override
        public String decrement(Spinner spinner) throws Spinner.BadInputException {
            int val = this.getVal(spinner);
            switch (this.field) {
                case 1: {
                    if (val > 19) {
                        val = 19;
                        break;
                    }
                    if (val > 13) {
                        val = 13;
                        break;
                    }
                    if (val <= 9) break;
                    val = 9;
                    break;
                }
                case 2: {
                    if (--val > 1) break;
                    val = 0;
                    break;
                }
                case 3: {
                    float fVal = (float)val * 0.5f;
                    if (fVal > RulesWidget.this.rules.getDefaultKomi() && fVal <= 10.5f) {
                        fVal = RulesWidget.this.rules.getDefaultKomi();
                    } else if (fVal == RulesWidget.this.rules.getDefaultKomi()) {
                        fVal = 0.5f;
                    } else if ((fVal = (float)Math.floor(fVal * 0.2f - 0.2f) * 5.0f + 0.5f) < -RulesWidget.this.getMaxKomi()) {
                        fVal = -RulesWidget.this.getMaxKomi();
                    }
                    return RulesWidget.this.numberFormat.format(fVal);
                }
                case 5: {
                    if (val <= 300 && val > 60) {
                        val = 60;
                    } else if (val > 0) {
                        val = (val - 1) / 300 * 300;
                    }
                    if (RulesWidget.this.rules.getTimeSystem() == 1 && val <= 0) {
                        val = 60;
                    }
                    return Defs.formatTime(val);
                }
                case 6: {
                    if (RulesWidget.this.rules.getTimeSystem() == 2) {
                        if ((val = (val - 1) / 10 * 10) <= 0) {
                            val = 10;
                        }
                    } else if ((val = (val - 1) / 60 * 60) <= 0) {
                        val = 60;
                    }
                    return Defs.formatTime(val);
                }
                case 7: {
                    if (--val >= 1) break;
                    val = 1;
                    break;
                }
                case 8: {
                    if (val > 0) {
                        val = (val - 1) / 5 * 5;
                    }
                    if (val >= 1) break;
                    val = 1;
                }
            }
            return RulesWidget.this.numberFormat.format(val);
        }

        @Override
        public int getVal(Spinner spinner) throws Spinner.BadInputException {
            int result;
            try {
                switch (this.field) {
                    case 1: {
                        result = super.getVal(spinner);
                        if (result < 2 || result > 38) {
                            throw this.error(spinner);
                        }
                        break;
                    }
                    case 2: {
                        result = super.getVal(spinner);
                        if (result < 0 || result == 1 || result > RulesWidget.this.getMaxHandicap()) {
                            throw this.error(spinner);
                        }
                        break;
                    }
                    case 3: {
                        float f = RulesWidget.this.numberFormat.parse(spinner.getText().trim()).floatValue() * 2.0f;
                        if (f < -RulesWidget.this.getMaxKomi() * 2.0f || f > RulesWidget.this.getMaxKomi() * 2.0f) {
                            throw this.error(spinner);
                        }
                        result = (int)f;
                        if ((float)result != f) {
                            throw this.error(spinner);
                        }
                        break;
                    }
                    case 5: 
                    case 6: {
                        result = Defs.parseTime(spinner.getText().trim());
                        if (result < 0 || result == 0 && (RulesWidget.this.rules.getTimeSystem() == 1 || this.field == 6)) {
                            throw this.error(spinner);
                        }
                        break;
                    }
                    case 7: 
                    case 8: {
                        result = super.getVal(spinner);
                        if (result < 0) {
                            throw this.error(spinner);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            catch (ParseException excep) {
                throw this.error(spinner);
            }
            catch (NumberFormatException excep2) {
                throw this.error(spinner);
            }
            return result;
        }
    }

    private class InternalListener
    implements EventListener,
    ActionListener,
    DocumentListener {
        private InternalListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (!RulesWidget.this.ignoreRulesEvents) {
                int type = event.type;
                if (type == 4) {
                    RulesWidget.this.newTimeSystem();
                }
                RulesWidget.this.setField(type - 0);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!RulesWidget.this.ignoreGuiEvents) {
                if (event.getSource() instanceof JComboBox) {
                    RulesWidget.this.handleComboBoxAction((JComboBox)event.getSource());
                } else if (event.getSource() instanceof Spinner) {
                    RulesWidget.this.ignoreRulesEvents = true;
                    try {
                        RulesWidget.this.verifyInput(false);
                    }
                    finally {
                        RulesWidget.this.ignoreRulesEvents = false;
                    }
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            if (!RulesWidget.this.ignoreGuiEvents) {
                RulesWidget.this.verifyInput(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            if (!RulesWidget.this.ignoreGuiEvents) {
                RulesWidget.this.verifyInput(false);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            if (!RulesWidget.this.ignoreGuiEvents) {
                RulesWidget.this.verifyInput(false);
            }
        }
    }
}

