/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xmlresolver.Resolver;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.utils.URIUtils;

public class ResolvingXMLFilter
extends XMLFilterImpl {
    protected final ResolverLogger logger;
    private boolean allowXMLCatalogPI = true;
    private boolean processXMLCatalogPI = false;
    protected static Resolver staticResolver = null;
    protected Resolver resolver = null;
    private URI baseURI = null;

    public ResolvingXMLFilter() {
        if (staticResolver == null) {
            staticResolver = new Resolver();
        }
        this.resolver = staticResolver;
        this.allowXMLCatalogPI = this.resolver.getConfiguration().getFeature(ResolverFeature.ALLOW_CATALOG_PI);
        this.logger = this.resolver.getConfiguration().getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public ResolvingXMLFilter(Resolver resolver) {
        this.resolver = resolver;
        this.allowXMLCatalogPI = resolver.getConfiguration().getFeature(ResolverFeature.ALLOW_CATALOG_PI);
        this.logger = resolver.getConfiguration().getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public ResolvingXMLFilter(XMLReader parent, Resolver resolver) {
        super(parent);
        this.resolver = resolver;
        this.logger = resolver.getConfiguration().getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        Resolver localResolver = this.resolver;
        try {
            InputSource src;
            if (this.allowXMLCatalogPI) {
                XMLResolverConfiguration config = this.resolver.getConfiguration();
                config = new XMLResolverConfiguration(config);
                this.resolver = new Resolver(config);
            }
            this.processXMLCatalogPI = this.allowXMLCatalogPI;
            this.setupBaseURI(input.getSystemId());
            if (input.getByteStream() == null && input.getCharacterStream() == null && (src = this.resolver.resolveEntity(null, input.getSystemId())) != null) {
                input.setByteStream(src.getByteStream());
            }
            super.parse(input);
        }
        finally {
            this.resolver = localResolver;
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolver.resolveEntity(publicId, systemId);
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        return this.resolver.resolveEntity(name, publicId, baseURI, systemId);
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.processXMLCatalogPI = false;
        super.notationDecl(name, publicId, systemId);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.processXMLCatalogPI = false;
        super.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.processXMLCatalogPI = false;
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void processingInstruction(String target, String pidata) throws SAXException {
        if (this.processXMLCatalogPI && target.equals("oasis-xml-catalog")) {
            URI catalog = null;
            String data = pidata;
            int pos = data.indexOf("catalog=");
            if (pos >= 0 && (data = data.substring(pos + 8)).length() > 1) {
                String quote = data.substring(0, 1);
                pos = (data = data.substring(1)).indexOf(quote);
                if (pos >= 0) {
                    data = data.substring(0, pos);
                    try {
                        catalog = this.baseURI != null ? this.baseURI.resolve(data) : URIUtils.newURI(data);
                        this.resolver.getConfiguration().addCatalog(catalog.toString());
                    }
                    catch (URISyntaxException mue) {
                        this.logger.log("warning", "URI syntax exception resolving PI catalog: %s", data);
                    }
                }
            }
        } else {
            super.processingInstruction(target, pidata);
        }
    }

    private void setupBaseURI(String systemId) {
        try {
            this.baseURI = URIUtils.newURI(systemId);
            if (!this.baseURI.isAbsolute()) {
                this.baseURI = URIUtils.cwd().resolve(this.baseURI);
            }
        }
        catch (URISyntaxException use) {
            this.baseURI = URIUtils.cwd().resolve(systemId);
        }
    }
}

