/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Permission;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.stream.EncodedStream;

public class BootstrapSecurityManager
extends SecurityManager {
    private boolean initialised;
    private final URLClassLoader target;

    public BootstrapSecurityManager() {
        this(null);
    }

    BootstrapSecurityManager(URLClassLoader target) {
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPermission(Permission permission) {
        String securityManagerType;
        BootstrapSecurityManager bootstrapSecurityManager = this;
        synchronized (bootstrapSecurityManager) {
            if (this.initialised) {
                return;
            }
            if (System.in == null) {
                return;
            }
            this.initialised = true;
        }
        System.clearProperty("java.security.manager");
        System.setSecurityManager(null);
        URLClassLoader systemClassLoader = this.target != null ? this.target : (URLClassLoader)this.getClass().getClassLoader();
        try {
            Method addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrlMethod.setAccessible(true);
            DataInputStream inputStream = new DataInputStream((InputStream)new EncodedStream.EncodedInput(System.in));
            int count = inputStream.readInt();
            StringBuilder classpathStr = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                String entry = inputStream.readUTF();
                File file = new File(entry);
                addUrlMethod.invoke((Object)systemClassLoader, file.toURI().toURL());
                if (i > 0) {
                    classpathStr.append(File.pathSeparator);
                }
                classpathStr.append(file.toString());
            }
            System.setProperty("java.class.path", classpathStr.toString());
            securityManagerType = inputStream.readUTF();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialise system classpath.", e);
        }
        if (securityManagerType.length() > 0) {
            SecurityManager securityManager;
            System.setProperty("java.security.manager", securityManagerType);
            try {
                Class<?> aClass = systemClassLoader.loadClass(securityManagerType);
                securityManager = (SecurityManager)JavaReflectionUtil.newInstance(aClass);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create an instance of '" + securityManagerType + "' specified for system SecurityManager.", e);
            }
            System.setSecurityManager(securityManager);
        }
    }
}

