/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.RtcpFbNackPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.RtcpFbNackPacketBuilder;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aB5\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0005R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/nlj/rtcp/RetransmissionRequester;", "", "rtcpSender", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ScheduledExecutorService;Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "logger", "streamPacketRequesters", "", "", "Lorg/jitsi/nlj/rtcp/RetransmissionRequester$StreamPacketRequester;", "packetReceived", "ssrc", "seqNum", "", "stop", "StreamPacketRequester", "PacketRetransmissionRequest", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRetransmissionRequester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetransmissionRequester.kt\norg/jitsi/nlj/rtcp/RetransmissionRequester\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1863#2,2:244\n*S KotlinDebug\n*F\n+ 1 RetransmissionRequester.kt\norg/jitsi/nlj/rtcp/RetransmissionRequester\n*L\n58#1:244,2\n*E\n"})
public final class RetransmissionRequester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<RtcpPacket, Unit> rtcpSender;
    @NotNull
    private final ScheduledExecutorService scheduler;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Long, StreamPacketRequester> streamPacketRequesters;
    private static final int MAX_REQUESTS = 10;
    private static final Duration REQUEST_INTERVAL = Duration.ofMillis(150L);

    public RetransmissionRequester(@NotNull Function1<? super RtcpPacket, Unit> rtcpSender, @NotNull ScheduledExecutorService scheduler, @NotNull Logger parentLogger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(rtcpSender, "rtcpSender");
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.rtcpSender = rtcpSender;
        this.scheduler = scheduler;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.streamPacketRequesters = new HashMap();
    }

    public /* synthetic */ RetransmissionRequester(Function1 function1, ScheduledExecutorService scheduledExecutorService, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            clock = Clock.systemUTC();
        }
        this(function1, scheduledExecutorService, logger, clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void packetReceived(long ssrc, int seqNum) {
        StreamPacketRequester streamPacketRequester;
        Map<Long, StreamPacketRequester> map = this.streamPacketRequesters;
        synchronized (map) {
            boolean bl = false;
            StreamPacketRequester streamPacketRequester2 = this.streamPacketRequesters.computeIfAbsent(ssrc, arg_0 -> RetransmissionRequester.packetReceived$lambda$2$lambda$1(arg_0 -> RetransmissionRequester.packetReceived$lambda$2$lambda$0(this, arg_0), arg_0));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var5_3
            streamPacketRequester = streamPacketRequester2;
        }
        Intrinsics.checkNotNullExpressionValue(streamPacketRequester, "synchronized(...)");
        StreamPacketRequester streamPacketRequester3 = streamPacketRequester;
        streamPacketRequester3.packetReceived(seqNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Map<Long, StreamPacketRequester> map = this.streamPacketRequesters;
        synchronized (map) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.streamPacketRequesters.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StreamPacketRequester p0 = (StreamPacketRequester)element$iv;
                boolean bl2 = false;
                p0.stop();
            }
            this.streamPacketRequesters.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final StreamPacketRequester packetReceived$lambda$2$lambda$0(RetransmissionRequester this$0, Long key) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(key, "key");
        return new StreamPacketRequester(key, this$0.scheduler, this$0.clock, this$0.rtcpSender, this$0.logger, 0, 32, null);
    }

    private static final StreamPacketRequester packetReceived$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (StreamPacketRequester)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jitsi/nlj/rtcp/RetransmissionRequester$Companion;", "", "<init>", "()V", "MAX_REQUESTS", "", "REQUEST_INTERVAL", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/nlj/rtcp/RetransmissionRequester$PacketRetransmissionRequest;", "", "seqNum", "", "<init>", "(I)V", "getSeqNum", "()I", "value", "numTimesRequested", "getNumTimesRequested", "Ljava/time/Instant;", "firstRequestTimestamp", "getFirstRequestTimestamp", "()Ljava/time/Instant;", "requested", "", "timestamp", "jitsi-media-transform"})
    private static final class PacketRetransmissionRequest {
        private final int seqNum;
        private int numTimesRequested;
        @NotNull
        private Instant firstRequestTimestamp;

        public PacketRetransmissionRequest(int seqNum) {
            this.seqNum = seqNum;
            Instant instant = Instant.MIN;
            Intrinsics.checkNotNullExpressionValue(instant, "MIN");
            this.firstRequestTimestamp = instant;
        }

        public final int getSeqNum() {
            return this.seqNum;
        }

        public final int getNumTimesRequested() {
            return this.numTimesRequested;
        }

        @NotNull
        public final Instant getFirstRequestTimestamp() {
            return this.firstRequestTimestamp;
        }

        public final void requested(@NotNull Instant timestamp) {
            Intrinsics.checkNotNullParameter(timestamp, "timestamp");
            if (Intrinsics.areEqual(this.firstRequestTimestamp, Instant.MIN)) {
                this.firstRequestTimestamp = timestamp;
            }
            int n = this.numTimesRequested;
            this.numTimesRequested = n + 1;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020\u000bJ\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u000bH\u0002J\u001e\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0(H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0*H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jitsi/nlj/rtcp/RetransmissionRequester$StreamPacketRequester;", "", "ssrc", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "clock", "Ljava/time/Clock;", "rtcpSender", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "maxMissingSeqNums", "", "<init>", "(JLjava/util/concurrent/ScheduledExecutorService;Ljava/time/Clock;Lkotlin/jvm/functions/Function1;Lorg/jitsi/utils/logging2/Logger;I)V", "getSsrc", "()J", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "highestReceivedSeqNum", "requests", "", "Lorg/jitsi/nlj/rtcp/RetransmissionRequester$PacketRetransmissionRequest;", "taskHandleLock", "currentTaskHandle", "Ljava/util/concurrent/ScheduledFuture;", "packetReceived", "seqNum", "stop", "updateWorkDueTime", "newWorkDueTs", "Ljava/time/Instant;", "doWork", "notifyNackSent", "timestamp", "nackedSeqNums", "", "getMissingSeqNums", "Ljava/util/SortedSet;", "Companion", "jitsi-media-transform"})
    @SourceDebugExtension(value={"SMAP\nRetransmissionRequester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetransmissionRequester.kt\norg/jitsi/nlj/rtcp/RetransmissionRequester$StreamPacketRequester\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n63#2,4:244\n63#2,4:248\n63#2,4:252\n63#2,4:256\n69#2,4:262\n63#2,4:266\n63#2,4:270\n63#2,4:274\n63#2,4:278\n63#2,4:282\n63#2,4:287\n63#2,4:291\n63#2,4:296\n1317#3,2:260\n1863#4:286\n1864#4:295\n1#5:300\n*S KotlinDebug\n*F\n+ 1 RetransmissionRequester.kt\norg/jitsi/nlj/rtcp/RetransmissionRequester$StreamPacketRequester\n*L\n93#1:244,4\n97#1:248,4\n101#1:252,4\n109#1:256,4\n121#1:262,4\n129#1:266,4\n147#1:270,4\n150#1:274,4\n154#1:278,4\n173#1:282,4\n195#1:287,4\n204#1:291,4\n211#1:296,4\n113#1:260,2\n189#1:286\n189#1:295\n*E\n"})
    public static final class StreamPacketRequester {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long ssrc;
        @NotNull
        private final ScheduledExecutorService scheduler;
        @NotNull
        private final Clock clock;
        @NotNull
        private final Function1<RtcpPacket, Unit> rtcpSender;
        private final int maxMissingSeqNums;
        @NotNull
        private AtomicBoolean running;
        @NotNull
        private final Logger logger;
        private int highestReceivedSeqNum;
        @NotNull
        private final Map<Integer, PacketRetransmissionRequest> requests;
        @NotNull
        private final Object taskHandleLock;
        @Nullable
        private ScheduledFuture<?> currentTaskHandle;
        @NotNull
        private static final Instant NO_REQUEST_DUE;

        public StreamPacketRequester(long ssrc, @NotNull ScheduledExecutorService scheduler, @NotNull Clock clock, @NotNull Function1<? super RtcpPacket, Unit> rtcpSender, @NotNull Logger parentLogger, int maxMissingSeqNums) {
            Intrinsics.checkNotNullParameter(scheduler, "scheduler");
            Intrinsics.checkNotNullParameter(clock, "clock");
            Intrinsics.checkNotNullParameter(rtcpSender, "rtcpSender");
            Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
            this.ssrc = ssrc;
            this.scheduler = scheduler;
            this.clock = clock;
            this.rtcpSender = rtcpSender;
            this.maxMissingSeqNums = maxMissingSeqNums;
            this.running = new AtomicBoolean(true);
            this.logger = LoggerExtensionsKt.createChildLogger(this, parentLogger, MapsKt.mapOf(TuplesKt.to("ssrc", String.valueOf(this.ssrc))));
            this.highestReceivedSeqNum = -1;
            this.requests = new HashMap();
            this.taskHandleLock = new Object();
        }

        public /* synthetic */ StreamPacketRequester(long l, ScheduledExecutorService scheduledExecutorService, Clock clock, Function1 function1, Logger logger, int n, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n2 & 0x20) != 0) {
                n = 100;
            }
            this(l, scheduledExecutorService, clock, function1, logger, n);
        }

        public final long getSsrc() {
            return this.ssrc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void packetReceived(int seqNum) {
            if (this.highestReceivedSeqNum == -1) {
                this.highestReceivedSeqNum = seqNum;
                return;
            }
            Map<Integer, PacketRetransmissionRequest> map = this.requests;
            synchronized (map) {
                boolean bl = false;
                if (seqNum == this.highestReceivedSeqNum) {
                    Logger $this$cdebug$iv = this.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        Logger logger = $this$cdebug$iv;
                        boolean bl2 = false;
                        logger.debug(this.ssrc + " packet " + seqNum + " was received, currently missing " + this.getMissingSeqNums());
                    }
                } else if (RtpUtilsKt.isOlderThan(seqNum, this.highestReceivedSeqNum)) {
                    Logger logger;
                    Logger $this$cdebug$iv = this.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        logger = $this$cdebug$iv;
                        boolean bl3 = false;
                        logger.debug(this.ssrc + " packet " + seqNum + " was received, currently missing " + this.getMissingSeqNums());
                    }
                    this.requests.remove(seqNum);
                    if (this.requests.isEmpty()) {
                        $this$cdebug$iv = this.logger;
                        $i$f$cdebug = false;
                        if ($this$cdebug$iv.isDebugEnabled()) {
                            logger = $this$cdebug$iv;
                            boolean bl4 = false;
                            logger.debug(this.ssrc + " no more missing seq nums, cancelling pending work");
                        }
                        this.updateWorkDueTime(NO_REQUEST_DUE);
                    }
                } else if (RtpUtilsKt.isNextAfter(seqNum, this.highestReceivedSeqNum)) {
                    this.highestReceivedSeqNum = seqNum;
                } else if (RtpUtilsKt.numPacketsTo(this.highestReceivedSeqNum, seqNum) < this.maxMissingSeqNums) {
                    Logger $this$cdebug$iv = this.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        Logger logger = $this$cdebug$iv;
                        boolean bl5 = false;
                        logger.debug(this.ssrc + " missing packet detected! Just received " + seqNum + ", last received was " + this.highestReceivedSeqNum);
                    }
                    Sequence<Integer> $this$forEach$iv = RtpUtils.Companion.sequenceNumbersBetween(this.highestReceivedSeqNum, seqNum);
                    boolean $i$f$forEach = false;
                    Iterator<Integer> bl5 = $this$forEach$iv.iterator();
                    while (bl5.hasNext()) {
                        Integer element$iv = bl5.next();
                        int missingSeqNum = ((Number)element$iv).intValue();
                        boolean bl6 = false;
                        PacketRetransmissionRequest request = new PacketRetransmissionRequest(missingSeqNum);
                        Integer n = missingSeqNum;
                        this.requests.put(n, request);
                        Instant instant = this.clock.instant();
                        Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
                        this.updateWorkDueTime(instant);
                    }
                    this.highestReceivedSeqNum = seqNum;
                } else {
                    Logger logger;
                    Logger $this$cwarn$iv = this.logger;
                    boolean $i$f$cwarn = false;
                    if ($this$cwarn$iv.isWarnEnabled()) {
                        logger = $this$cwarn$iv;
                        boolean bl7 = false;
                        logger.warn(this.ssrc + " large jump in sequence numbers detected (highest received was " + this.highestReceivedSeqNum + ", current is " + seqNum + ", jump of " + RtpUtilsKt.numPacketsTo(this.highestReceivedSeqNum, seqNum) + ") , not requesting retransmissions");
                    }
                    this.highestReceivedSeqNum = seqNum;
                    this.requests.clear();
                    Logger $this$cdebug$iv = this.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        logger = $this$cdebug$iv;
                        boolean bl8 = false;
                        logger.debug(this.ssrc + " large packet gap, resetting and clearing all work");
                    }
                    this.updateWorkDueTime(NO_REQUEST_DUE);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stop() {
            this.running.set(false);
            Map<Integer, PacketRetransmissionRequest> map = this.taskHandleLock;
            synchronized (map) {
                boolean $i$a$-synchronized-RetransmissionRequester$StreamPacketRequester$stop$32 = false;
                ScheduledFuture<?> scheduledFuture = this.currentTaskHandle;
                Boolean $i$a$-synchronized-RetransmissionRequester$StreamPacketRequester$stop$32 = scheduledFuture != null ? Boolean.valueOf(scheduledFuture.cancel(false)) : null;
            }
            map = this.requests;
            synchronized (map) {
                boolean bl = false;
                this.requests.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void updateWorkDueTime(Instant newWorkDueTs) {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.ssrc + " updating next work due time to " + newWorkDueTs);
            }
            Object object = this.taskHandleLock;
            synchronized (object) {
                Object object2;
                Logger logger;
                boolean bl = false;
                if (!this.running.get()) {
                    Logger $this$cdebug$iv2 = this.logger;
                    boolean $i$f$cdebug2 = false;
                    if ($this$cdebug$iv2.isDebugEnabled()) {
                        logger = $this$cdebug$iv2;
                        boolean bl2 = false;
                        logger.debug(this.ssrc + " is stopped, not rescheduling task");
                    }
                }
                if (Intrinsics.areEqual(newWorkDueTs, NO_REQUEST_DUE)) {
                    Logger $this$cdebug$iv3 = this.logger;
                    boolean $i$f$cdebug3 = false;
                    if ($this$cdebug$iv3.isDebugEnabled()) {
                        logger = $this$cdebug$iv3;
                        boolean bl3 = false;
                        logger.debug(this.ssrc + " no more work to do, cancelling job handle");
                    }
                    ScheduledFuture<?> scheduledFuture = this.currentTaskHandle;
                    object2 = scheduledFuture != null ? Boolean.valueOf(scheduledFuture.cancel(false)) : null;
                } else {
                    ScheduledFuture<?> scheduledFuture = this.currentTaskHandle;
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(false);
                    }
                    this.currentTaskHandle = this.scheduler.schedule(this::doWork, Duration.between(this.clock.instant(), newWorkDueTs).toMillis(), TimeUnit.MILLISECONDS);
                    object2 = Unit.INSTANCE;
                }
                Boolean bl4 = object2;
            }
        }

        private final void doWork() {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.ssrc + " doing work at " + this.clock.instant());
            }
            Instant now = this.clock.instant();
            SortedSet<Integer> missingSeqNums = this.getMissingSeqNums();
            if (missingSeqNums.size() >= this.maxMissingSeqNums) {
                this.logger.warn(() -> StreamPacketRequester.doWork$lambda$15(this, missingSeqNums));
            }
            RtcpFbNackPacket nackPacket = new RtcpFbNackPacketBuilder(null, this.ssrc, missingSeqNums, 1, null).build();
            Intrinsics.checkNotNull(now);
            this.notifyNackSent(now, (Collection<Integer>)missingSeqNums);
            this.rtcpSender.invoke(nackPacket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void notifyNackSent(Instant timestamp, Collection<Integer> nackedSeqNums) {
            Map<Integer, PacketRetransmissionRequest> map = this.requests;
            synchronized (map) {
                boolean bl = false;
                Iterable $this$forEach$iv = nackedSeqNums;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Logger logger;
                    boolean $i$f$cdebug;
                    Logger $this$cdebug$iv;
                    int nackedSeqNum = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (this.requests.get(nackedSeqNum) != null) {
                        PacketRetransmissionRequest request;
                        boolean bl3 = false;
                        request.requested(timestamp);
                        if (request.getNumTimesRequested() != 10) continue;
                        $this$cdebug$iv = this.logger;
                        $i$f$cdebug = false;
                        if ($this$cdebug$iv.isDebugEnabled()) {
                            logger = $this$cdebug$iv;
                            boolean bl4 = false;
                            logger.debug(this.ssrc + " generated the last NACK for seq num " + request.getSeqNum() + ", time since the first request = " + Duration.between(request.getFirstRequestTimestamp(), timestamp));
                        }
                        this.requests.remove(nackedSeqNum);
                        continue;
                    }
                    StreamPacketRequester $this$notifyNackSent_u24lambda_u2422_u24lambda_u2420_u24lambda_u2419 = this;
                    boolean bl5 = false;
                    $this$cdebug$iv = $this$notifyNackSent_u24lambda_u2422_u24lambda_u2420_u24lambda_u2419.logger;
                    $i$f$cdebug = false;
                    if (!$this$cdebug$iv.isDebugEnabled()) continue;
                    logger = $this$cdebug$iv;
                    boolean bl6 = false;
                    logger.debug($this$notifyNackSent_u24lambda_u2422_u24lambda_u2420_u24lambda_u2419.ssrc + " packet " + nackedSeqNum + " must have just been received, it was no longer in the requests map");
                }
                Instant nextDueTime = !this.requests.isEmpty() ? timestamp.plus(REQUEST_INTERVAL) : NO_REQUEST_DUE;
                Logger $this$cdebug$iv = this.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv;
                    boolean bl7 = false;
                    logger.debug(this.ssrc + " nack sent at " + timestamp + ", next one will be sent at " + nextDueTime);
                }
                Intrinsics.checkNotNull(nextDueTime);
                this.updateWorkDueTime(nextDueTime);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final SortedSet<Integer> getMissingSeqNums() {
            SortedSet<Integer> sortedSet;
            Map<Integer, PacketRetransmissionRequest> map = this.requests;
            synchronized (map) {
                boolean bl = false;
                sortedSet = CollectionsKt.toSortedSet((Iterable)this.requests.keySet());
            }
            return sortedSet;
        }

        private static final String doWork$lambda$15(StreamPacketRequester this$0, SortedSet $missingSeqNums) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($missingSeqNums, "$missingSeqNums");
            return this$0.ssrc + " sending NACK for " + $missingSeqNums.size() + " missing packets";
        }

        static {
            Instant instant = Instant.MAX;
            Intrinsics.checkNotNullExpressionValue(instant, "MAX");
            NO_REQUEST_DUE = instant;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/rtcp/RetransmissionRequester$StreamPacketRequester$Companion;", "", "<init>", "()V", "NO_REQUEST_DUE", "Ljava/time/Instant;", "getNO_REQUEST_DUE", "()Ljava/time/Instant;", "jitsi-media-transform"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Instant getNO_REQUEST_DUE() {
                return NO_REQUEST_DUE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

