/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.utils.DurationKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\u0004\b \u0010\u001eJ\b\u0010!\u001a\u00020\"H\u0016R$\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011\u00a8\u0006#"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacerConfig;", "", "<init>", "()V", "atTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getAtTime", "()Ljava/time/Instant;", "setAtTime", "(Ljava/time/Instant;)V", "Ljava/time/Instant;", "dataWindow", "Lorg/jitsi/nlj/util/DataSize;", "getDataWindow", "()Lorg/jitsi/nlj/util/DataSize;", "setDataWindow", "(Lorg/jitsi/nlj/util/DataSize;)V", "timeWindow", "Ljava/time/Duration;", "getTimeWindow", "()Ljava/time/Duration;", "setTimeWindow", "(Ljava/time/Duration;)V", "padWindow", "getPadWindow", "setPadWindow", "dataRate", "Lorg/jitsi/nlj/util/Bandwidth;", "dataRate-rlWvAKk", "()J", "padRate", "padRate-rlWvAKk", "toString", "", "jitsi-media-transform"})
public final class PacerConfig {
    private Instant atTime = Instant.MAX;
    @NotNull
    private DataSize dataWindow = DataSize.Companion.getINFINITY();
    @NotNull
    private Duration timeWindow = DurationKt.getMAX_DURATION();
    @NotNull
    private DataSize padWindow = DataSize.Companion.getZERO();

    public final Instant getAtTime() {
        return this.atTime;
    }

    public final void setAtTime(Instant instant) {
        this.atTime = instant;
    }

    @NotNull
    public final DataSize getDataWindow() {
        return this.dataWindow;
    }

    public final void setDataWindow(@NotNull DataSize dataSize) {
        Intrinsics.checkNotNullParameter(dataSize, "<set-?>");
        this.dataWindow = dataSize;
    }

    @NotNull
    public final Duration getTimeWindow() {
        return this.timeWindow;
    }

    public final void setTimeWindow(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(duration, "<set-?>");
        this.timeWindow = duration;
    }

    @NotNull
    public final DataSize getPadWindow() {
        return this.padWindow;
    }

    public final void setPadWindow(@NotNull DataSize dataSize) {
        Intrinsics.checkNotNullParameter(dataSize, "<set-?>");
        this.padWindow = dataSize;
    }

    public final long dataRate-rlWvAKk() {
        return BandwidthKt.per(this.dataWindow, this.timeWindow);
    }

    public final long padRate-rlWvAKk() {
        return BandwidthKt.per(this.padWindow, this.timeWindow);
    }

    @NotNull
    public String toString() {
        return "Data rate " + Bandwidth.toString-impl(this.dataRate-rlWvAKk()) + " (" + this.dataWindow + " per " + this.timeWindow + "), pad rate " + Bandwidth.toString-impl(this.padRate-rlWvAKk()) + " (" + this.padWindow + " per " + this.timeWindow + ")";
    }
}

