/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.export;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.OpusPayloadType;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.PotentialPacketHandler;
import org.jitsi.videobridge.colibri2.FeatureNotImplementedException;
import org.jitsi.videobridge.export.Exporter;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.xmpp.extensions.colibri2.Connect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\b\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001b\u001a\u00020\u0012J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jitsi/videobridge/export/ExporterWrapper;", "Lorg/jitsi/videobridge/PotentialPacketHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;)V", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "started", "", "getStarted", "()Z", "setStarted", "(Z)V", "exporter", "Lorg/jitsi/videobridge/export/Exporter;", "setConnects", "", "connects", "", "Lorg/jitsi/xmpp/extensions/colibri2/Connect;", "isConnected", "wants", "packet", "Lorg/jitsi/nlj/PacketInfo;", "send", "stop", "start", "connect", "jitsi-videobridge"})
public final class ExporterWrapper
implements PotentialPacketHandler {
    @NotNull
    private final Logger logger;
    private boolean started;
    @Nullable
    private Exporter exporter;

    public ExporterWrapper(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final boolean getStarted() {
        return this.started;
    }

    public final void setStarted(boolean bl) {
        this.started = bl;
    }

    public final void setConnects(@NotNull List<Connect> connects) {
        Intrinsics.checkNotNullParameter(connects, "connects");
        if (this.started && !((Collection)connects).isEmpty()) {
            throw new FeatureNotImplementedException("Changing connects once enabled.");
        }
        if (connects.isEmpty()) {
            this.stop();
        } else {
            if (connects.size() > 1) {
                throw new FeatureNotImplementedException("Multiple connects");
            }
            if (connects.get(0).getVideo()) {
                throw new FeatureNotImplementedException("Video");
            }
            this.start(connects.get(0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isConnected() {
        if (!this.started) return false;
        Exporter exporter = this.exporter;
        if (exporter == null) return false;
        if (!exporter.isConnected()) return false;
        return true;
    }

    @Override
    public boolean wants(@NotNull PacketInfo packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (!this.isConnected() || !(packet.getPacket() instanceof AudioRtpPacket)) {
            return false;
        }
        if (!(packet.getPayloadType() instanceof OpusPayloadType)) {
            this.logger.warn("Ignore audio with unsupported payload type: " + packet.getPayloadType());
            return false;
        }
        return true;
    }

    @Override
    public void send(@NotNull PacketInfo packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Exporter exporter = this.exporter;
        if (exporter != null) {
            exporter.send(packet);
        } else {
            ExporterWrapper $this$send_u24lambda_u240 = this;
            boolean bl = false;
            ByteBufferPool.returnBuffer(packet.getPacket().buffer);
        }
    }

    public final void stop() {
        if (this.started) {
            this.logger.info("Stopping.");
        }
        this.started = false;
        Exporter exporter = this.exporter;
        if (exporter != null) {
            exporter.stop();
        }
        this.exporter = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull Connect connect) {
        void $this$start_u24lambda_u241;
        Exporter exporter;
        Intrinsics.checkNotNullParameter(connect, "connect");
        if (connect.getVideo()) {
            throw new FeatureNotImplementedException("Video");
        }
        if (connect.getProtocol() != Connect.Protocols.MEDIAJSON) {
            throw new FeatureNotImplementedException("Protocol " + connect.getProtocol());
        }
        this.logger.info("Starting with url=" + connect.getUrl());
        if (this.exporter != null) {
            this.logger.warn("Exporter already exists, stopping previous one.");
            this.stop();
        }
        Exporter exporter2 = exporter = new Exporter(connect.getUrl(), this.logger);
        ExporterWrapper exporterWrapper = this;
        boolean bl = false;
        $this$start_u24lambda_u241.start();
        exporterWrapper.exporter = exporter;
        this.started = true;
    }
}

