require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_ARM32_VMPARAM_H_)) {
    eval 'sub _ARM_ARM32_VMPARAM_H_ () {1;}' unless defined(&_ARM_ARM32_VMPARAM_H_);
    require 'sys/cdefs.ph';
    require 'arm/cpuconf.ph';
    require 'arm/arm32/param.ph';
    eval 'sub __USE_TOPDOWN_VM () {1;}' unless defined(&__USE_TOPDOWN_VM);
    eval 'sub USRSTACK () { &VM_MAXUSER_ADDRESS;}' unless defined(&USRSTACK);
    unless(defined(&_ARM_ARCH_5)) {
	eval 'sub PAGER_MAP_DEFAULT_SIZE () {(4* 1024* 1024);}' unless defined(&PAGER_MAP_DEFAULT_SIZE);
    }
    eval 'sub MAXTSIZ () {(128*1024*1024);}' unless defined(&MAXTSIZ);
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(384*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(1856*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(4*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(64*1024*1024);}' unless defined(&MAXSSIZ);
    }
    eval 'sub PAGE_SHIFT () { &PGSHIFT;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)  &PAGE_SIZE);}' unless defined(&VM_MIN_ADDRESS);
    if(defined(&ARM_MMU_EXTENDED)) {
	eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t) 0x80000000 -  &PAGE_SIZE);}' unless defined(&VM_MAXUSER_ADDRESS);
    } else {
	eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)  &KERNEL_BASE -  &PAGE_SIZE);}' unless defined(&VM_MAXUSER_ADDRESS);
    }
    eval 'sub VM_MAX_ADDRESS () { &VM_MAXUSER_ADDRESS;}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)  &KERNEL_BASE);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t) -( &PAGE_SIZE+1));}' unless defined(&VM_MAX_KERNEL_ADDRESS);
}
1;
