/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseInfo;

public class UnknownDatabaseInfoHelper {
    static UnknownDatabaseInfo obtainDatabaseInfo(JdbcIntermediateFacade facade) {
        JdbcIntermediateSession session = facade.openSession();
        try {
            Connection connection = session.getConnection();
            try {
                UnknownDatabaseInfo unknownDatabaseInfo = UnknownDatabaseInfoHelper.obtainDatabaseInfo(connection);
                return unknownDatabaseInfo;
            }
            catch (SQLException e) {
                throw session.recognizeException(e);
            }
        }
        finally {
            session.close();
        }
    }

    static UnknownDatabaseInfo obtainDatabaseInfo(Connection connection) throws SQLException {
        DatabaseMetaData md = connection.getMetaData();
        String databaseProductName = md.getDatabaseProductName();
        return databaseProductName != null ? UnknownDatabaseInfoHelper.obtainDatabaseInfo(databaseProductName) : UnknownDatabaseInfoHelper.makeDefaultUnknownInfo();
    }

    private static UnknownDatabaseInfo obtainDatabaseInfo(@NotNull String rdbmsName) {
        UnknownDatabaseInfo info = new UnknownDatabaseInfo();
        info.isOracle = rdbmsName.startsWith("Oracle");
        info.isDB2 = rdbmsName.startsWith("DB2");
        info.isHsql = rdbmsName.startsWith("HSQL");
        info.isDerby = rdbmsName.contains("Derby");
        info.fromSingleRowTable = info.isOracle ? " from dual" : (info.isDB2 || info.isDerby ? " from sysibm.sysdummy1" : (info.isHsql ? " from information_schema.schemata limit 1" : ""));
        return info;
    }

    private static UnknownDatabaseInfo makeDefaultUnknownInfo() {
        return new UnknownDatabaseInfo();
    }
}

