/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkdownHeaderAction
extends AnAction
implements DumbAware {
    @NotNull
    protected abstract Function<Integer, Integer> getLevelFunction();

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkdownHeaderAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Editor editor = MarkdownActionUtil.findMarkdownTextEditor(e);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || psiFile == null || !psiFile.isValid()) {
            return;
        }
        for (Caret caret : ContainerUtil.reverse((List)editor.getCaretModel().getAllCarets())) {
            if (MarkdownHeaderAction.findParent(psiFile, caret) == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkdownHeaderAction.$$$reportNull$$$0(1);
        }
        Editor editor = MarkdownActionUtil.findMarkdownTextEditor(e);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || psiFile == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)psiFile.getProject(), () -> {
            if (!psiFile.isValid()) {
                return;
            }
            for (Caret caret : ContainerUtil.reverse((List)editor.getCaretModel().getAllCarets())) {
                PsiElement parent = (PsiElement)ObjectUtils.assertNotNull((Object)MarkdownHeaderAction.findParent(psiFile, caret));
                MarkdownHeaderImpl header = (MarkdownHeaderImpl)PsiTreeUtil.getParentOfType((PsiElement)parent, MarkdownHeaderImpl.class, (boolean)false);
                if (header != null && header.isValid()) {
                    header.replace((PsiElement)this.createNewLevelHeader(header));
                    continue;
                }
                parent.replace((PsiElement)this.createHeaderForText(parent));
            }
        });
    }

    @Nullable
    private static PsiElement findParent(@NotNull PsiFile psiFile, @NotNull Caret caret) {
        Couple<PsiElement> elements;
        if (psiFile == null) {
            MarkdownHeaderAction.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            MarkdownHeaderAction.$$$reportNull$$$0(3);
        }
        if ((elements = MarkdownActionUtil.getElementsUnderCaretOrSelection(psiFile, caret)) == null) {
            return null;
        }
        PsiElement first = (PsiElement)elements.getFirst();
        PsiElement second = (PsiElement)elements.getSecond();
        if (PsiUtilCore.getElementType((PsiElement)first) == MarkdownTokenTypes.EOL) {
            first = PsiTreeUtil.nextVisibleLeaf((PsiElement)first);
        }
        if (PsiUtilCore.getElementType((PsiElement)second) == MarkdownTokenTypes.EOL) {
            second = PsiTreeUtil.prevVisibleLeaf((PsiElement)second);
        }
        if (first == null || second == null || first.getTextOffset() > second.getTextOffset()) {
            return null;
        }
        PsiElement parent = MarkdownActionUtil.getCommonParentOfTypes(first, second, TokenSet.orSet((TokenSet[])new TokenSet[]{MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES, MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_PARENTS_TYPES}));
        if (parent == null || PsiUtilCore.getElementType((PsiElement)parent) != MarkdownElementTypes.PARAGRAPH) {
            return parent;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        assert (document != null);
        int startOffset = parent.getTextRange().getStartOffset();
        int endOffset = parent.getTextRange().getEndOffset();
        if (startOffset < 0 || endOffset > document.getTextLength()) {
            return null;
        }
        if (document.getLineNumber(startOffset) == document.getLineNumber(endOffset)) {
            return parent;
        }
        return null;
    }

    @NotNull
    public MarkdownPsiElement createHeaderForText(@NotNull PsiElement textElement) {
        if (textElement == null) {
            MarkdownHeaderAction.$$$reportNull$$$0(4);
        }
        int level = ((Integer)this.getLevelFunction().fun((Object)0) + 7) % 7;
        MarkdownHeaderImpl markdownHeaderImpl = MarkdownPsiElementFactory.createHeader(textElement.getProject(), textElement.getText(), level);
        if (markdownHeaderImpl == null) {
            MarkdownHeaderAction.$$$reportNull$$$0(5);
        }
        return markdownHeaderImpl;
    }

    @NotNull
    public MarkdownPsiElement createNewLevelHeader(@NotNull MarkdownHeaderImpl header) {
        if (header == null) {
            MarkdownHeaderAction.$$$reportNull$$$0(6);
        }
        int level = (Integer)this.getLevelFunction().fun((Object)Objects.requireNonNull(header).getHeaderNumber()) % 7;
        Project project = header.getProject();
        String headerName = Objects.requireNonNull(header.getName());
        MarkdownPsiElement newElement = header.getNode().getElementType() == MarkdownElementTypes.SETEXT_1 && level == 2 ? MarkdownPsiElementFactory.createSetext(project, headerName, "-", header.getLastChild().getTextLength()) : (header.getNode().getElementType() == MarkdownElementTypes.SETEXT_2 && level == 1 ? MarkdownPsiElementFactory.createSetext(project, headerName, "=", header.getLastChild().getTextLength()) : (level == 0 ? MarkdownPsiElementFactory.createTextElement(project, headerName) : MarkdownPsiElementFactory.createHeader(project, headerName, level)));
        MarkdownPsiElement markdownPsiElement = newElement;
        if (markdownPsiElement == null) {
            MarkdownHeaderAction.$$$reportNull$$$0(7);
        }
        return markdownPsiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textElement";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/actions/styling/MarkdownHeaderAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/actions/styling/MarkdownHeaderAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderForText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLevelHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHeaderForText";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewLevelHeader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

