/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexUtil;
import org.jetbrains.plugins.textmate.regex.Searcher;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.exception.JOniException;

public class RegexFacade {
    private static final Regex FAILED_REGEX = new Regex("^$", (Encoding)UTF8Encoding.INSTANCE);
    private static final Logger LOGGER = Logger.getInstance(RegexFacade.class);
    @NotNull
    private byte[] myRegexBytes;
    private Regex myRegex;

    private RegexFacade(@NotNull byte[] regexBytes) {
        if (regexBytes == null) {
            RegexFacade.$$$reportNull$$$0(0);
        }
        this.myRegex = null;
        this.myRegexBytes = regexBytes;
    }

    public MatchData match(String string) {
        return this.match(string, 0);
    }

    public MatchData match(String string, int at) {
        byte[] stringBytes = string.getBytes(CharsetToolkit.UTF8_CHARSET);
        int byteOffset = RegexUtil.byteOffsetByCharOffset(string, at);
        Matcher matcher = this.getRegex().matcher(stringBytes, 0, stringBytes.length);
        int matchIndex = matcher.search(byteOffset, stringBytes.length, 256);
        return matchIndex > -1 ? MatchData.fromRegion(string, matcher.getEagerRegion()) : MatchData.NOT_MATCHED;
    }

    public Searcher searcher(String string) {
        byte[] stringBytes = string.getBytes(CharsetToolkit.UTF8_CHARSET);
        return new Searcher(string, stringBytes, this.getRegex().matcher(stringBytes, 0, stringBytes.length));
    }

    @NotNull
    private Regex getRegex() {
        if (this.myRegex == null) {
            try {
                this.myRegex = new Regex(this.myRegexBytes, 0, this.myRegexBytes.length, 256, (Encoding)UTF8Encoding.INSTANCE);
            }
            catch (JOniException e) {
                LOGGER.info("Failed to parse textmate regex", (Throwable)e);
                this.myRegex = FAILED_REGEX;
            }
            this.myRegexBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        Regex regex = this.myRegex;
        if (regex == null) {
            RegexFacade.$$$reportNull$$$0(1);
        }
        return regex;
    }

    @NotNull
    public static RegexFacade regex(@NotNull String regexString) {
        if (regexString == null) {
            RegexFacade.$$$reportNull$$$0(2);
        }
        RegexFacade regexFacade = new RegexFacade(regexString.getBytes(CharsetToolkit.UTF8_CHARSET));
        if (regexFacade == null) {
            RegexFacade.$$$reportNull$$$0(3);
        }
        return regexFacade;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexBytes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/regex/RegexFacade";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/regex/RegexFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "regex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "regex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

