/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.google.common.base.Preconditions;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;

public class RegexUtil {
    private RegexUtil() {
    }

    public static int charOffsetByByteOffset(byte[] stringBytes, int byteOffset) {
        if (byteOffset <= 0) {
            return 0;
        }
        Preconditions.checkPositionIndex((int)byteOffset, (int)stringBytes.length);
        try {
            return CharsetToolkit.UTF8_CHARSET.newDecoder().decode(ByteBuffer.wrap(stringBytes, 0, byteOffset)).length();
        }
        catch (CharacterCodingException e) {
            return byteOffset;
        }
    }

    public static int byteOffsetByCharOffset(String string, int charOffset) {
        if (charOffset <= 0) {
            return 0;
        }
        Preconditions.checkPositionIndex((int)charOffset, (int)string.length());
        CharsetEncoder encoder = CharsetToolkit.UTF8_CHARSET.newEncoder();
        ByteBuffer out = ByteBuffer.allocate(charOffset * (int)encoder.maxBytesPerChar());
        encoder.encode(CharBuffer.wrap(string.toCharArray(), 0, charOffset), out, true);
        return out.position();
    }
}

