/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import com.intellij.util.Processor;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jetbrains.annotations.NotNull;

public class RandomRawReader<T>
implements Closeable {
    @NotNull
    private final RawSerializer<? extends T> mySerializer;
    private final RandomAccessFile myRandomAccessFile;

    public RandomRawReader(@NotNull File file, @NotNull RawSerializer<? extends T> serializer) throws FileNotFoundException {
        if (file == null) {
            RandomRawReader.$$$reportNull$$$0(0);
        }
        if (serializer == null) {
            RandomRawReader.$$$reportNull$$$0(1);
        }
        this.mySerializer = serializer;
        this.myRandomAccessFile = new RandomAccessFile(file, "r");
    }

    public T read(long index) throws IOException {
        this.myRandomAccessFile.seek(index * this.mySerializer.getRecordSize());
        byte[] bytes = new byte[(int)this.mySerializer.getRecordSize()];
        this.myRandomAccessFile.read(bytes);
        return this.mySerializer.read(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public void read(long index, int cnt, Processor<T> processor) throws IOException {
        this.myRandomAccessFile.seek(index * this.mySerializer.getRecordSize());
        byte[] bytes = new byte[(int)this.mySerializer.getRecordSize() * cnt];
        this.myRandomAccessFile.read(bytes);
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
        for (int i = 0; i < cnt && processor.process(this.mySerializer.read(stream)); ++i) {
        }
    }

    public T readRandomLen(long offset, int size) throws IOException {
        this.myRandomAccessFile.seek(offset);
        byte[] bytes = new byte[size];
        this.myRandomAccessFile.read(bytes);
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
        return this.mySerializer.read(stream);
    }

    @Override
    public void close() throws IOException {
        this.myRandomAccessFile.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serializer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/io/RandomRawReader";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

