/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.impl;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.util.List;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.intellij.plugins.xsltDebugger.VMPausedException;
import org.intellij.plugins.xsltDebugger.XsltBreakpointType;
import org.intellij.plugins.xsltDebugger.XsltDebuggerSession;
import org.intellij.plugins.xsltDebugger.impl.XsltBreakpointHandler;
import org.intellij.plugins.xsltDebugger.impl.XsltDebuggerEditorsProvider;
import org.intellij.plugins.xsltDebugger.impl.XsltExecutionStack;
import org.intellij.plugins.xsltDebugger.rt.engine.Breakpoint;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManagerImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltDebugProcess
extends XDebugProcess
implements Disposable {
    private static final Key<XsltDebugProcess> KEY = Key.create((String)"PROCESS");
    private final XsltDebuggerEditorsProvider myEditorsProvider;
    private final ProcessHandler myProcessHandler;
    private final ExecutionConsole myExecutionConsole;
    private BreakpointManager myBreakpointManager = new BreakpointManagerImpl();
    private final XBreakpointHandler<?>[] myXBreakpointHandlers = new XBreakpointHandler[]{new XsltBreakpointHandler(this, XsltBreakpointType.class)};
    private XsltDebuggerSession myDebuggerSession;

    public XsltDebugProcess(XDebugSession session, ExecutionResult executionResult, XsltChecker.LanguageLevel data) {
        super(session);
        this.myProcessHandler = executionResult.getProcessHandler();
        this.myProcessHandler.putUserData(KEY, (Object)this);
        this.myExecutionConsole = executionResult.getExecutionConsole();
        this.myEditorsProvider = new XsltDebuggerEditorsProvider(data);
        Disposer.register((Disposable)this.myExecutionConsole, (Disposable)this);
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myXBreakpointHandlers == null) {
            XsltDebugProcess.$$$reportNull$$$0(0);
        }
        return this.myXBreakpointHandlers;
    }

    public BreakpointManager getBreakpointManager() {
        return this.myBreakpointManager;
    }

    public void init(Debugger client) {
        this.myDebuggerSession = XsltDebuggerSession.getInstance(this.myProcessHandler);
        this.myDebuggerSession.addListener(new XsltDebuggerSession.Listener(){

            @Override
            public void debuggerSuspended() {
                Debugger c = XsltDebugProcess.this.myDebuggerSession.getClient();
                XsltDebugProcess.this.getSession().positionReached((XSuspendContext)new MySuspendContext(XsltDebugProcess.this.myDebuggerSession, c.getCurrentFrame(), c.getSourceFrame()));
            }

            @Override
            public void debuggerResumed() {
            }

            @Override
            public void debuggerStopped() {
                XsltDebugProcess.this.myBreakpointManager = (BreakpointManager)new BreakpointManagerImpl();
            }
        });
        BreakpointManager mgr = client.getBreakpointManager();
        if (this.myBreakpointManager != mgr) {
            List breakpoints = this.myBreakpointManager.getBreakpoints();
            for (Breakpoint breakpoint : breakpoints) {
                Breakpoint bp = mgr.setBreakpoint(breakpoint.getUri(), breakpoint.getLine());
                bp.setEnabled(breakpoint.isEnabled());
                bp.setLogMessage(breakpoint.getLogMessage());
                bp.setTraceMessage(breakpoint.getTraceMessage());
                bp.setCondition(breakpoint.getCondition());
                bp.setSuspend(breakpoint.isSuspend());
            }
            this.myBreakpointManager = mgr;
        }
    }

    @Nullable
    public static XsltDebugProcess getInstance(ProcessHandler handler) {
        return (XsltDebugProcess)((Object)handler.getUserData(KEY));
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.myExecutionConsole;
        if (executionConsole == null) {
            XsltDebugProcess.$$$reportNull$$$0(1);
        }
        return executionConsole;
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        XsltDebuggerEditorsProvider xsltDebuggerEditorsProvider = this.myEditorsProvider;
        if (xsltDebuggerEditorsProvider == null) {
            XsltDebugProcess.$$$reportNull$$$0(2);
        }
        return xsltDebuggerEditorsProvider;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.myDebuggerSession.stepOver();
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.myDebuggerSession.stepInto();
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.myDebuggerSession.stepOver();
    }

    public void stop() {
        if (this.myDebuggerSession != null) {
            this.myDebuggerSession.stop();
        }
    }

    public boolean checkCanPerformCommands() {
        if (this.myDebuggerSession == null) {
            return super.checkCanPerformCommands();
        }
        try {
            return this.myDebuggerSession.getClient().ping();
        }
        catch (VMPausedException e) {
            this.getSession().reportMessage("Target VM is not responding", MessageType.WARNING);
            return false;
        }
    }

    public void resume(@Nullable XSuspendContext context) {
        this.myDebuggerSession.resume();
    }

    public void dispose() {
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            XsltDebugProcess.$$$reportNull$$$0(3);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getSession().getProject()).findFile(position.getFile());
        assert (psiFile != null);
        if (this.myDebuggerSession.canRunTo(position)) {
            this.myDebuggerSession.runTo(psiFile, position);
        } else {
            StatusBar.Info.set((String)("Not a valid position in file '" + psiFile.getName() + "'"), (Project)psiFile.getProject());
            Debugger c = this.myDebuggerSession.getClient();
            this.getSession().positionReached((XSuspendContext)new MySuspendContext(this.myDebuggerSession, c.getCurrentFrame(), c.getSourceFrame()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/xsltDebugger/impl/XsltDebugProcess";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/xsltDebugger/impl/XsltDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySuspendContext
    extends XSuspendContext {
        private final XsltDebuggerSession myDebuggerSession;
        private final Debugger.StyleFrame myStyleFrame;
        private final Debugger.SourceFrame mySourceFrame;

        MySuspendContext(XsltDebuggerSession debuggerSession, Debugger.StyleFrame styleFrame, Debugger.SourceFrame sourceFrame) {
            this.myDebuggerSession = debuggerSession;
            this.myStyleFrame = styleFrame;
            this.mySourceFrame = sourceFrame;
        }

        public XExecutionStack getActiveExecutionStack() {
            return new XsltExecutionStack("XSLT Frames", (Debugger.Frame)this.myStyleFrame, this.myDebuggerSession);
        }

        public XExecutionStack getSourceStack() {
            return new XsltExecutionStack("Source Frames", (Debugger.Frame)this.mySourceFrame, this.myDebuggerSession);
        }

        @NotNull
        public XExecutionStack[] getExecutionStacks() {
            XExecutionStack[] xExecutionStackArray = new XExecutionStack[]{this.getActiveExecutionStack(), this.getSourceStack()};
            if (xExecutionStackArray == null) {
                MySuspendContext.$$$reportNull$$$0(0);
            }
            return xExecutionStackArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/impl/XsltDebugProcess$MySuspendContext", "getExecutionStacks"));
        }
    }
}

