/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JavaScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6QualifiedItemProcessor<T extends ResultSink>
extends JavaScriptQualifiedItemProcessor<T> {
    public ES6QualifiedItemProcessor(T sink, PsiElement place) {
        super(sink, place);
    }

    @Override
    protected void processImpl(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (type == null) {
            ES6QualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            ES6QualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        if (!this.processES6Class(type, source)) {
            return;
        }
        if (!this.processJsDocForTypeScriptElements(type, evaluateContext, source)) {
            return;
        }
        super.processImpl(type, evaluateContext, source);
    }

    public boolean processES6Class(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            ES6QualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        if (source instanceof ES6Class && type instanceof JSNamedType) {
            boolean isStatic = ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC;
            AccessibilityProcessingHandler.processWithStatic(this, isStatic, (Producer<Boolean>)((Producer)() -> {
                boolean b = source.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), source, this.place);
                if (!b) {
                    this.forceResolvedState();
                }
                return b;
            }));
            return false;
        }
        return true;
    }

    private boolean processJsDocForTypeScriptElements(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, @Nullable PsiElement source) {
        if (type == null) {
            ES6QualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        if (evaluateContext == null) {
            ES6QualifiedItemProcessor.$$$reportNull$$$0(4);
        }
        if (this.isTypeScriptLikeType(type) || !(type instanceof JSResolvableType)) {
            return true;
        }
        PsiElement element = type.getSource().getSourceElement();
        if (!(element instanceof JSDocComment)) {
            return true;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        Collection<? extends PsiElement> elements = info.getDeclarations();
        List newElements = ContainerUtil.filter(elements, el -> DialectDetector.isTypeScript(el) && ES6PsiUtil.findExternalModule(el) != null);
        if (!newElements.isEmpty()) {
            this.myTypeScriptResolveProcessor.processElementsForType(evaluateContext, source, type, elements);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6QualifiedItemProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processES6Class";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processJsDocForTypeScriptElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

