/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigLangSubstitutor;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class EslintUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.eslint.EslintUtil");
    public static final String DEFAULT_IGNORE_FILENAME = ".eslintignore";
    public static final String CONFIG_SECTION_NAME = "eslintConfig";
    public static final String PACKAGE_NAME = "eslint";
    public static final String DEFAULT_CONFIG_PREFIX = ".eslintrc";
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".js", ".yaml", ".yml", ".json"};
    private static final String[] CONFIG_FILENAMES = new String[CONFIG_EXTENSIONS.length];
    private static final String[] CONFIG_FILENAMES_WITH_PACKAGE_JSON = new String[CONFIG_EXTENSIONS.length + 1];
    private static final String PLUGINS = "plugins";
    private static final String EXTENDS = "extends";
    private static final String PARSER = "parser";

    private EslintUtil() {
    }

    public static boolean isEslintConfigFile(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            EslintUtil.$$$reportNull$$$0(0);
        }
        if ((file2 = element.getContainingFile()) != null) {
            file2 = file2.getOriginalFile();
        }
        return file2 != null && EslintUtil.isEslintConfigFile(file2);
    }

    public static boolean isEslintConfigFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            EslintUtil.$$$reportNull$$$0(1);
        }
        return EslintUtil.isEslintConfigFile(file2.getViewProvider().getVirtualFile());
    }

    public static boolean isEslintConfigFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EslintUtil.$$$reportNull$$$0(2);
        }
        if (!file2.isValid() || file2.isDirectory()) {
            return false;
        }
        CharSequence name = file2.getNameSequence();
        if (StringUtil.startsWith((CharSequence)name, (CharSequence)DEFAULT_CONFIG_PREFIX)) {
            for (String ext : CONFIG_EXTENSIONS) {
                if (name.length() != DEFAULT_CONFIG_PREFIX.length() + ext.length() || !StringUtil.endsWith((CharSequence)name, (CharSequence)ext)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsWithPackageJsonUpFileSystem(@NotNull VirtualFile fileToLint) {
        if (fileToLint == null) {
            EslintUtil.$$$reportNull$$$0(3);
        }
        List configs = ContainerUtil.newSmartList();
        for (VirtualFile dir = fileToLint.getParent(); dir != null; dir = dir.getParent()) {
            EslintUtil.addAllConfigsWithPackageJsonFromDir(dir, configs);
        }
        List list = configs;
        if (list == null) {
            EslintUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static void addAllConfigsWithPackageJsonFromDir(@NotNull VirtualFile dir, @NotNull List<VirtualFile> configs) {
        if (dir == null) {
            EslintUtil.$$$reportNull$$$0(5);
        }
        if (configs == null) {
            EslintUtil.$$$reportNull$$$0(6);
        }
        for (String name : CONFIG_FILENAMES_WITH_PACKAGE_JSON) {
            VirtualFile file2 = dir.findChild(name);
            if (file2 == null || !file2.isValid() || file2.isDirectory()) continue;
            configs.add(file2);
        }
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsInScope(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(7);
        }
        List<VirtualFile> list = JSLinterConfigFileUtil.findAllConfigs(project, CONFIG_FILENAMES);
        if (list == null) {
            EslintUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static boolean hasConfigFiles(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(9);
        }
        return JSLinterConfigFileUtil.hasConfigFiles(project, CONFIG_FILENAMES);
    }

    public static boolean lintThisFileType(@NotNull Project project, @NotNull PsiFile file2, @NotNull List<VirtualFile> configs, @NotNull EslintState state) {
        String additionalExtensions;
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            EslintUtil.$$$reportNull$$$0(11);
        }
        if (configs == null) {
            EslintUtil.$$$reportNull$$$0(12);
        }
        if (state == null) {
            EslintUtil.$$$reportNull$$$0(13);
        }
        if (file2 instanceof JSFile && DialectDetector.isJavaScript((PsiElement)file2)) {
            return true;
        }
        try {
            additionalExtensions = Registry.stringValue((String)"eslint.additional.file.extensions");
        }
        catch (MissingResourceException e) {
            additionalExtensions = null;
        }
        if (!StringUtil.isEmpty((String)additionalExtensions)) {
            VirtualFile virtualFile = file2.getVirtualFile();
            String fileExtension = virtualFile != null ? virtualFile.getExtension() : null;
            for (String extension : additionalExtensions.split(",")) {
                extension = StringUtil.trim((String)(StringUtil.startsWithChar((CharSequence)extension, (char)'.') ? extension.substring(1) : extension));
                if (!StringUtil.equalsIgnoreCase((CharSequence)extension, (CharSequence)fileExtension)) continue;
                return true;
            }
        }
        if (JSLinterUtil.isPureHtmlFile(file2)) {
            return EslintUtil.processConfigs(state, project, configs, (PairProcessor<PsiFile, EslintConfigData>)((PairProcessor)(__, configData) -> configData.hasPlugin("html")));
        }
        if (JSLinterUtil.isVueFile(file2)) {
            List pluginNpmNames = ContainerUtil.list((Object[])new String[]{EslintUtil.toPluginPackageName("html"), EslintUtil.toPluginPackageName("vue")});
            return EslintUtil.processConfigs(state, project, configs, (PairProcessor<PsiFile, EslintConfigData>)((PairProcessor)(configPsi, configData) -> configData.hasPlugin("html") || configData.hasPlugin("vue") || ContainerUtil.or(configData.getExtends(), s -> StringUtil.startsWith((CharSequence)s, (CharSequence)"plugin:vue")) || StringUtil.equals((CharSequence)configData.getParser(), (CharSequence)"vue-eslint-parser") || configPsi != null && NodePackageUtil.hasAnyOfPluginsInstalled(configPsi, pluginNpmNames)));
        }
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file2.getFileType())) {
            return EslintUtil.processConfigs(state, project, configs, (PairProcessor<PsiFile, EslintConfigData>)((PairProcessor)(__, configData) -> configData.hasPlugin("typescript") || StringUtil.equals((CharSequence)configData.getParser(), (CharSequence)"babel-eslint") || StringUtil.equals((CharSequence)configData.getParser(), (CharSequence)"typescript-eslint-parser")));
        }
        return false;
    }

    @NotNull
    private static String toPluginPackageName(String n) {
        String string = "eslint-plugin-" + n;
        if (string == null) {
            EslintUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static boolean processConfigs(@NotNull EslintState state, @NotNull Project project, @NotNull List<VirtualFile> configs, @NotNull PairProcessor<PsiFile, EslintConfigData> processor) {
        EslintConfigData fromCommandLine;
        if (state == null) {
            EslintUtil.$$$reportNull$$$0(15);
        }
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(16);
        }
        if (configs == null) {
            EslintUtil.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            EslintUtil.$$$reportNull$$$0(18);
        }
        if ((fromCommandLine = state.getParsedCommandLineOptions()) != null) {
            return processor.process(null, (Object)fromCommandLine);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return ContainerUtil.or(configs, configFile -> {
            if (processor == null) {
                EslintUtil.$$$reportNull$$$0(35);
            }
            return (Boolean)ReadAction.compute(() -> {
                PsiFile configPsiFile;
                EslintConfigData configData;
                if (processor == null) {
                    EslintUtil.$$$reportNull$$$0(36);
                }
                EslintConfigData eslintConfigData = configData = (configPsiFile = psiManager.findFile(configFile)) != null ? (EslintConfigData)AstLoadingFilter.forceAllowTreeLoading((PsiFile)configPsiFile, () -> EslintUtil.parseConfigFile(configPsiFile)) : null;
                if (configData == null) {
                    return false;
                }
                return processor.process((Object)configPsiFile, (Object)configData);
            });
        });
    }

    @Nullable
    public static EslintConfigData parseCommandLineOptions(@Nullable String options) {
        if (StringUtil.isEmptyOrSpaces((String)options)) {
            return null;
        }
        String parser = null;
        ArrayList<String> plugins = new ArrayList<String>();
        List words = ParametersListUtil.parse((String)options, (boolean)false, (boolean)true);
        for (int i = 0; i < words.size() - 1; ++i) {
            String word = (String)words.get(i);
            if (StringUtil.equals((CharSequence)"--plugin", (CharSequence)word)) {
                plugins.addAll(Arrays.asList(((String)words.get(i + 1)).split(",")));
            }
            if (!StringUtil.equals((CharSequence)"--parser", (CharSequence)word)) continue;
            parser = (String)words.get(i + 1);
        }
        return new EslintConfigData(plugins, ContainerUtil.emptyList(), parser);
    }

    @Nullable
    public static EslintConfigData parseConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(19);
        }
        CachedValueProvider provider2 = () -> {
            VirtualFile virtualFile;
            if (configFile == null) {
                EslintUtil.$$$reportNull$$$0(34);
            }
            if ((virtualFile = configFile.getViewProvider().getVirtualFile()).getLength() >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                return null;
            }
            EslintConfigData configData = EslintUtil.parseInternal(configFile, configFile.getLanguage());
            return CachedValueProvider.Result.create((Object)configData, (Object[])new Object[]{configFile});
        };
        return (EslintConfigData)CachedValuesManager.getCachedValue((PsiElement)configFile, (CachedValueProvider)provider2);
    }

    @Nullable
    private static EslintConfigData parseInternal(@NotNull PsiFile configFile, @NotNull Language language) {
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(20);
        }
        if (language == null) {
            EslintUtil.$$$reportNull$$$0(21);
        }
        if (JSLinterConfigLangSubstitutor.YamlLanguageHolder.INSTANCE.equals(language)) {
            return EslintUtil.parseYamlConfig(configFile);
        }
        if (configFile instanceof JsonFile) {
            return EslintUtil.parseJsonConfig(configFile);
        }
        if (configFile instanceof JSFile) {
            return EslintUtil.parseJavaScriptConfig(configFile);
        }
        return null;
    }

    @Nullable
    private static EslintConfigData parseYamlConfig(@NotNull PsiFile configFile) {
        Map map;
        String content;
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(22);
        }
        if ((content = EslintUtil.loadContentOrNull(configFile.getViewProvider().getVirtualFile())) == null) {
            return null;
        }
        try {
            map = (Map)new Yaml().load(content);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return null;
        }
        if (map == null) {
            return null;
        }
        return new EslintConfigData(EslintUtil.getStringList(map.get(PLUGINS)), EslintUtil.getListOrSingleStringValue(map.get(EXTENDS)), (String)ObjectUtils.tryCast(map.get(PARSER), String.class));
    }

    @Nullable
    private static EslintConfigData parseJsonConfig(@NotNull PsiFile configFile) {
        JsonObject eslintRootObject;
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(23);
        }
        if ((eslintRootObject = EslintUtil.getConfigRootObject(configFile)) == null) {
            return null;
        }
        List plugins = ContainerUtil.notNullize((List)JsonUtil.getChildAsStringList((JsonObject)eslintRootObject, (String)PLUGINS));
        List extendsList = ContainerUtil.notNullize((List)JsonUtil.getChildAsSingleStringOrList((JsonObject)eslintRootObject, (String)EXTENDS));
        JsonStringLiteral parserValue = (JsonStringLiteral)JsonUtil.getPropertyValueOfType((JsonObject)eslintRootObject, (String)PARSER, JsonStringLiteral.class);
        String parserString = parserValue != null ? parserValue.getValue() : null;
        return new EslintConfigData(plugins, extendsList, parserString);
    }

    @Nullable
    public static JsonObject getConfigRootObject(@NotNull PsiFile configFile) {
        JsonFile jsonFile;
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(24);
        }
        if ((jsonFile = (JsonFile)ObjectUtils.tryCast((Object)configFile, JsonFile.class)) == null) {
            return null;
        }
        JsonObject eslintRootObject = (JsonObject)ObjectUtils.tryCast((Object)jsonFile.getTopLevelValue(), JsonObject.class);
        if (eslintRootObject == null) {
            return null;
        }
        if ("package.json".equals(configFile.getName()) && (eslintRootObject = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)eslintRootObject, (String)CONFIG_SECTION_NAME, JsonObject.class)) == null) {
            return null;
        }
        return eslintRootObject;
    }

    @Nullable
    private static EslintConfigData parseJavaScriptConfig(@NotNull PsiFile configFile) {
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(25);
        }
        Collection expressions = PsiTreeUtil.findChildrenOfType((PsiElement)configFile, JSReferenceExpression.class);
        for (JSReferenceExpression expression : expressions) {
            if (!JSSymbolUtil.isAccurateReferenceExpressionName(expression, "module", "exports") && !JSSymbolUtil.isAccurateReferenceExpressionName(expression, "exports") || !(expression.getParent() instanceof JSDefinitionExpression) || !expression.equals(((JSDefinitionExpression)expression.getParent()).getExpression()) || !(((JSDefinitionExpression)expression.getParent()).getInitializer() instanceof JSObjectLiteralExpression)) continue;
            JSObjectLiteralExpression object = (JSObjectLiteralExpression)((JSDefinitionExpression)expression.getParent()).getInitializer();
            assert (object != null);
            JSProperty parserProperty = object.findProperty(PARSER);
            String parserString = parserProperty != null && parserProperty.getValue() instanceof JSLiteralExpression ? ((JSLiteralExpression)parserProperty.getValue()).getStringValue() : null;
            return new EslintConfigData(ContainerUtil.notNullize(EslintUtil.getJSStringArrayOrSimplePropertyValues(object, PLUGINS)), ContainerUtil.notNullize(EslintUtil.getJSStringArrayOrSimplePropertyValues(object, EXTENDS)), parserString);
        }
        return null;
    }

    private static List<String> getJSStringArrayOrSimplePropertyValues(@NotNull JSObjectLiteralExpression object, @NotNull String name) {
        JSProperty property;
        if (object == null) {
            EslintUtil.$$$reportNull$$$0(26);
        }
        if (name == null) {
            EslintUtil.$$$reportNull$$$0(27);
        }
        if ((property = object.findProperty(name)) != null) {
            if (property.getValue() instanceof JSArrayLiteralExpression) {
                JSExpression[] arrayExpressions = ((JSArrayLiteralExpression)property.getValue()).getExpressions();
                return Arrays.stream(arrayExpressions).filter(expr -> expr instanceof JSLiteralExpression && ((JSLiteralExpression)expr).isQuotedLiteral()).map(expr -> StringUtil.unquoteString((String)expr.getText())).collect(Collectors.toList());
            }
            if (property.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)property.getValue()).isQuotedLiteral()) {
                return Collections.singletonList(StringUtil.unquoteString((String)property.getValue().getText()));
            }
        }
        return null;
    }

    @Nullable
    private static String loadContentOrNull(VirtualFile configFile) {
        try {
            return VfsUtilCore.loadText((VirtualFile)configFile);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static List<String> getStringList(@Nullable Object value) {
        List list = value instanceof List ? (List)value : ContainerUtil.emptyList();
        List list2 = ContainerUtil.map((Collection)list, o -> o.toString());
        if (list2 == null) {
            EslintUtil.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @NotNull
    private static List<String> getListOrSingleStringValue(@Nullable Object value) {
        List<String> list = EslintUtil.getStringList(value);
        if (!list.isEmpty()) {
            List<String> list2 = list;
            if (list2 == null) {
                EslintUtil.$$$reportNull$$$0(29);
            }
            return list2;
        }
        String stringValue = value instanceof String ? (String)value : null;
        List list3 = !StringUtil.isEmpty((String)stringValue) ? ContainerUtil.list((Object[])new String[]{stringValue}) : ContainerUtil.emptyList();
        if (list3 == null) {
            EslintUtil.$$$reportNull$$$0(30);
        }
        return list3;
    }

    @Nullable
    public static VirtualFile findDistinctConfigInContentRoots(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(31);
        }
        return JSLinterConfigFileUtil.findDistinctConfigInContentRoots(project, Arrays.asList(CONFIG_FILENAMES_WITH_PACKAGE_JSON), (Condition<? super VirtualFile>)((Condition)file2 -> {
            if (PackageJsonUtil.isPackageJsonFile(file2)) {
                return PackageJsonUtil.getOrCreateData(file2).getTopLevelProperties().contains(CONFIG_SECTION_NAME);
            }
            return true;
        }));
    }

    @Nullable
    public static VirtualFile lookupIgnoreFile(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            EslintUtil.$$$reportNull$$$0(32);
        }
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(33);
        }
        return JSLinterConfigFileUtil.lookupFileByName(virtualFile, new String[]{DEFAULT_IGNORE_FILENAME}, project.getBaseDir());
    }

    static {
        for (int i = 0; i < CONFIG_EXTENSIONS.length; ++i) {
            EslintUtil.CONFIG_FILENAMES[i] = DEFAULT_CONFIG_PREFIX + CONFIG_EXTENSIONS[i];
            EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON[i] = CONFIG_FILENAMES[i];
        }
        EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON[EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON.length - 1] = "package.json";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConfigsWithPackageJsonUpFileSystem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConfigsInScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toPluginPackageName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringList";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getListOrSingleStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEslintConfigFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAllConfigsWithPackageJsonUpFileSystem";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAllConfigsWithPackageJsonFromDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAllConfigsInScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFiles";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lintThisFileType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processConfigs";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseInternal";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseYamlConfig";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseJsonConfig";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getConfigRootObject";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseJavaScriptConfig";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getJSStringArrayOrSimplePropertyValues";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findDistinctConfigInContentRoots";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lookupIgnoreFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseConfigFile$7";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processConfigs$6";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EslintConfigData {
        @NotNull
        private final List<String> myExtends;
        @NotNull
        private final List<String> myPlugins;
        @Nullable
        private final String myParser;

        public EslintConfigData(@NotNull List<String> plugins, @NotNull List<String> extended, @Nullable String parser) {
            if (plugins == null) {
                EslintConfigData.$$$reportNull$$$0(0);
            }
            if (extended == null) {
                EslintConfigData.$$$reportNull$$$0(1);
            }
            this.myExtends = extended;
            this.myPlugins = plugins;
            this.myParser = parser;
        }

        public boolean hasPlugin(@NotNull String name) {
            if (name == null) {
                EslintConfigData.$$$reportNull$$$0(2);
            }
            return this.myPlugins.contains(name) || this.myPlugins.contains(EslintUtil.toPluginPackageName(name));
        }

        @NotNull
        public List<String> getPlugins() {
            List<String> list = this.myPlugins;
            if (list == null) {
                EslintConfigData.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public List<String> getExtends() {
            List<String> list = this.myExtends;
            if (list == null) {
                EslintConfigData.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Nullable
        public String getParser() {
            return this.myParser;
        }

        public String toString() {
            return "EslintConfigData{myExtends=" + StringUtil.join(this.myExtends, (String)",") + ", myPlugins=" + StringUtil.join(this.myPlugins, (String)",") + ", myParser='" + this.myParser + '\'' + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = EslintUtil.PLUGINS;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extended";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintUtil$EslintConfigData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintUtil$EslintConfigData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlugins";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "hasPlugin";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

