/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNodePackageWrapper {
    public static final String BUNDLED = "Bundled";
    @NotNull
    private final NodeJsInterpreterField myInterpreterField;
    @NotNull
    private final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final NodePackageField myField;
    @NotNull
    private final Project myProject;
    @NotNull
    private final NodePackageDescriptor myDescriptor;

    @NotNull
    public static NodePackageDescriptor createDescriptor(@Nullable Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(0);
        }
        String libVersion = TypeScriptLibraryProvider.getVersion(project);
        final NodePackage bundledVersion = TypeScriptNodePackageWrapper.createBundledVersion(project, libVersion);
        TypeScriptCompilerSettings.TypeScriptCompilerVersionType type = settings.getVersionType();
        final NodePackage customPackage = type == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.SERVICE_DIRECTORY ? new NodePackage(TypeScriptNodePackageWrapper.removeExactLibPrefix(settings.getTypeScriptServiceDirectory())) : null;
        NodePackageDescriptor nodePackageDescriptor = new NodePackageDescriptor("typescript"){

            @Override
            @NotNull
            public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList results = ContainerUtil.newArrayList();
                if (customPackage != null) {
                    results.add(customPackage);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    NodeJsInterpreter forSearchingGlobalPackages = !directDependenciesInsideProject ? interpreter : null;
                    results.addAll(super.listAvailable(project, forSearchingGlobalPackages, contextFileOrDirectory, directDependenciesInsideProject));
                }
                results.add(bundledVersion);
                ArrayList arrayList = results;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            @Override
            @NotNull
            public NodePackage createPackage(@NotNull String path) {
                if (path == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (TypeScriptNodePackageWrapper.BUNDLED.equals(path)) {
                    NodePackage nodePackage = bundledVersion;
                    if (nodePackage == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return nodePackage;
                }
                NodePackage nodePackage = super.createPackage(path);
                if (nodePackage == null) {
                    1.$$$reportNull$$$0(4);
                }
                return nodePackage;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listAvailable";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPackage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "listAvailable";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPackage";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (nodePackageDescriptor == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(1);
        }
        return nodePackageDescriptor;
    }

    @NotNull
    public static NodePackage createBundledVersion(Project project, String libVersion) {
        String path = TypeScriptCompilerSettings.getSettings(project).getDefaultTypeScriptServiceDirectory();
        EmbeddedTypeScriptNodePackage embeddedTypeScriptNodePackage = new EmbeddedTypeScriptNodePackage(path, libVersion);
        if (embeddedTypeScriptNodePackage == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(2);
        }
        return embeddedTypeScriptNodePackage;
    }

    @NotNull
    public NodePackageField getField() {
        NodePackageField nodePackageField = this.myField;
        if (nodePackageField == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(3);
        }
        return nodePackageField;
    }

    public TypeScriptNodePackageWrapper(@NotNull Project project, @NotNull NodeJsInterpreterField interpreterField, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(4);
        }
        if (interpreterField == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(6);
        }
        this.myDescriptor = TypeScriptNodePackageWrapper.createDescriptor(project, settings);
        this.myField = new NodePackageField(interpreterField, this.myDescriptor, null);
        this.myProject = project;
        this.myInterpreterField = interpreterField;
        this.mySettings = settings;
    }

    public boolean isModified() {
        return !TypeScriptNodePackageWrapper.getPackageFromSettings(this.myProject, this.myDescriptor, this.mySettings, this.myInterpreterField.getInterpreter()).equals(this.myField.getSelected());
    }

    public void reset() {
        this.myField.setSelected(TypeScriptNodePackageWrapper.getPackageFromSettings(this.myProject, this.myDescriptor, this.mySettings, this.myInterpreterField.getInterpreter()));
    }

    public void apply() throws ConfigurationException {
        NodePackage selected = this.myField.getSelected();
        if (!selected.isValid()) {
            throw new ConfigurationException("Incorrect path to typescript package");
        }
        NodePackage firstPackage = this.getDefaultOrBundledPackage();
        if (selected.equals(firstPackage)) {
            this.mySettings.setVersionType(TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED_OR_DETECTED);
            this.mySettings.setTypeScriptServiceDirectory(null);
        } else if (selected instanceof EmbeddedTypeScriptNodePackage) {
            this.mySettings.setVersionType(TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED);
            this.mySettings.setTypeScriptServiceDirectory(null);
        } else {
            this.mySettings.setVersionType(TypeScriptCompilerSettings.TypeScriptCompilerVersionType.SERVICE_DIRECTORY);
            this.mySettings.setTypeScriptServiceDirectory(selected.getSystemIndependentPath());
        }
    }

    @NotNull
    public NodePackage getDefaultOrBundledPackage() {
        NodePackage nodePackage = this.myDescriptor.findFirstDirectDependencyPackage(this.myProject, this.myInterpreterField.getInterpreter(), null);
        if (nodePackage == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(7);
        }
        return nodePackage;
    }

    @NotNull
    public static NodePackage getPackageFromSettings(@NotNull Project project, @NotNull NodePackageDescriptor descriptor2, @NotNull TypeScriptCompilerSettings settings, @Nullable NodeJsInterpreter interpreter) {
        TypeScriptCompilerSettings.TypeScriptCompilerVersionType type;
        if (project == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(8);
        }
        if (descriptor2 == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(10);
        }
        if ((type = settings.getVersionType()) == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED) {
            NodePackage nodePackage = descriptor2.createPackage(BUNDLED);
            if (nodePackage == null) {
                TypeScriptNodePackageWrapper.$$$reportNull$$$0(11);
            }
            return nodePackage;
        }
        if (type == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.SERVICE_DIRECTORY) {
            NodePackage nodePackage = descriptor2.createPackage(TypeScriptNodePackageWrapper.removeExactLibPrefix(settings.getTypeScriptServiceDirectory()));
            if (nodePackage == null) {
                TypeScriptNodePackageWrapper.$$$reportNull$$$0(12);
            }
            return nodePackage;
        }
        NodePackage nodePackage = descriptor2.findFirstDirectDependencyPackage(project, interpreter, null);
        if (nodePackage == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(13);
        }
        return nodePackage;
    }

    @NotNull
    private static String removeExactLibPrefix(@Nullable String path) {
        if (path == null) {
            if ("" == null) {
                TypeScriptNodePackageWrapper.$$$reportNull$$$0(14);
            }
            return "";
        }
        String fixedPath = StringUtil.trimEnd((String)path, (String)"/");
        String fileName = PathUtil.getFileName((String)fixedPath);
        if ("lib".equals(fileName)) {
            String string = StringUtil.notNullize((String)PathUtil.getParentPath((String)path));
            if (string == null) {
                TypeScriptNodePackageWrapper.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = fixedPath;
        if (string == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createBundledVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOrBundledPackage";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFromSettings";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "removeExactLibPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFromSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EmbeddedTypeScriptNodePackage
    extends NodePackage {
        private final String myVersion;

        EmbeddedTypeScriptNodePackage(@NotNull String libDirectory, @NotNull String libVersion) {
            if (libDirectory == null) {
                EmbeddedTypeScriptNodePackage.$$$reportNull$$$0(0);
            }
            if (libVersion == null) {
                EmbeddedTypeScriptNodePackage.$$$reportNull$$$0(1);
            }
            super(libDirectory);
            this.myVersion = libVersion;
        }

        @Override
        @NotNull
        public String getPresentablePath() {
            if (TypeScriptNodePackageWrapper.BUNDLED == null) {
                EmbeddedTypeScriptNodePackage.$$$reportNull$$$0(2);
            }
            return TypeScriptNodePackageWrapper.BUNDLED;
        }

        @Override
        @Nullable
        public SemVer getVersion() {
            return SemVer.parseFromText((String)this.myVersion);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libVersion";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper$EmbeddedTypeScriptNodePackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper$EmbeddedTypeScriptNodePackage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

