/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.copyright;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import com.maddyhome.idea.copyright.psi.UpdatePsiFileCopyright;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UpdatePhpCopyrightsProvider
extends UpdateCopyrightsProvider {
    public UpdateCopyright createInstance(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options) {
        return new UpdatePhpFileCopyright(project, module, file, options);
    }

    protected static class UpdatePhpFileCopyright
    extends UpdatePsiFileCopyright {
        protected UpdatePhpFileCopyright(Project project, Module module, VirtualFile root, CopyrightProfile options) {
            super(project, module, root, options);
        }

        protected void scanFile() {
            PsiElement first = this.getFirst();
            PsiElement next = this.getNextSibling(first);
            if (first != null && next != null) {
                PsiElement last = next;
                while (next instanceof PsiComment || next instanceof PsiWhiteSpace) {
                    if ((next = this.getNextSibling(next)) == null) continue;
                    last = next;
                }
                List comments = ContainerUtil.newSmartList();
                this.collectComments(first, last, comments);
                if (last instanceof PsiComment) {
                    comments.add((PsiComment)last);
                }
                this.checkComments(last, true, comments);
            }
        }

        protected void addAction(UpdatePsiFileCopyright.CommentAction action) {
            if (action.getType() == 1) {
                int beginIndex = this.getFirst().getTextRange().getEndOffset();
                int endIndex = action.getStart();
                if (endIndex - beginIndex >= 0 && StringUtil.isEmptyOrSpaces((String)this.getFile().getText().substring(beginIndex, endIndex))) {
                    super.addAction(new UpdatePsiFileCopyright.CommentAction(3, beginIndex, endIndex));
                    super.addAction(new UpdatePsiFileCopyright.CommentAction(endIndex, "\n", action.getSuffix()));
                    return;
                }
            }
            super.addAction(action);
        }

        @Nullable
        private PsiElement getFirst() {
            PsiElement first = null;
            PsiElement child = this.getFile().getFirstChild();
            if (child != null) {
                first = child.getFirstChild();
                if (PhpPsiUtil.isOfType(first, PhpTokenTypes.PHP_OPENING_TAG)) {
                    PsiElement next = this.getNextSibling(first);
                    while (!(next == null || next instanceof PsiWhiteSpace && StringUtil.getLineBreakCount((CharSequence)next.getText()) != 0)) {
                        first = next;
                        next = this.getNextSibling(next);
                    }
                    if (next == null) {
                        first = child;
                    }
                } else {
                    first = null;
                }
            }
            return first;
        }

        protected String getCommentText(String prefix, String suffix) {
            String commentText = super.getCommentText(prefix, suffix);
            if (commentText.startsWith(prefix + "/*\n")) {
                commentText = prefix + "/**\n" + commentText.substring(prefix.length() + 3);
            }
            return commentText;
        }

        protected boolean accept() {
            return this.getFile() instanceof PhpFile;
        }
    }
}

