/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.highlighter;

import com.intellij.application.options.colors.highlighting.HighlightsExtractor;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.highlighter.PhpColorPageHighlighter;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpColorsAndFontsPage
implements RainbowColorSettingsPage,
DisplayPrioritySortable {
    private static final String DEMO_TEXT = "<?php\n$heredoc = <<< HEREDOC_ID\nsome $contents\nHEREDOC_ID;\n\nfunction foo() {\n   <bg><var>$a</var></bg> = [0, 1, 2];\n   return SomeClass::$shared;\n}\n\n// Sample comment\n\nuse AnotherClass as SomeAlias;\nclass SomeClass extends One implements Another {\n   private $my;\n   public static $shared;\n   const CONSTANT = 0987654321;\n   /**\n    * Description by <a href=\"mailto:\">user@host.dom</a>" + RainbowHighlighter.generatePaletteExample((String)"\n    * ") + "\n    * @param <bg><docparam>$abc</docparam></bg>\n    * @param <bg><docparam>$def</docparam></bg>\n    * @property $magic\n    * @return SomeType\n    */\n   function doSmth(<bg><param>$abc</param></bg>, <bg><param>$def</param></bg>) {\n      $b = new SomeAlias();\n      foo();\n      <bg><param>$def</param></bg> .=  self::magic;\n      <bg><param>$def</param></bg> .=  self::CONSTANT;\n      <bg><var>$v</var></bg> = Helper::convert(<bg><param>$abc</param></bg> . \"\\n {<bg><param>$def</param></bg>}\" . $<bg><param>$def</param></bg>);\n      <bg><var>$q</var></bg> = new Query( $this->invent(abs(0x80)) );\n      return array(<bg><var>$v</var></bg> => <bg><var>$q</var></bg>->result);\n   }\n}\n\ninterface Another {\n}\n\ninclude (dirname(__FILE__) . \"inc.php\");\n`rm -r`;\n\ngoto Label;\n\nLabel:\n\u2116";
    private static final Map<Integer, IElementType> TYPE_MAP = PhpColorPageHighlighter.buildTypeMap(PhpColorsAndFontsPage.extractHighlights(DEMO_TEXT));
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(PhpBundle.message("color.settings.php.scripting", new Object[0]), PhpHighlightingData.PHP_SCRIPTING), new AttributesDescriptor(PhpBundle.message("color.settings.php.tags", new Object[0]), PhpHighlightingData.PHP_TAG), new AttributesDescriptor(PhpBundle.message("color.settings.keyword", new Object[0]), PhpHighlightingData.KEYWORD), new AttributesDescriptor(PhpBundle.message("color.settings.comment", new Object[0]), PhpHighlightingData.COMMENT), new AttributesDescriptor(PhpBundle.message("color.settings.number", new Object[0]), PhpHighlightingData.NUMBER), new AttributesDescriptor(PhpBundle.message("color.settings.string", new Object[0]), PhpHighlightingData.STRING), new AttributesDescriptor(PhpBundle.message("color.settings.exec_command", new Object[0]), PhpHighlightingData.EXEC_COMMAND), new AttributesDescriptor(PhpBundle.message("color.settings.concatenation", new Object[0]), PhpHighlightingData.PHP_CONCATENATION), new AttributesDescriptor(PhpBundle.message("color.settings.escape_sequence", new Object[0]), PhpHighlightingData.ESCAPE_SEQUENCE), new AttributesDescriptor(PhpBundle.message("color.settings.operation", new Object[0]), PhpHighlightingData.OPERATION_SIGN), new AttributesDescriptor(PhpBundle.message("color.settings.brackets", new Object[0]), PhpHighlightingData.BRACKETS), new AttributesDescriptor(PhpBundle.message("color.settings.braces", new Object[0]), PhpHighlightingData.BRACES), new AttributesDescriptor(PhpBundle.message("color.settings.parentheses", new Object[0]), PhpHighlightingData.PARENTHESES), new AttributesDescriptor(PhpBundle.message("color.settings.predefined.symbols", new Object[0]), PhpHighlightingData.PREDEFINED_SYMBOL), new AttributesDescriptor(PhpBundle.message("color.settings.bad_character", new Object[0]), PhpHighlightingData.BAD_CHARACTER), new AttributesDescriptor(PhpBundle.message("color.settings.comma", new Object[0]), PhpHighlightingData.COMMA), new AttributesDescriptor(PhpBundle.message("color.settings.semicolon", new Object[0]), PhpHighlightingData.SEMICOLON), new AttributesDescriptor(PhpBundle.message("color.settings.heredoc_id", new Object[0]), PhpHighlightingData.HEREDOC_ID), new AttributesDescriptor(PhpBundle.message("color.settings.heredoc_content", new Object[0]), PhpHighlightingData.HEREDOC_CONTENT), new AttributesDescriptor(PhpBundle.message("color.settings.identifier", new Object[0]), PhpHighlightingData.IDENTIFIER), new AttributesDescriptor(PhpBundle.message("color.settings.var", new Object[0]), PhpHighlightingData.VAR), new AttributesDescriptor(PhpBundle.message("color.settings.var_var", new Object[0]), PhpHighlightingData.VAR_VAR), new AttributesDescriptor(PhpBundle.message("color.settings.constant", new Object[0]), PhpHighlightingData.CONSTANT), new AttributesDescriptor(PhpBundle.message("color.settings.function", new Object[0]), PhpHighlightingData.FUNCTION), new AttributesDescriptor(PhpBundle.message("color.settings.parameter", new Object[0]), PhpHighlightingData.PARAMETER), new AttributesDescriptor(PhpBundle.message("color.settings.function.call", new Object[0]), PhpHighlightingData.FUNCTION_CALL), new AttributesDescriptor(PhpBundle.message("color.settings.instance.method", new Object[0]), PhpHighlightingData.INSTANCE_METHOD_CALL), new AttributesDescriptor(PhpBundle.message("color.settings.static.method", new Object[0]), PhpHighlightingData.STATIC_METHOD_CALL), new AttributesDescriptor(PhpBundle.message("color.settings.magic.member", new Object[0]), PhpHighlightingData.MAGIC_MEMBER_ACCESS), new AttributesDescriptor(PhpBundle.message("color.settings.class", new Object[0]), PhpHighlightingData.CLASS), new AttributesDescriptor(PhpBundle.message("color.settings.interface", new Object[0]), PhpHighlightingData.INTERFACE), new AttributesDescriptor(PhpBundle.message("color.settings.instance.field", new Object[0]), PhpHighlightingData.INSTANCE_FIELD), new AttributesDescriptor(PhpBundle.message("color.settings.static.field", new Object[0]), PhpHighlightingData.STATIC_FIELD), new AttributesDescriptor(PhpBundle.message("color.settings.doccomment", new Object[0]), PhpHighlightingData.DOC_COMMENT), new AttributesDescriptor(PhpBundle.message("color.settings.doctag", new Object[0]), PhpHighlightingData.DOC_TAG), new AttributesDescriptor(PhpBundle.message("color.settings.docmarkup", new Object[0]), PhpHighlightingData.DOC_MARKUP), new AttributesDescriptor(PhpBundle.message("color.settings.alias.reference", new Object[0]), PhpHighlightingData.ALIAS_REFERENCE), new AttributesDescriptor(PhpBundle.message("color.settings.goto.label", new Object[0]), PhpHighlightingData.GOTO_LABEL)};

    @NotNull
    private static String extractHighlights(@NotNull String text) {
        if (text == null) {
            PhpColorsAndFontsPage.$$$reportNull$$$0(0);
        }
        String string = new HighlightsExtractor(PhpColorsAndFontsPage.getHighlightingTagToDescriptorMap()).extractHighlights(text, (List)ContainerUtil.newArrayList());
        if (string == null) {
            PhpColorsAndFontsPage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = PhpBundle.message("color.settings.name", new Object[0]);
        if (string == null) {
            PhpColorsAndFontsPage.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return PhpFileType.INSTANCE.getIcon();
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            PhpColorsAndFontsPage.$$$reportNull$$$0(3);
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            PhpColorsAndFontsPage.$$$reportNull$$$0(4);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        PhpColorPageHighlighter phpColorPageHighlighter = new PhpColorPageHighlighter(TYPE_MAP);
        if (phpColorPageHighlighter == null) {
            PhpColorsAndFontsPage.$$$reportNull$$$0(5);
        }
        return phpColorPageHighlighter;
    }

    @NonNls
    @NotNull
    public String getDemoText() {
        String string = DEMO_TEXT;
        if (string == null) {
            PhpColorsAndFontsPage.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return PhpColorsAndFontsPage.getHighlightingTagToDescriptorMap();
    }

    @NotNull
    private static Map<String, TextAttributesKey> getHighlightingTagToDescriptorMap() {
        Map hlm = RainbowHighlighter.createRainbowHLM();
        hlm.put("param", PhpHighlightingData.PARAMETER);
        hlm.put("var", PhpHighlightingData.VAR);
        hlm.put("docparam", PhpHighlightingData.DOC_COMMENT);
        hlm.put("bg", PhpHighlightingData.PHP_SCRIPTING);
        Map map = hlm;
        if (map == null) {
            PhpColorsAndFontsPage.$$$reportNull$$$0(7);
        }
        return map;
    }

    public DisplayPriority getPriority() {
        return PlatformUtils.isPhpStorm() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    public boolean isRainbowType(TextAttributesKey type) {
        return PhpHighlightingData.PARAMETER.equals((Object)type) || PhpHighlightingData.VAR.equals((Object)type) || PhpHighlightingData.DOC_COMMENT.equals((Object)type);
    }

    @Nullable
    public Language getLanguage() {
        return PhpLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/highlighter/PhpColorsAndFontsPage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/highlighter/PhpColorsAndFontsPage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHighlights";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDemoText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingTagToDescriptorMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractHighlights";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

