/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class BasicOperations {
    private BasicOperations() {
    }

    public static Automaton concatenate(Automaton a1, Automaton a2) {
        boolean deterministic;
        if (a1.isSingleton() && a2.isSingleton()) {
            return BasicAutomata.makeString(a1.singleton + a2.singleton);
        }
        if (BasicOperations.isEmpty(a1) || BasicOperations.isEmpty(a2)) {
            return BasicAutomata.makeEmpty();
        }
        boolean bl = deterministic = a1.isSingleton() && a2.isDeterministic();
        if (a1 == a2) {
            a1 = a1.cloneExpanded();
            a2 = a2.cloneExpanded();
        } else {
            a1 = a1.cloneExpandedIfRequired();
            a2 = a2.cloneExpandedIfRequired();
        }
        for (State s : a1.getAcceptStates()) {
            s.accept = false;
            s.addEpsilon(a2.initial);
        }
        a1.deterministic = deterministic;
        a1.clearHashCode();
        a1.checkMinimizeAlways();
        return a1;
    }

    public static Automaton concatenate(List<Automaton> l) {
        if (l.isEmpty()) {
            return BasicAutomata.makeEmptyString();
        }
        boolean all_singleton = true;
        for (Automaton automaton : l) {
            if (automaton.isSingleton()) continue;
            all_singleton = false;
            break;
        }
        if (all_singleton) {
            StringBuilder b = new StringBuilder();
            for (Automaton a : l) {
                b.append(a.singleton);
            }
            return BasicAutomata.makeString(b.toString());
        }
        for (Automaton automaton : l) {
            if (!automaton.isEmpty()) continue;
            return BasicAutomata.makeEmpty();
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Automaton a : l) {
            ids.add(System.identityHashCode(a));
        }
        boolean bl = ids.size() != l.size();
        Automaton b = l.get(0);
        b = bl ? b.cloneExpanded() : b.cloneExpandedIfRequired();
        Set<State> ac = b.getAcceptStates();
        boolean first = true;
        for (Automaton a : l) {
            if (first) {
                first = false;
                continue;
            }
            if (a.isEmptyString()) continue;
            Automaton aa = a;
            aa = bl ? aa.cloneExpanded() : aa.cloneExpandedIfRequired();
            Set<State> ns = aa.getAcceptStates();
            for (State s : ac) {
                s.accept = false;
                s.addEpsilon(aa.initial);
                if (!s.accept) continue;
                ns.add(s);
            }
            ac = ns;
        }
        b.deterministic = false;
        b.clearHashCode();
        b.checkMinimizeAlways();
        return b;
    }

    public static Automaton optional(Automaton a) {
        a = a.cloneExpandedIfRequired();
        State s = new State();
        s.addEpsilon(a.initial);
        s.accept = true;
        a.initial = s;
        a.deterministic = false;
        a.clearHashCode();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton repeat(Automaton a) {
        a = a.cloneExpanded();
        State s = new State();
        s.accept = true;
        s.addEpsilon(a.initial);
        for (State p : a.getAcceptStates()) {
            p.addEpsilon(s);
        }
        a.initial = s;
        a.deterministic = false;
        a.clearHashCode();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton repeat(Automaton a, int min) {
        if (min == 0) {
            return BasicOperations.repeat(a);
        }
        ArrayList<Automaton> as = new ArrayList<Automaton>();
        while (min-- > 0) {
            as.add(a);
        }
        as.add(BasicOperations.repeat(a));
        return BasicOperations.concatenate(as);
    }

    public static Automaton repeat(Automaton a, int min, int max) {
        Automaton b;
        if (min > max) {
            return BasicAutomata.makeEmpty();
        }
        max -= min;
        a.expandSingleton();
        if (min == 0) {
            b = BasicAutomata.makeEmptyString();
        } else if (min == 1) {
            b = a.clone();
        } else {
            ArrayList<Automaton> as = new ArrayList<Automaton>();
            while (min-- > 0) {
                as.add(a);
            }
            b = BasicOperations.concatenate(as);
        }
        if (max > 0) {
            Automaton d = a.clone();
            while (--max > 0) {
                Automaton c = a.clone();
                for (State p : c.getAcceptStates()) {
                    p.addEpsilon(d.initial);
                }
                d = c;
            }
            for (State p : b.getAcceptStates()) {
                p.addEpsilon(d.initial);
            }
            b.deterministic = false;
            b.clearHashCode();
            b.checkMinimizeAlways();
        }
        return b;
    }

    public static Automaton complement(Automaton a) {
        a = a.cloneExpandedIfRequired();
        a.determinize();
        a.totalize();
        for (State p : a.getStates()) {
            p.accept = !p.accept;
        }
        a.removeDeadTransitions();
        return a;
    }

    public static Automaton minus(Automaton a1, Automaton a2) {
        if (a1.isEmpty() || a1 == a2) {
            return BasicAutomata.makeEmpty();
        }
        if (a2.isEmpty()) {
            return a1.cloneIfRequired();
        }
        if (a1.isSingleton()) {
            if (a2.run(a1.singleton)) {
                return BasicAutomata.makeEmpty();
            }
            return a1.cloneIfRequired();
        }
        return BasicOperations.intersection(a1, a2.complement());
    }

    public static Automaton intersection(Automaton a1, Automaton a2) {
        if (a1.isSingleton()) {
            if (a2.run(a1.singleton)) {
                return a1.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (a2.isSingleton()) {
            if (a1.run(a2.singleton)) {
                return a2.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (a1 == a2) {
            return a1.cloneIfRequired();
        }
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        Automaton c = new Automaton();
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> newstates = new HashMap<StatePair, StatePair>();
        StatePair p = new StatePair(c.initial, a1.initial, a2.initial);
        worklist.add(p);
        newstates.put(p, p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            p.s.accept = p.s1.accept && p.s2.accept;
            Transition[] t1 = transitions1[p.s1.number];
            Transition[] t2 = transitions2[p.s2.number];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].max < t1[n1].min) continue;
                    StatePair q = new StatePair(t1[n1].to, t2[n2].to);
                    StatePair r = (StatePair)newstates.get(q);
                    if (r == null) {
                        q.s = new State();
                        worklist.add(q);
                        newstates.put(q, q);
                        r = q;
                    }
                    char min = t1[n1].min > t2[n2].min ? t1[n1].min : t2[n2].min;
                    char max = t1[n1].max < t2[n2].max ? t1[n1].max : t2[n2].max;
                    p.s.transitions.add(new Transition(min, max, r.s));
                }
            }
        }
        c.deterministic = a1.deterministic && a2.deterministic;
        c.removeDeadTransitions();
        c.checkMinimizeAlways();
        return c;
    }

    public static boolean subsetOf(Automaton a1, Automaton a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1.isSingleton()) {
            if (a2.isSingleton()) {
                return a1.singleton.equals(a2.singleton);
            }
            return a2.run(a1.singleton);
        }
        a2.determinize();
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashSet<StatePair> visited = new HashSet<StatePair>();
        StatePair p = new StatePair(a1.initial, a2.initial);
        worklist.add(p);
        visited.add(p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            if (p.s1.accept && !p.s2.accept) {
                return false;
            }
            Transition[] t1 = transitions1[p.s1.number];
            Transition[] t2 = transitions2[p.s2.number];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                char min1 = t1[n1].min;
                char max1 = t1[n1].max;
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].min > min1) {
                        return false;
                    }
                    if (t2[n2].max < '\uffff') {
                        min1 = t2[n2].max + '\u0001';
                    } else {
                        min1 = '\uffff';
                        max1 = '\u0000';
                    }
                    StatePair q = new StatePair(t1[n1].to, t2[n2].to);
                    if (visited.contains(q)) continue;
                    worklist.add(q);
                    visited.add(q);
                }
                if (min1 > max1) continue;
                return false;
            }
        }
        return true;
    }

    public static Automaton union(Automaton a1, Automaton a2) {
        if (a1.isSingleton() && a2.isSingleton() && a1.singleton.equals(a2.singleton) || a1 == a2) {
            return a1.cloneIfRequired();
        }
        a1 = a1.cloneExpandedIfRequired();
        a2 = a2.cloneExpandedIfRequired();
        State s = new State();
        s.addEpsilon(a1.initial);
        s.addEpsilon(a2.initial);
        a1.initial = s;
        a1.deterministic = false;
        a1.clearHashCode();
        a1.checkMinimizeAlways();
        return a1;
    }

    public static Automaton union(Collection<Automaton> l) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Automaton a : l) {
            ids.add(System.identityHashCode(a));
        }
        boolean has_aliases = ids.size() != l.size();
        State s = new State();
        for (Automaton b : l) {
            if (b.isEmpty()) continue;
            Automaton bb = b;
            bb = has_aliases ? bb.cloneExpanded() : bb.cloneExpandedIfRequired();
            s.addEpsilon(bb.initial);
        }
        Automaton a = new Automaton();
        a.initial = s;
        a.deterministic = false;
        a.clearHashCode();
        a.checkMinimizeAlways();
        return a;
    }

    public static void determinize(Automaton a) {
        if (a.deterministic || a.isSingleton()) {
            return;
        }
        HashSet<State> initialset = new HashSet<State>();
        initialset.add(a.initial);
        BasicOperations.determinize(a, initialset);
    }

    static void determinize(Automaton a, Set<State> initialset) {
        char[] points = a.getStartPoints();
        LinkedList<Set<State>> worklist = new LinkedList<Set<State>>();
        HashMap<Set<State>, State> newstate = new HashMap<Set<State>, State>();
        worklist.add(initialset);
        a.initial = new State();
        newstate.put(initialset, a.initial);
        while (worklist.size() > 0) {
            Set s = (Set)worklist.removeFirst();
            State r = (State)newstate.get(s);
            for (State q : s) {
                if (!q.accept) continue;
                r.accept = true;
                break;
            }
            for (int n = 0; n < points.length; ++n) {
                HashSet<State> p = new HashSet<State>();
                for (State q : s) {
                    for (Transition t : q.transitions) {
                        if (t.min > points[n] || points[n] > t.max) continue;
                        p.add(t.to);
                    }
                }
                if (p.isEmpty()) continue;
                State q = (State)newstate.get(p);
                if (q == null) {
                    worklist.add(p);
                    q = new State();
                    newstate.put(p, q);
                }
                char min = points[n];
                char max = n + 1 < points.length ? (char)((char)(points[n + 1] - '\u0001')) : (char)'\uffff';
                r.transitions.add(new Transition(min, max, q));
            }
        }
        a.deterministic = true;
        a.removeDeadTransitions();
    }

    public static void addEpsilons(Automaton a, Collection<StatePair> pairs) {
        a.expandSingleton();
        HashMap<State, HashSet<State>> forward = new HashMap<State, HashSet<State>>();
        HashMap<State, HashSet<State>> back = new HashMap<State, HashSet<State>>();
        for (StatePair p : pairs) {
            HashSet<State> to = (HashSet<State>)forward.get(p.s1);
            if (to == null) {
                to = new HashSet<State>();
                forward.put(p.s1, to);
            }
            to.add(p.s2);
            HashSet<State> from = (HashSet<State>)back.get(p.s2);
            if (from == null) {
                from = new HashSet<State>();
                back.put(p.s2, from);
            }
            from.add(p.s1);
        }
        LinkedList<StatePair> worklist = new LinkedList<StatePair>(pairs);
        HashSet<StatePair> workset = new HashSet<StatePair>(pairs);
        while (!worklist.isEmpty()) {
            StatePair p = worklist.removeFirst();
            workset.remove(p);
            HashSet to = (HashSet)forward.get(p.s2);
            HashSet from = (HashSet)back.get(p.s1);
            if (to == null) continue;
            for (State s : to) {
                StatePair pp = new StatePair(p.s1, s);
                if (pairs.contains(pp)) continue;
                pairs.add(pp);
                ((HashSet)forward.get(p.s1)).add(s);
                ((HashSet)back.get(s)).add(p.s1);
                worklist.add(pp);
                workset.add(pp);
                if (from == null) continue;
                for (State q : from) {
                    StatePair qq = new StatePair(q, p.s1);
                    if (workset.contains(qq)) continue;
                    worklist.add(qq);
                    workset.add(qq);
                }
            }
        }
        for (StatePair p : pairs) {
            p.s1.addEpsilon(p.s2);
        }
        a.deterministic = false;
        a.clearHashCode();
        a.checkMinimizeAlways();
    }

    public static boolean isEmptyString(Automaton a) {
        if (a.isSingleton()) {
            return a.singleton.length() == 0;
        }
        return a.initial.accept && a.initial.transitions.isEmpty();
    }

    public static boolean isEmpty(Automaton a) {
        if (a.isSingleton()) {
            return false;
        }
        return !a.initial.accept && a.initial.transitions.isEmpty();
    }

    public static boolean isTotal(Automaton a) {
        if (a.isSingleton()) {
            return false;
        }
        if (a.initial.accept && a.initial.transitions.size() == 1) {
            Transition t = a.initial.transitions.iterator().next();
            return t.to == a.initial && t.min == '\u0000' && t.max == '\uffff';
        }
        return false;
    }

    public static String getShortestExample(Automaton a, boolean accepted) {
        if (a.isSingleton()) {
            if (accepted) {
                return a.singleton;
            }
            if (a.singleton.length() > 0) {
                return "";
            }
            return "\u0000";
        }
        return BasicOperations.getShortestExample(a.getInitialState(), accepted);
    }

    static String getShortestExample(State s, boolean accepted) {
        HashMap<State, String> path = new HashMap<State, String>();
        LinkedList<State> queue = new LinkedList<State>();
        path.put(s, "");
        queue.add(s);
        String best = null;
        while (!queue.isEmpty()) {
            State q = (State)queue.removeFirst();
            String p = (String)path.get(q);
            if (q.accept == accepted) {
                if (best != null && p.length() >= best.length() && (p.length() != best.length() || p.compareTo(best) >= 0)) continue;
                best = p;
                continue;
            }
            for (Transition t : q.getTransitions()) {
                String tp = (String)path.get(t.to);
                String np = p + t.min;
                if (tp != null && (tp.length() != np.length() || np.compareTo(tp) >= 0)) continue;
                if (tp == null) {
                    queue.addLast(t.to);
                }
                path.put(t.to, np);
            }
        }
        return best;
    }

    public static boolean run(Automaton a, String s) {
        if (a.isSingleton()) {
            return s.equals(a.singleton);
        }
        if (a.deterministic) {
            State p = a.initial;
            for (int i = 0; i < s.length(); ++i) {
                State q = p.step(s.charAt(i));
                if (q == null) {
                    return false;
                }
                p = q;
            }
            return p.accept;
        }
        Set<State> states = a.getStates();
        Automaton.setStateNumbers(states);
        LinkedList<State> pp = new LinkedList<State>();
        LinkedList<State> pp_other = new LinkedList<State>();
        BitSet bb = new BitSet(states.size());
        BitSet bb_other = new BitSet(states.size());
        pp.add(a.initial);
        ArrayList<State> dest = new ArrayList<State>();
        boolean accept = a.initial.accept;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            accept = false;
            pp_other.clear();
            bb_other.clear();
            for (State p : pp) {
                dest.clear();
                p.step(c, dest);
                for (State q : dest) {
                    if (q.accept) {
                        accept = true;
                    }
                    if (bb_other.get(q.number)) continue;
                    bb_other.set(q.number);
                    pp_other.add(q);
                }
            }
            LinkedList<State> tp = pp;
            pp = pp_other;
            pp_other = tp;
            BitSet tb = bb;
            bb = bb_other;
            bb_other = tb;
        }
        return accept;
    }
}

