/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ProcessingContext;
import com.intellij.vcsUtil.ActionWithTempFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4MoveRenameOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationOnPath;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class P4CopyOperation
extends VcsOperationOnPath {
    private String mySourcePath;

    public P4CopyOperation() {
    }

    public P4CopyOperation(String changeList, VirtualFile vFile, VirtualFile copyFrom) {
        super(changeList, vFile.getPath());
        this.mySourcePath = copyFrom.getPath();
    }

    public String getSourcePath() {
        return this.mySourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.mySourcePath = sourcePath;
    }

    @Override
    public void execute(final Project project, ProcessingContext context) throws VcsException {
        final P4File sourceFile = P4File.createInefficientFromLocalPath(this.mySourcePath);
        FStat sourceFStat = sourceFile.getFstat(project, false);
        if (sourceFStat.status != FStat.STATUS_NOT_ADDED && sourceFStat.status != FStat.STATUS_ONLY_LOCAL && sourceFStat.local != FStat.LOCAL_ADDING && sourceFStat.local != FStat.LOCAL_MOVE_ADDING) {
            P4Connection targetConnection;
            final P4File targetFile = P4File.createInefficientFromLocalPath(this.myPath);
            P4Connection srcConnection = PerforceConnectionManager.getInstance(project).getConnectionForFile(sourceFile);
            if (P4MoveRenameOperation.isCompatibleConnection(srcConnection, targetConnection = PerforceConnectionManager.getInstance(project).getConnectionForFile(targetFile))) {
                new ActionWithTempFile(targetFile.getLocalFile()){

                    protected void executeInternal() throws VcsException {
                        PerforceRunner runner = PerforceRunner.getInstance(project);
                        runner.integrate(sourceFile, targetFile);
                        runner.edit(targetFile);
                    }
                }.execute();
                VcsUtil.markFileAsDirty((Project)project, (String)this.myPath);
                return;
            }
        }
        new P4AddOperation(ChangeListManager.getInstance((Project)project).getDefaultChangeList().getName(), this.myPath).execute(project, context);
    }

    @Override
    public List<String> getAffectedPaths() {
        return Arrays.asList(this.getPath(), this.mySourcePath);
    }
}

