/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation;

import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeDocumentationProvider
extends DocumentationProviderEx
implements ExternalDocumentationProvider,
ExternalDocumentationHandler {
    private static final Logger LOG = Logger.getInstance(CompositeDocumentationProvider.class);
    private final List<DocumentationProvider> myProviders;

    public static DocumentationProvider wrapProviders(Collection<? extends DocumentationProvider> providers) {
        ArrayList<DocumentationProvider> list = new ArrayList<DocumentationProvider>();
        for (DocumentationProvider documentationProvider : providers) {
            if (documentationProvider instanceof CompositeDocumentationProvider) {
                list.addAll(((CompositeDocumentationProvider)documentationProvider).getProviders());
                continue;
            }
            if (documentationProvider == null) continue;
            list.add(documentationProvider);
        }
        return new CompositeDocumentationProvider(Collections.unmodifiableList(list));
    }

    private CompositeDocumentationProvider(List<DocumentationProvider> providers) {
        this.myProviders = providers;
    }

    @NotNull
    public List<DocumentationProvider> getAllProviders() {
        SmartList result2 = new SmartList(this.getProviders());
        result2.addAll(EP_NAME.getExtensionList());
        ContainerUtil.removeDuplicates((Collection)result2);
        SmartList smartList = result2;
        if (smartList == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    @NotNull
    public List<DocumentationProvider> getProviders() {
        List<DocumentationProvider> list = this.myProviders;
        if (list == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean handleExternal(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider)).handleExternal(element, originalElement)) continue;
            LOG.debug("handleExternal: ", new Object[]{provider});
            return true;
        }
        return false;
    }

    @Override
    public boolean handleExternalLink(PsiManager psiManager, String link, PsiElement context) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider)).handleExternalLink(psiManager, link, context)) continue;
            LOG.debug("handleExternalLink: ", new Object[]{provider});
            return true;
        }
        return false;
    }

    @Override
    public boolean canFetchDocumentationLink(String link) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider)).canFetchDocumentationLink(link)) continue;
            LOG.debug("canFetchDocumentationLink: ", new Object[]{provider});
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String fetchExternalDocumentation(@NotNull String link, @Nullable PsiElement element) {
        if (link == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(2);
        }
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider)).canFetchDocumentationLink(link)) continue;
            LOG.debug("fetchExternalDocumentation: ", new Object[]{provider});
            String string = ((ExternalDocumentationHandler)((Object)provider)).fetchExternalDocumentation(link, element);
            if (string == null) {
                CompositeDocumentationProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        throw new IllegalStateException("Unable to find a provider to fetch documentation link!");
    }

    @Override
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            String result2 = provider.getQuickNavigateInfo(element, originalElement);
            if (result2 == null) continue;
            LOG.debug("getQuickNavigateInfo: ", new Object[]{provider});
            return result2;
        }
        return null;
    }

    @Override
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            List<String> result2 = provider.getUrlFor(element, originalElement);
            if (result2 == null) continue;
            LOG.debug("getUrlFor: ", new Object[]{provider});
            return result2;
        }
        return null;
    }

    @Override
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            String result2 = provider.generateDoc(element, originalElement);
            if (result2 == null) continue;
            LOG.debug("generateDoc: ", new Object[]{provider});
            return result2;
        }
        return null;
    }

    @Override
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            PsiElement result2 = provider.getDocumentationElementForLookupItem(psiManager, object, element);
            if (result2 == null) continue;
            LOG.debug("getDocumentationElementForLookupItem: ", new Object[]{provider});
            return result2;
        }
        return null;
    }

    @Override
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            PsiElement result2 = provider.getDocumentationElementForLink(psiManager, link, context);
            if (result2 == null) continue;
            LOG.debug("getDocumentationElementForLink: ", new Object[]{provider});
            return result2;
        }
        return null;
    }

    @Nullable
    public CodeDocumentationProvider getFirstCodeDocumentationProvider() {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof CodeDocumentationProvider)) continue;
            LOG.debug("getFirstCodeDocumentationProvider: ", new Object[]{provider});
            return (CodeDocumentationProvider)provider;
        }
        return null;
    }

    @Override
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            String doc;
            if (!(provider instanceof ExternalDocumentationProvider) || (doc = ((ExternalDocumentationProvider)((Object)provider)).fetchExternalDocumentation(project, element, docUrls)) == null) continue;
            LOG.debug("fetchExternalDocumentation: ", new Object[]{provider});
            return doc;
        }
        return null;
    }

    @Override
    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!CompositeDocumentationProvider.hasUrlsFor(provider, element, originalElement)) continue;
            LOG.debug("handleExternal(hasUrlsFor): ", new Object[]{provider});
            return true;
        }
        return false;
    }

    @Override
    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationProvider) || !((ExternalDocumentationProvider)((Object)provider)).canPromptToConfigureDocumentation(element)) continue;
            LOG.debug("canPromptToConfigureDocumentation: ", new Object[]{provider});
            return true;
        }
        return false;
    }

    @Override
    public void promptToConfigureDocumentation(PsiElement element) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationProvider) || !((ExternalDocumentationProvider)((Object)provider)).canPromptToConfigureDocumentation(element)) continue;
            ((ExternalDocumentationProvider)((Object)provider)).promptToConfigureDocumentation(element);
            LOG.debug("promptToConfigureDocumentation: ", new Object[]{provider});
            break;
        }
    }

    public static boolean hasUrlsFor(DocumentationProvider provider, PsiElement element, PsiElement originalElement) {
        List<String> urls = provider.getUrlFor(element, originalElement);
        return urls != null && !urls.isEmpty();
    }

    @Override
    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        if (editor == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(5);
        }
        for (DocumentationProvider provider : this.getAllProviders()) {
            PsiElement element;
            if (!(provider instanceof DocumentationProviderEx) || (element = ((DocumentationProviderEx)provider).getCustomDocumentationElement(editor, file, contextElement)) == null) continue;
            LOG.debug("getCustomDocumentationElement: ", new Object[]{provider});
            return element;
        }
        return null;
    }

    public String toString() {
        return this.getProviders().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/documentation/CompositeDocumentationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/documentation/CompositeDocumentationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchExternalDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fetchExternalDocumentation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

