/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ReadonlyStatusHandler {
    public static boolean ensureFilesWritable(@NotNull Project project, VirtualFile ... files) {
        if (project == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(0);
        }
        if (files == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(1);
        }
        return !ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(files).hasReadonlyFiles();
    }

    public static boolean ensureDocumentWritable(@NotNull Project project, @NotNull Document document) {
        VirtualFile virtualFile2;
        PsiFile psiFile;
        if (project == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(2);
        }
        if (document == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(3);
        }
        boolean okWritable = (psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document)) == null ? document.isWritable() : ((virtualFile2 = psiFile.getVirtualFile()) != null ? ReadonlyStatusHandler.ensureFilesWritable(project, virtualFile2) : psiFile.isWritable());
        return okWritable;
    }

    public abstract OperationStatus ensureFilesWritable(VirtualFile ... var1);

    public OperationStatus ensureFilesWritable(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(4);
        }
        return this.ensureFilesWritable(VfsUtilCore.toVirtualFileArray(files));
    }

    public static ReadonlyStatusHandler getInstance(@NotNull Project project) {
        if (project == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(5);
        }
        return ServiceManager.getService(project, ReadonlyStatusHandler.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/ReadonlyStatusHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureFilesWritable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureDocumentWritable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class OperationStatus {
        @NotNull
        public abstract VirtualFile[] getReadonlyFiles();

        public abstract boolean hasReadonlyFiles();

        @NotNull
        public abstract String getReadonlyFilesMessage();
    }
}

