/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubMissingTokenException;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubUtil$sam$java_lang_Runnable$0;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\u001c\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!2\b\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0007J \u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J/\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010*2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u00020-0,H\u0007\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUtil;", "", "()V", "GIT_AUTH_PASSWORD_SUBSTITUTE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SERVICE_DISPLAY_NAME", "addCancellationListener", "Ljava/util/concurrent/ScheduledFuture;", "run", "Lkotlin/Function0;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "thread", "Ljava/lang/Thread;", "findGithubRemote", "Lcom/intellij/openapi/util/Pair;", "Lgit4idea/repo/GitRemote;", "repository", "Lgit4idea/repo/GitRepository;", "findGithubRemoteUrl", "findUpstreamRemote", "getErrorTextFromException", "e", "", "getGitRepository", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getGithubLikeFormattedDescriptionMessage", "Lcom/intellij/openapi/util/Couple;", "commitMessage", "getValidAuthDataHolderFromConfig", "Lorg/jetbrains/plugins/github/util/GithubAuthDataHolder;", "authLevel", "Lorg/jetbrains/plugins/github/util/AuthLevel;", "isRepositoryOnGitHub", "", "runInterruptable", "T", "task", "Lcom/intellij/openapi/util/ThrowableComputable;", "Ljava/io/IOException;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "intellij.vcs.github"})
public final class GithubUtil {
    @JvmField
    @NotNull
    public static final Logger LOG;
    @NotNull
    public static final String SERVICE_DISPLAY_NAME = "GitHub";
    @NotNull
    public static final String GIT_AUTH_PASSWORD_SUBSTITUTE = "x-oauth-basic";
    public static final GithubUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final ScheduledFuture<?> addCancellationListener(@NotNull Function0<Unit> run2) {
        Intrinsics.checkParameterIsNotNull(run2, (String)"run");
        Function0<Unit> function0 = run2;
        ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(new GithubUtil$sam$java_lang_Runnable$0(function0), 1000L, 300L, TimeUnit.MILLISECONDS);
        Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, (String)"JobScheduler.getSchedule\u20260, TimeUnit.MILLISECONDS)");
        return scheduledFuture;
    }

    private final ScheduledFuture<?> addCancellationListener(ProgressIndicator indicator, Thread thread) {
        return GithubUtil.addCancellationListener((Function0<Unit>)((Function0)new Function0<Unit>(indicator, thread){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Thread $thread;

            public final void invoke() {
                if (this.$indicator.isCanceled()) {
                    this.$thread.interrupt();
                }
            }
            {
                this.$indicator = progressIndicator;
                this.$thread = thread;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final <T> T runInterruptable(@NotNull ProgressIndicator indicator, @NotNull ThrowableComputable<T, IOException> task) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        ScheduledFuture<?> future = null;
        try {
            Thread thread;
            Thread thread2 = thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"thread");
            future = INSTANCE.addCancellationListener(indicator, thread2);
            Object object = task.compute();
            return (T)object;
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            Thread.interrupted();
        }
    }

    @JvmStatic
    @NotNull
    public static final String getErrorTextFromException(@NotNull Throwable e) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (e instanceof UnknownHostException) {
            string = "Unknown host: " + e.getMessage();
        } else {
            String string2 = StringUtil.notNullize((String)e.getMessage(), (String)"Unknown error");
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.notNullize(e.message, \"Unknown error\")");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Couple<String> getGithubLikeFormattedDescriptionMessage(@Nullable String commitMessage) {
        String description;
        String subject;
        int startFound$iv$iv;
        CharSequence $receiver$iv;
        String string;
        block18: {
            block17: {
                string = commitMessage;
                if (string == null) break block17;
                $receiver$iv = string;
                CharSequence $receiver$iv$iv = $receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                startFound$iv$iv = 0;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = startFound$iv$iv == 0 ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (startFound$iv$iv == 0) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = 1;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((string = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()) != null) break block18;
            }
            string = "";
        }
        String message = string;
        $receiver$iv = message;
        if ($receiver$iv.length() == 0) {
            Couple couple = Couple.of((Object)"", (Object)"");
            Intrinsics.checkExpressionValueIsNotNull((Object)couple, (String)"Couple.of(\"\", \"\")");
            return couple;
        }
        int firstLineEnd = StringsKt.indexOf$default((CharSequence)message, (String)"\n", (int)0, (boolean)false, (int)6, null);
        if (firstLineEnd > -1) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String $receiver$iv2;
            String endIndex$iv$iv = message;
            startFound$iv$iv = 0;
            String string2 = endIndex$iv$iv;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(startFound$iv$iv, firstLineEnd);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            endIndex$iv$iv = string3;
            CharSequence $receiver$iv$iv22 = $receiver$iv2;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv2 = $receiver$iv$iv22.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv <= endIndex$iv$iv2) {
                index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv2;
                it = $receiver$iv$iv22.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            subject = ((Object)$receiver$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv2 + 1)).toString();
            $receiver$iv2 = message;
            int $receiver$iv$iv22 = firstLineEnd + 1;
            String string4 = $receiver$iv2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring($receiver$iv$iv22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            $receiver$iv2 = string5;
            CharSequence $receiver$iv$iv = $receiver$iv2;
            startIndex$iv$iv = 0;
            endIndex$iv$iv2 = $receiver$iv$iv.length() - 1;
            startFound$iv$iv2 = false;
            while (startIndex$iv$iv <= endIndex$iv$iv2) {
                index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv2;
                it = $receiver$iv$iv.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            description = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv2 + 1)).toString();
        } else {
            subject = message;
            description = "";
        }
        Couple couple = Couple.of((Object)subject, (Object)description);
        Intrinsics.checkExpressionValueIsNotNull((Object)couple, (String)"Couple.of(subject, description)");
        return couple;
    }

    @JvmStatic
    @Deprecated(message="{@link GithubAuthenticationManager}")
    @NotNull
    public static final GithubAuthDataHolder getValidAuthDataHolderFromConfig(@NotNull Project project, @NotNull AuthLevel authLevel, @NotNull ProgressIndicator indicator) throws IOException {
        GithubAuthDataHolder githubAuthDataHolder;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)authLevel, (String)"authLevel");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        GithubAuthenticationManager authManager = GithubAuthenticationManager.Companion.getInstance();
        GithubAccount account = authManager.getSingleOrDefaultAccount(project);
        if (account == null) {
            account = (GithubAccount)ActionsKt.invokeAndWaitIfNeed((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<GithubAccount>(authManager, project){
                final /* synthetic */ GithubAuthenticationManager $authManager;
                final /* synthetic */ Project $project;

                @Nullable
                public final GithubAccount invoke() {
                    return GithubAuthenticationManager.requestNewAccount$default(this.$authManager, this.$project, null, 2, null);
                }
                {
                    this.$authManager = githubAuthenticationManager;
                    this.$project = project;
                    super(0);
                }
            }));
        }
        if (account == null) {
            throw (Throwable)new ProcessCanceledException();
        }
        if (authLevel.getAuthType() == GithubAuthData.AuthType.ANONYMOUS) {
            githubAuthDataHolder = new GithubAuthDataHolder(GithubAuthData.createAnonymous(account.getServer().toString()));
        } else {
            String string = authManager.getTokenForAccount$intellij_vcs_github(account);
            if (string == null) {
                throw (Throwable)new GithubMissingTokenException(account);
            }
            String token2 = string;
            githubAuthDataHolder = new GithubAuthDataHolder(GithubAuthData.createTokenAuth(account.getServer().toString(), token2, true));
        }
        return githubAuthDataHolder;
    }

    @JvmStatic
    @Deprecated(message="{@link GithubGitHelper}", replaceWith=@ReplaceWith(imports={"org.jetbrains.plugins.github.util.GithubGitHelper"}, expression="GithubGitHelper.findGitRepository(project, file)"))
    @Nullable
    public static final GitRepository getGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return GithubGitHelper.Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @Deprecated(message="{@link GithubGitHelper}")
    @Nullable
    public static final String findGithubRemoteUrl(@NotNull GitRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Pair<GitRemote, String> pair = GithubUtil.findGithubRemote(repository);
        if (pair == null) {
            return null;
        }
        Pair<GitRemote, String> remote = pair;
        return (String)remote.getSecond();
    }

    @JvmStatic
    @Deprecated(message="{@link org.jetbrains.plugins.github.api.GithubServerPath}, {@link GithubGitHelper}")
    @Nullable
    public static final Pair<GitRemote, String> findGithubRemote(@NotNull GitRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        GithubAuthenticationManager githubAuthenticationManager = GithubAuthenticationManager.Companion.getInstance();
        Project project = repository.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"repository.project");
        Object object = githubAuthenticationManager.getSingleOrDefaultAccount(project);
        if (object == null || (object = ((GithubAccount)object).getServer()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GithubAuthenticationMana\u2026t)?.server ?: return null");
        Object server = object;
        Pair githubRemote = null;
        Iterator iterator = repository.getRemotes().iterator();
        block0: while (iterator.hasNext()) {
            GitRemote gitRemote;
            GitRemote gitRemote2 = gitRemote = (GitRemote)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote2, (String)"gitRemote");
            for (String remoteUrl : gitRemote2.getUrls()) {
                String remoteName;
                if (!((GithubServerPath)server).matches(remoteUrl)) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote.getName(), (String)"gitRemote.name");
                if (Intrinsics.areEqual((Object)"github", (Object)remoteName) || Intrinsics.areEqual((Object)"origin", (Object)remoteName)) {
                    return Pair.create((Object)gitRemote, (Object)remoteUrl);
                }
                if (githubRemote != null) continue block0;
                githubRemote = Pair.create((Object)gitRemote, (Object)remoteUrl);
                continue block0;
            }
        }
        return githubRemote;
    }

    @JvmStatic
    @Deprecated(message="{@link org.jetbrains.plugins.github.api.GithubServerPath}, {@link GithubGitHelper}")
    @Nullable
    public static final String findUpstreamRemote(@NotNull GitRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        GithubAuthenticationManager githubAuthenticationManager = GithubAuthenticationManager.Companion.getInstance();
        Project project = repository.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"repository.project");
        Object object = githubAuthenticationManager.getSingleOrDefaultAccount(project);
        if (object == null || (object = ((GithubAccount)object).getServer()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GithubAuthenticationMana\u2026t)?.server ?: return null");
        Object server = object;
        Iterator iterator = repository.getRemotes().iterator();
        while (iterator.hasNext()) {
            String remoteName;
            GitRemote gitRemote;
            GitRemote gitRemote2 = gitRemote = (GitRemote)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote2, (String)"gitRemote");
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote2.getName(), (String)"gitRemote.name");
            if (!Intrinsics.areEqual((Object)"upstream", (Object)remoteName)) continue;
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!((GithubServerPath)server).matches(remoteUrl)) continue;
                return remoteUrl;
            }
            return gitRemote.getFirstUrl();
        }
        return null;
    }

    @JvmStatic
    @Deprecated(message="{@link org.jetbrains.plugins.github.api.GithubServerPath}")
    public static final boolean isRepositoryOnGitHub(@NotNull GitRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return GithubUtil.findGithubRemoteUrl(repository) != null;
    }

    private GithubUtil() {
    }

    static {
        GithubUtil githubUtil;
        INSTANCE = githubUtil = new GithubUtil();
        Logger logger = Logger.getInstance((String)"github");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"github\")");
        LOG = logger;
    }
}

