/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.util.TokenPattern;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.impl.lexer.PreprocessorMatchState;
import java.util.regex.MatchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PreprocessingLexer
extends DelegateLexer {
    private Integer myStoredState;
    private final PreprocessorMatchState myMatchState;
    private int myEndOffset;

    public PreprocessingLexer(@NotNull Lexer delegate, TokenPattern pattern) {
        if (delegate == null) {
            PreprocessingLexer.$$$reportNull$$$0(0);
        }
        super(delegate);
        this.myMatchState = new PreprocessorMatchState(pattern);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            PreprocessingLexer.$$$reportNull$$$0(1);
        }
        super.start(buffer, startOffset, endOffset, initialState < 0 ? -initialState - 1 : initialState);
        this.myMatchState.reset(buffer);
        this.myEndOffset = endOffset;
        this.matchCurrentToken();
    }

    protected void advanceIntoMatch(int state) {
        this.myStoredState = state;
        this.onNextMatched();
    }

    private void correctCurrentMatch() {
        int start = this.getOriginalStart();
        int end = this.getOriginalEnd();
        assert (this.getMatchStart() >= start);
        if (this.getMatchStart() >= end) {
            return;
        }
        if (this.skipToken(this.getOriginalType(), start, end, this.getMatchStart(), this.getMatchEnd())) {
            this.myMatchState.resetTo(end);
        }
    }

    protected IElementType getOriginalType() {
        return super.getTokenType();
    }

    protected void onMatchFound() {
        if (this.getMatchStart() == this.getOriginalStart()) {
            this.advanceIntoMatch(this.getState());
        } else {
            this.myStoredState = null;
        }
    }

    protected boolean skipToken(IElementType tokenType, int s, int e, int ms, int me) {
        return false;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    public void advance() {
        if (this.myStoredState != null) {
            if (!this.advanceInMatched()) {
                this.advanceOutOfMatch();
            }
        } else if (this.myMatchState.hasMatch() && this.getMatchStart() < this.getOriginalEnd()) {
            this.advanceIntoMatch(this.getState());
        } else {
            this.advanceBase();
        }
    }

    private void advanceOutOfMatch() {
        if (this.getMatchEnd() == this.getOriginalEnd()) {
            this.advanceBase();
        } else {
            this.advanceTokenRest(this.getMatchEnd(), this.myEndOffset, this.myStoredState);
        }
    }

    private void advanceBase() {
        super.advance();
        this.matchCurrentToken();
    }

    protected void advanceTokenRest(int startOffset, int endOffset, int state) {
        CharSequence buffer = this.getBufferSequence();
        String id = "id";
        super.start((CharSequence)id, 0, id.length(), state < 0 ? -state - 1 : state);
        super.advance();
        this.start(buffer, startOffset, endOffset, state < 0 ? -super.getState() - 1 : super.getState());
    }

    private void matchCurrentToken() {
        this.findMatchFrom(this.getOriginalStart());
        this.correctCurrentMatch();
        if (this.myMatchState.hasMatch()) {
            this.onMatchFound();
        } else {
            this.myStoredState = null;
        }
    }

    protected void findMatchFrom(int start) {
        this.myMatchState.findMatchOn(start, this.getOriginalEnd());
    }

    public int getState() {
        return this.myStoredState != null ? -this.myStoredState.intValue() - 1 : super.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myStoredState != null ? this.getMatchedTokenType() : this.getOriginalType();
    }

    public int getTokenStart() {
        return this.myStoredState != null ? this.getMatchedTokenStart() : this.getOriginalStart();
    }

    public int getTokenEnd() {
        return this.myStoredState != null ? this.getMatchedTokenEnd() : Math.min(this.getOriginalEnd(), this.getMatchStart());
    }

    protected int getOriginalStart() {
        return super.getTokenStart();
    }

    protected int getOriginalEnd() {
        return super.getTokenEnd();
    }

    protected void onNextMatched() {
    }

    protected MatchResult getMatch() {
        return this.myMatchState.getMatcher().getResult();
    }

    protected boolean advanceInMatched() {
        return false;
    }

    protected abstract IElementType getMatchedTokenType();

    protected int getMatchedTokenStart() {
        return this.getMatchStart();
    }

    protected int getMatchedTokenEnd() {
        return this.getMatchEnd();
    }

    protected int getMatchStart() {
        return this.myMatchState.start();
    }

    protected int getMatchEnd() {
        return this.myMatchState.end();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/impl/lexer/PreprocessingLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

