/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.CompositeTemplateBlock;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.TemplateXmlBlock;
import com.jetbrains.php.blade.BladeLanguage;
import com.jetbrains.php.blade.formatter.BladeHtmlFileBlock;
import com.jetbrains.php.blade.formatter.BladeLeafBlock;
import com.jetbrains.php.blade.formatter.BladePhpBlock;
import com.jetbrains.php.blade.formatter.BladePhpDirectiveStructureBlock;
import com.jetbrains.php.blade.formatter.BladeSectionFormatHandler;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeFileImpl;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeFormattingModelBuilder
extends AbstractXmlTemplateFormattingModelBuilder {
    public Block createDataLanguageRootBlock(PsiElement dataElement, Language language, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, @NotNull PsiFile psiFile, Indent indent) {
        if (psiFile == null) {
            BladeFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        if (dataElement instanceof PsiFile && language.isKindOf((Language)XMLLanguage.INSTANCE)) {
            return new BladeHtmlFileBlock(this, dataElement, xmlFormattingPolicy, indent);
        }
        return super.createDataLanguageRootBlock(dataElement, language, settings, xmlFormattingPolicy, psiFile, indent);
    }

    protected Block createTemplateLanguageBlock(ASTNode node, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        if (node.getElementType() == BladeTokenTypes.TEMPLATE_PHP_TEXT) {
            return new BladePhpBlock(node, settings, xmlFormattingPolicy, indent);
        }
        if (node.getElementType() == BladeElementTypes.PHP_DIRECTIVE_BLOCK) {
            return new BladePhpDirectiveStructureBlock(node, indent);
        }
        return new BladeLeafBlock(node, indent);
    }

    protected SyntheticBlock createSyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
        subBlocks = BladeSectionFormatHandler.patchBlocksWithSections(subBlocks);
        return super.createSyntheticBlock(subBlocks, parent, indent, policy, childIndent);
    }

    protected boolean isTemplateFile(PsiFile file) {
        return file instanceof BladeFileImpl;
    }

    public boolean isOuterLanguageElement(PsiElement element) {
        IElementType type = element.getNode().getElementType();
        return type == BladeElementTypes.BLADE_OUTER_TYPE;
    }

    public boolean isMarkupLanguageElement(PsiElement element) {
        IElementType theType = element.getNode().getElementType();
        return theType == BladeTokenTypes.TEMPLATE_HTML_TEXT;
    }

    public List<Block> mergeWithTemplateBlocks(List<Block> markupBlocks, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent childrenIndent) throws FragmentedTemplateException {
        ArrayList<Block> patched = null;
        for (Block block : markupBlocks) {
            boolean add = true;
            List<Block> subBlocks = BladeFormattingModelBuilder.getPatchedBlocksToAdd(block);
            if (subBlocks != null) {
                if (patched == null) {
                    patched = new ArrayList<Block>(markupBlocks.size() + subBlocks.size());
                    patched.addAll(markupBlocks.subList(0, markupBlocks.indexOf(block)));
                }
                patched.addAll(subBlocks);
                add = false;
            }
            if (!add || patched == null) continue;
            patched.add(block);
        }
        if (patched != null) {
            markupBlocks = patched;
        }
        return super.mergeWithTemplateBlocks(markupBlocks, settings, xmlFormattingPolicy, childrenIndent);
    }

    @Nullable
    private static List<Block> getPatchedBlocksToAdd(Block block) {
        if (!(block instanceof TemplateXmlBlock)) {
            return null;
        }
        if (((TemplateXmlBlock)block).getNode().getElementType() == XmlElementType.XML_TEXT && !block.isLeaf()) {
            List blocks = block.getSubBlocks();
            if (blocks.isEmpty()) {
                return null;
            }
            for (Block childBlock : blocks) {
                if (!(childBlock instanceof ASTBlock) || ((ASTBlock)childBlock).getNode().getElementType().getLanguage() != BladeLanguage.INSTANCE) continue;
                return blocks;
            }
            return null;
        }
        if (((TemplateXmlBlock)block).getNode().getElementType() != XmlElementType.XML_COMMENT) {
            return null;
        }
        List subBlocks = block.getSubBlocks();
        if (subBlocks.isEmpty()) {
            return null;
        }
        ArrayList<Block> patched = new ArrayList<Block>(subBlocks.size());
        for (int i = 0; i < subBlocks.size(); ++i) {
            Block subBlock = (Block)subBlocks.get(i);
            if (subBlock instanceof XmlBlock && ((XmlBlock)subBlock).getNode().getElementType() == XmlTokenType.XML_COMMENT_START) {
                ArrayList<Block> commentBlocks = new ArrayList<Block>(3);
                commentBlocks.add(subBlock);
                if (i + 1 < subBlocks.size()) {
                    subBlock = (Block)subBlocks.get(i + 1);
                    if (subBlock instanceof XmlBlock && ((XmlBlock)subBlock).getNode().getElementType() == XmlTokenType.XML_COMMENT_CHARACTERS) {
                        ++i;
                        commentBlocks.add(subBlock);
                    }
                    if (i + 1 < subBlocks.size() && (subBlock = (Block)subBlocks.get(i + 1)) instanceof XmlBlock && ((XmlBlock)subBlock).getNode().getElementType() == XmlTokenType.XML_COMMENT_END) {
                        ++i;
                        commentBlocks.add(subBlock);
                    }
                }
                CompositeTemplateBlock unitedCommentBlock = new CompositeTemplateBlock(commentBlocks);
                patched.add((Block)unitedCommentBlock);
                continue;
            }
            patched.add(subBlock);
        }
        return patched;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/php/blade/formatter/BladeFormattingModelBuilder", "createDataLanguageRootBlock"));
    }
}

