/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReplaceImportFromClauseFix
extends FixAndIntentionAction {
    private final String myUnquotedText;

    public ES6ReplaceImportFromClauseFix(@NotNull ES6ImportExportDeclaration importDeclaration, @NotNull String unquotedText) {
        if (importDeclaration == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(0);
        }
        if (unquotedText == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(1);
        }
        this.myUnquotedText = unquotedText;
        this.registerElementRefForFix((PsiElement)importDeclaration, null);
    }

    @Nls
    @NotNull
    public String getName() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String string = ES6ReplaceImportFromClauseFix.getActionText("");
            if (string == null) {
                ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = ES6ReplaceImportFromClauseFix.getActionText(StringUtil.wrapWithDoubleQuote((String)this.myUnquotedText));
        if (string == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file2, Editor editor) {
        if (!psiElement.isValid()) {
            return;
        }
        if (!(psiElement instanceof ES6ImportExportDeclaration)) {
            return;
        }
        ES6ImportExportDeclaration importDeclaration = (ES6ImportExportDeclaration)psiElement;
        ES6FromClause clause = importDeclaration.getFromClause();
        ES6ReplaceImportFromClauseFix.changeImportFromText(clause, this.myUnquotedText);
    }

    public static void changeImportFromText(@Nullable ES6FromClause clause, String unquotedText) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (clause == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(clause.getContainingFile())) {
            return;
        }
        ASTNode node = clause.getNode();
        ASTNode oldValue = node.findChildByType(JSTokenTypes.STRING_LITERALS);
        if (oldValue == null) {
            return;
        }
        String quote = ES6ImportPsiUtil.getQuote((PsiElement)clause, oldValue);
        String x = "import {a} from " + quote + unquotedText + quote;
        ES6ImportDeclaration createdDeclaration = JSChangeUtil.createStatementPsiFromTextWithContext(x, (PsiElement)clause, ES6ImportDeclaration.class);
        if (createdDeclaration == null || createdDeclaration.getFromClause() == null) {
            return;
        }
        clause.replace((PsiElement)createdDeclaration.getFromClause());
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public static String getActionText(@NotNull String with) {
        if (with == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(4);
        }
        String string = JSBundle.message((String)"es6.replace.import.action.name", (Object[])new Object[]{with});
        if (string == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedText";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

