/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSStringLiteralLexer
extends StringLiteralLexer {
    private final boolean myAllowUnicodeEscapesWithinBraces;
    private final boolean myAllowNonEscapesAfterSlash;

    public JSStringLiteralLexer(char quoteChar, IElementType originalLiteralToken, String additionalValidEscapes, boolean allowOctal, boolean allowUnicodeEscapesWithinBraces, boolean allowNonEscapesAfterSlash) {
        super(quoteChar, originalLiteralToken, true, additionalValidEscapes, allowOctal, true);
        this.myAllowUnicodeEscapesWithinBraces = allowUnicodeEscapesWithinBraces;
        this.myAllowNonEscapesAfterSlash = allowNonEscapesAfterSlash;
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        if (this.myAllowUnicodeEscapesWithinBraces && this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            int i = this.myStart + 3;
            boolean foundHex = false;
            boolean hadDigitBefore = false;
            while (i < this.myEnd) {
                char c = this.myBuffer.charAt(i);
                if (hadDigitBefore && c == '_') {
                    ++i;
                    hadDigitBefore = false;
                    continue;
                }
                if (!StringUtil.isHexDigit((char)c)) break;
                foundHex = true;
                hadDigitBefore = true;
                ++i;
            }
            IElementType iElementType = foundHex && i < this.myEnd && this.myBuffer.charAt(i) == '}' ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            if (iElementType == null) {
                JSStringLiteralLexer.$$$reportNull$$$0(0);
            }
            return iElementType;
        }
        int digitsCount = 0;
        boolean hadDigitBefore = false;
        int i = this.myStart + 2;
        while (digitsCount < 4) {
            if (i >= this.myEnd) {
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType == null) {
                    JSStringLiteralLexer.$$$reportNull$$$0(1);
                }
                return iElementType;
            }
            char c = this.myBuffer.charAt(i);
            if (!StringUtil.isHexDigit((char)c)) {
                if (!hadDigitBefore || c != '_') {
                    IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                    if (iElementType == null) {
                        JSStringLiteralLexer.$$$reportNull$$$0(2);
                    }
                    return iElementType;
                }
                hadDigitBefore = false;
            } else {
                hadDigitBefore = true;
                ++digitsCount;
            }
            ++i;
        }
        IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        if (iElementType == null) {
            JSStringLiteralLexer.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @NotNull
    protected IElementType handleSingleSlashEscapeSequence() {
        IElementType iElementType = this.myAllowNonEscapesAfterSlash ? this.myOriginalLiteralToken : super.handleSingleSlashEscapeSequence();
        if (iElementType == null) {
            JSStringLiteralLexer.$$$reportNull$$$0(4);
        }
        return iElementType;
    }

    protected int locateHexEscapeSequence(int start, int i) {
        if (!this.myAllowNonEscapesAfterSlash) {
            return super.locateHexEscapeSequence(start, i);
        }
        ++i;
        boolean isValid = true;
        while (i < start + 4) {
            if (i == this.myBufferEnd) {
                isValid = isValid && i == start + 3;
                return !isValid ? start + 1 : i;
            }
            char c = this.myBuffer.charAt(i);
            if (!StringUtil.isHexDigit((char)c)) {
                isValid = false;
            }
            if (c == '\n' || this.myBuffer.charAt(i) == this.myQuoteChar) {
                return !isValid ? start + 1 : i;
            }
            ++i;
        }
        return !isValid ? start + 1 : i;
    }

    protected int locateUnicodeEscapeSequence(int start, int i) {
        if (this.myAllowUnicodeEscapesWithinBraces && ++i < this.myBufferEnd && this.myBuffer.charAt(i) == '{') {
            ++i;
            boolean hadDigitBefore = false;
            boolean isValid = true;
            while (i < this.myBufferEnd) {
                char c = this.myBuffer.charAt(i);
                if (!StringUtil.isHexDigit((char)c)) {
                    if (!hadDigitBefore || c != '_') {
                        if (c == '}') break;
                        isValid = false;
                        break;
                    }
                    ++i;
                    hadDigitBefore = false;
                    continue;
                }
                hadDigitBefore = true;
                ++i;
            }
            if (i < this.myBufferEnd && this.myBuffer.charAt(i) == '}') {
                ++i;
            }
            return this.myAllowNonEscapesAfterSlash && !isValid ? start + 1 : i;
        }
        int digitsCount = 0;
        boolean isValid = true;
        while (digitsCount < 4) {
            if (i == this.myBufferEnd) {
                return this.myAllowNonEscapesAfterSlash ? start + 1 : i;
            }
            char c = this.myBuffer.charAt(i);
            if (c == '\n' || c == this.myQuoteChar) {
                return this.myAllowNonEscapesAfterSlash && !isValid ? start + 1 : i;
            }
            if (StringUtil.isHexDigit((char)c)) {
                ++digitsCount;
            } else {
                isValid = false;
            }
            ++i;
        }
        return this.myAllowNonEscapesAfterSlash && !isValid ? start + 1 : i;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/JSStringLiteralLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnicodeEscapeSequenceType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "handleSingleSlashEscapeSequence";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

