/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSApplyTypeofType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeUtils {
    @Nullable
    public static PsiElement getScopeInOriginalTree(@NotNull PsiElement scope) {
        if (scope == null) {
            JSTypeUtils.$$$reportNull$$$0(0);
        }
        if (scope instanceof ImplicitJSVariableImpl) {
            return scope;
        }
        PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope);
        if (originalElement != null) {
            return originalElement;
        }
        PsiElement someElementAtOriginalTree = scope.getContainingFile().getOriginalFile().findElementAt(scope.getTextRange().getStartOffset());
        return someElementAtOriginalTree;
    }

    private JSTypeUtils() {
    }

    public static String transformActionScriptSpecificTypesIntoEcma(String type) {
        if ("int".equals(type) || "uint".equals(type)) {
            type = "Number";
        }
        return type;
    }

    public static boolean isInstanceType(@Nullable JSType type) {
        return (type = JSTypeUtils.getValuableType(type)) instanceof JSNamespace && ((JSNamespace)type).getJSContext() == JSContext.INSTANCE && !((JSNamespace)type).isDeclaration();
    }

    public static boolean isNewPropertiesDefinitionAllowed(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) == null || type instanceof JSAnyType || type instanceof JSObjectType || type instanceof JSArrayType || type instanceof JSPrimitiveFunctionType || type instanceof JSFunctionTypeImpl || JSTypeUtils.isMapType(type)) {
            return true;
        }
        if (!type.isSourceStrict()) {
            return true;
        }
        if (JSTypeUtils.isInstanceType(type)) {
            return false;
        }
        if (type instanceof JSFreshObjectLiteralType) {
            return true;
        }
        return !(type instanceof JSRecordType) || !type.isJavaScript() || !type.getSource().isExplicitlyDeclared() || type.getSource().getSourceElement() instanceof JSTypeDeclaration;
    }

    public static boolean isStrictType(@Nullable JSType type) {
        if (type instanceof JSDecoratedType) {
            type = ((JSDecoratedType)type).getOriginalType();
        }
        return JSTypeUtils.isRestrictiveType(type) && type.getSource().isStrict();
    }

    @Contract(value="null -> false")
    public static boolean isRestrictiveType(@Nullable JSType type) {
        return type != null && !(type instanceof JSAnyType) && (!(type instanceof JSUnionType) || !((JSUnionType)type).isAnyType()) && !(type instanceof JSObjectType);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String serializeType(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        if (type.getSource().isEcma()) {
            return type.getTypeText(JSType.TypeTextFormat.SIMPLE);
        }
        StringBuilder builder = new StringBuilder();
        JSTypeSerializer.TYPE_SERIALIZER.write(type, builder);
        return builder.toString();
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static JSType parseSerializedOrJSDocType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(1);
        }
        return JSTypeUtils.createType(typeString, source);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static JSType parseSerializedType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(2);
        }
        return JSTypeUtils.createType(typeString, source);
    }

    public static JSType createTypeFromJSDoc(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source, true);
        return parser.parse(false);
    }

    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(4);
        }
        return JSTypeUtils.createType(typeString, source, false);
    }

    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source);
        return parser.parse(allowCommentAfterType);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(6);
        }
        return JSTypeUtils.createParameterType(typeString, source, false, false);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType, boolean isFromJSDoc) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source, isFromJSDoc);
        return parser.parseParameterType(allowCommentAfterType);
    }

    @Contract(value="null -> false")
    public static boolean isNonArrayRestType(@Nullable JSType type) {
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSArrayType || type instanceof JSGenericTypeImpl && JSArrayTypeImpl.isGenericArray((JSGenericTypeImpl)type) || type instanceof JSTupleType) {
            return true;
        }
        if (!(type instanceof JSGenericParameterImpl)) {
            return false;
        }
        JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
        return constraintType != null && JSTypeUtils.isIterableCollectionType(constraintType);
    }

    public static boolean isIterableCollectionType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(8);
        }
        if (JSTypeUtils.isIndexableType(type)) {
            return true;
        }
        if (JSCommonTypeNames.TYPED_ARRAY_NAMES.contains(type.getTypeText())) {
            return true;
        }
        if ("IArguments".equals(type.getTypeText())) {
            return true;
        }
        return type.asRecordType().hasProperty("[Symbol.iterator]");
    }

    public static boolean isIndexableType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(9);
        }
        return JSTypeUtils.getIndexableComponentType(type, false) != null;
    }

    public static boolean isMapType(@NotNull JSType type) {
        JSType baseType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(10);
        }
        if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getArguments().size() == 2 && (baseType = ((JSGenericTypeImpl)type).getType()) instanceof JSNamedType) {
            String typeText = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE);
            return "Array".equals(typeText) || "Object".equals(typeText) || "Map".equals(typeText) || "WeakMap".equals(typeText);
        }
        return false;
    }

    public static boolean isPromiseType(@Nullable JSType type) {
        return (type = JSTypeUtils.getValuableType(type)) != null && "Promise".equals(JSTypeUtils.getQualifiedNameMatchingType(type, false));
    }

    @NotNull
    public static JSType wrapInPromiseType(@NotNull JSType jsType) {
        if (jsType == null) {
            JSTypeUtils.$$$reportNull$$$0(11);
        }
        JSType promiseType = JSNamedTypeFactory.createExplicitlyDeclaredType("Promise", jsType.getSource().getSourceElement());
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(promiseType.getSource(), promiseType, jsType);
        if (jSGenericTypeImpl == null) {
            JSTypeUtils.$$$reportNull$$$0(12);
        }
        return jSGenericTypeImpl;
    }

    @Nullable
    public static JSType getPromiseComponentTypeOrNull(@NotNull JSType type) {
        List<JSType> arguments;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(13);
        }
        if (type instanceof JSGenericTypeImpl && (arguments = ((JSGenericTypeImpl)type).getArguments()).size() >= 1) {
            return (JSType)ContainerUtil.getFirstItem(arguments);
        }
        return null;
    }

    public static JSType getIndexableComponentType(@Nullable JSType type) {
        return JSTypeUtils.getIndexableComponentType(type, true);
    }

    @Nullable
    public static JSType getIndexableComponentType(@Nullable JSType type, boolean includeIndexers) {
        if (type instanceof JSArrayTypeImpl) {
            return ((JSArrayTypeImpl)type).getType();
        }
        if (type instanceof JSTupleType) {
            return JSTypeUtils.getIndexableComponentType(((JSTupleType)type).toArrayType(true), false);
        }
        if (type instanceof JSPrimitiveArrayType) {
            return JSAnyType.get((PsiElement)type.getSource().getScope(), false);
        }
        if (type instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)type, JSTypeUtils::isSingleGenericComponentType, true);
        }
        if (type instanceof JSRecordType && includeIndexers) {
            JSRecordType recordType = (JSRecordType)type;
            JSRecordType.IndexSignature indexer = recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
            if (indexer == null) {
                indexer = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
            }
            if (indexer != null) {
                return indexer.getMemberType();
            }
        }
        return null;
    }

    @Nullable
    public static JSType getSingleGenericArgTypeFromGenericType(@NotNull JSGenericTypeImpl genericType, @NotNull Predicate<? super JSType> acceptType, boolean traverseClassHierarchy) {
        JSType baseType;
        if (genericType == null) {
            JSTypeUtils.$$$reportNull$$$0(14);
        }
        if (acceptType == null) {
            JSTypeUtils.$$$reportNull$$$0(15);
        }
        if ((baseType = genericType.getType()) instanceof JSNamedType) {
            List<JSType> genericArguments = genericType.getArguments();
            if (genericArguments.isEmpty()) {
                return null;
            }
            if (acceptType.test((JSType)baseType)) {
                return genericArguments.size() == 1 || !baseType.isTypeScript() ? genericArguments.get(genericArguments.size() - 1) : null;
            }
            if (!traverseClassHierarchy) {
                return null;
            }
            if (!(baseType instanceof JSResolvableType)) {
                return null;
            }
            JSResolvedTypeInfo resolvedTypeInfo = ((JSResolvableType)baseType).resolveType();
            JSClass sourceElement = resolvedTypeInfo.getDeclarationOfType(JSClass.class);
            if (sourceElement == null) {
                return null;
            }
            Ref indexerType = new Ref(null);
            JSClassUtils.processClassesInHierarchy(sourceElement, true, (klass, subst, fromImplements) -> {
                JSType idx;
                List generics;
                if (acceptType == null) {
                    JSTypeUtils.$$$reportNull$$$0(154);
                }
                if (!(klass instanceof TypeScriptTypeParameterListOwner)) {
                    return true;
                }
                TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)klass).getTypeParameterList();
                if (list == null) {
                    return true;
                }
                List list2 = generics = klass == sourceElement ? genericArguments : ContainerUtil.newArrayList(TypeScriptGenericTypesEvaluator.buildGenericParameters(list.getTypeParameters()));
                if (generics.size() == 0) {
                    return true;
                }
                String qualifiedName = klass.getQualifiedName();
                if (qualifiedName == null) {
                    return true;
                }
                JSType type = JSNamedTypeFactory.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)klass, true), JSTypeContext.INSTANCE);
                type = new JSGenericTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)sourceElement, true), type, generics);
                if (!subst.isEmpty()) {
                    type = JSTypeUtils.applyGenericArguments(type, subst);
                }
                if ((idx = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)type, acceptType, false)) != null) {
                    idx = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(sourceElement, (List<? extends JSType>)genericArguments, sourceElement, idx);
                    indexerType.set((Object)idx);
                    return false;
                }
                return true;
            });
            if (!indexerType.isNull()) {
                return (JSType)indexerType.get();
            }
        }
        return null;
    }

    private static boolean isSingleGenericComponentType(@NotNull JSType baseType) {
        String s;
        if (baseType == null) {
            JSTypeUtils.$$$reportNull$$$0(16);
        }
        switch (s = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE)) {
            case "Vector": 
            case "Array": 
            case "Object": 
            case "ReadonlyArray": 
            case "ArrayLike": 
            case "Iterable": 
            case "AsyncIterable": 
            case "Iterator": 
            case "AsyncIterator": 
            case "IterableIterator": 
            case "AsyncIterableIterator": 
            case "Set": 
            case "WeakSet": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static JSType getIterableComponentType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(17);
        }
        return JSTypeUtils.getIterableComponentType(type, true, true);
    }

    @Nullable
    public static JSType getIterableComponentType(@NotNull JSType type, boolean allowAsyncIterable, boolean allowNonAsyncIterable) {
        JSType realType;
        JSType componentType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(18);
        }
        if ((componentType = JSTypeUtils.getIndexableComponentType(realType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type))) == null) {
            JSType genericType;
            JSRecordType recordType = realType.asRecordType();
            JSType jSType = genericType = allowNonAsyncIterable ? JSTypeUtils.getIteratorComponentType(recordType) : null;
            if (genericType != null) {
                return genericType;
            }
            JSType jSType2 = genericType = allowAsyncIterable ? JSTypeUtils.getAsyncIteratorComponentType(recordType) : null;
            if (genericType != null) {
                return genericType;
            }
        }
        return componentType;
    }

    @Nullable
    private static JSType getIteratorComponentType(JSRecordType recordType) {
        return JSTypeUtils.getCustomIteratorComponentType(recordType, "[Symbol.iterator]", "Iterator", "IterableIterator");
    }

    @Nullable
    private static JSType getAsyncIteratorComponentType(JSRecordType recordType) {
        return JSTypeUtils.getCustomIteratorComponentType(recordType, "[Symbol.asyncIterator]", "AsyncIterator", "AsyncIterableIterator");
    }

    @Nullable
    private static JSType getCustomIteratorComponentType(JSRecordType recordType, String iteratorSymbol, String iteratorClassName, String iterableIteratorClassName) {
        JSRecordType.PropertySignature propertySignature = recordType.findPropertySignature(iteratorSymbol);
        if (propertySignature == null) {
            return null;
        }
        JSType iteratorType = propertySignature.getType();
        if (iteratorType instanceof JSFunctionTypeImpl) {
            iteratorType = ((JSFunctionTypeImpl)iteratorType).getReturnType();
        }
        if (iteratorType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)iteratorType;
            String typeName = JSTypeUtils.getQualifiedNameMatchingType(iteratorType, false);
            if (iteratorClassName.equals(typeName) || iterableIteratorClassName.equals(typeName)) {
                return (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
            }
        }
        return null;
    }

    public static boolean typeCanBeAssignedWithoutCoercion(@NotNull JSType lOpType, @Nullable JSType rOpType) {
        if (lOpType == null) {
            JSTypeUtils.$$$reportNull$$$0(19);
        }
        if (lOpType instanceof JSNumberType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSNumberType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSIntType || lOpType instanceof JSUintType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSObjectType) {
            return true;
        }
        if (lOpType instanceof JSSpecialNamedTypeImpl || lOpType instanceof JSUndefinedType || lOpType instanceof JSNullType || lOpType instanceof JSVoidType) {
            return lOpType.isEquivalentTo(rOpType, null);
        }
        if (lOpType instanceof JSCompositeTypeImpl) {
            boolean anyTypeCanBeAssignedWithoutCoercion = false;
            for (JSType lOpTypePart : ((JSCompositeTypeImpl)lOpType).getTypes()) {
                anyTypeCanBeAssignedWithoutCoercion |= JSTypeUtils.typeCanBeAssignedWithoutCoercion(lOpTypePart, rOpType);
            }
            return anyTypeCanBeAssignedWithoutCoercion;
        }
        return rOpType != null && !(rOpType instanceof JSAnyType) && !(rOpType instanceof JSObjectType) && !(rOpType instanceof JSUndefinedType) && !(rOpType instanceof JSNullType) && !(rOpType instanceof JSVoidType);
    }

    @NotNull
    public static String getTypeMatchingNamespace(@NotNull String type) {
        JSType jsType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(20);
        }
        if ((jsType = JSTypeUtils.createType(type, JSTypeSource.EMPTY_TS)) == null) {
            String string = type;
            if (string == null) {
                JSTypeUtils.$$$reportNull$$$0(21);
            }
            return string;
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(jsType, false);
        String string = qName != null ? qName : type;
        if (string == null) {
            JSTypeUtils.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    public static String getQualifiedNameMatchingType(@NotNull JSType type, boolean resolved) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(23);
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSTypeWithOuterGenerics) {
            return JSTypeUtils.getQualifiedNameMatchingType(((JSTypeWithOuterGenerics)type).getOriginalType(), resolved);
        }
        if (type instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getQualifiedNameMatchingType(((JSGenericTypeImpl)type).getType(), resolved);
        }
        if (type instanceof JSArrayTypeImpl) {
            return "Array";
        }
        if (type instanceof JSNullType || type instanceof JSUndefinedType) {
            return null;
        }
        if (type instanceof JSStringType) {
            return "String";
        }
        if (type instanceof JSNumberType) {
            return "Number";
        }
        if (type instanceof JSBigIntType) {
            return "BigInt";
        }
        if (type instanceof JSBooleanType || type instanceof TypeScriptTypePredicateTypeImpl) {
            return "Boolean";
        }
        if (type instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
            if (constraintType == null) {
                return null;
            }
            return JSTypeUtils.getQualifiedNameMatchingType(constraintType, resolved);
        }
        if (type instanceof JSFunctionTypeImpl) {
            return JSTypeUtils.getFunctionTypeName(type.getSource().getScope(), false);
        }
        if (type instanceof JSTupleType) {
            return "Array";
        }
        if (type instanceof JSNamedType) {
            String text = type.getTypeText(resolved ? JSType.TypeTextFormat.RESOLVED : JSType.TypeTextFormat.SIMPLE);
            return StringUtil.replace((String)text, (String)"prototype.", (String)"");
        }
        return null;
    }

    @NotNull
    public static String getFunctionTypeName(@Nullable PsiFile scope, boolean newable) {
        TypeScriptConfig config2;
        TypeScriptConfig typeScriptConfig = config2 = scope == null ? null : TypeScriptConfigUtil.getConfigForPsiFile(scope);
        String string = config2 == null || !config2.strictBindCallApply() ? "Function" : (newable ? "NewableFunction" : "CallableFunction");
        if (string == null) {
            JSTypeUtils.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    public static JSNamespace getNamespaceMatchingType(@NotNull JSType type, boolean forcedExplicitlyDeclared) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(25);
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSGenericTypeImpl) {
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(((JSGenericTypeImpl)type).getType(), forcedExplicitlyDeclared);
            if (namespace != null) {
                JSTypeSubstitutor typeSubstitutor;
                PsiElement sourceElement = type.getSource().getSourceElement();
                JSQualifiedName name = namespace.getQualifiedName();
                if (sourceElement != null && name != null && !(typeSubstitutor = JSGenericTypesEvaluatorBase.findTypeArgumentsForClassInHierarchy(type, name, sourceElement)).isEmpty()) {
                    return new JSTypeWithOuterGenerics((JSType)namespace, typeSubstitutor);
                }
            }
            return namespace;
        }
        if (type instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
            if (constraintType == null) {
                return null;
            }
            return JSTypeUtils.getNamespaceMatchingType(constraintType, forcedExplicitlyDeclared);
        }
        if (type instanceof JSNamespace) {
            return (JSNamespace)(forcedExplicitlyDeclared ? type.copyWithStrict(true) : type);
        }
        return null;
    }

    @Nullable
    public static String getPresentableType(@Nullable JSType type, boolean resolved) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            return type.isEcma() || resolved ? "String" : "string";
        }
        return resolved ? type.getResolvedTypeText() : type.getTypeText();
    }

    public static boolean hasFunctionType(@NotNull JSType _type, boolean includeConstructorSignatures, @Nullable PsiElement context) {
        if (_type == null) {
            JSTypeUtils.$$$reportNull$$$0(26);
        }
        return JSTypeUtils.getFunctionType(_type, includeConstructorSignatures, context).findAny().isPresent();
    }

    @NotNull
    public static Stream<JSType> getFunctionType(@Nullable JSType _type, boolean includeConstructorSignatures, @Nullable PsiElement context) {
        if (_type == null) {
            Stream<JSType> stream = Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(27);
            }
            return stream;
        }
        Stream<JSType> stream = JSTypeUtils.getFunctionTypeImpl(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(_type), includeConstructorSignatures, context, null);
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(28);
        }
        return stream;
    }

    @NotNull
    private static Stream<JSType> getFunctionTypeImpl(@NotNull JSType expandedType, boolean constructorSignatures, @Nullable PsiElement context, @Nullable Collection<JSResolvedTypeId> visited) {
        JSType substitute;
        JSType type;
        if (expandedType == null) {
            JSTypeUtils.$$$reportNull$$$0(29);
        }
        if ((type = expandedType) instanceof JSFunctionTypeImpl || type instanceof JSPrimitiveFunctionType || JSTypeCastUtil.isAlwaysAssignableType(type, context)) {
            Stream<JSType> stream = Stream.of(type);
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(30);
            }
            return stream;
        }
        if (visited != null && !visited.add((JSResolvedTypeId)type.getResolvedTypeId())) {
            Stream<JSType> stream = Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(31);
            }
            return stream;
        }
        if (type instanceof JSArrayType) {
            Stream<JSType> stream = Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(32);
            }
            return stream;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            HashSet _visited = visited == null ? ContainerUtil.newHashSet() : ContainerUtil.newHashSet(visited);
            JSUnionOrIntersectionType compositeType = (JSUnionOrIntersectionType)type;
            boolean strict = TypeScriptConfigUtil.strictNullChecks(context);
            Stream<JSType> resultStream = compositeType.getTypes().stream().filter(el -> strict || !JSCompositeTypeBaseImpl.isNullOrUndefinedType(el)).filter(el -> el != null).flatMap(jsType -> JSTypeUtils.getFunctionTypeImpl(jsType, constructorSignatures, context, _visited));
            if (!JSTypeCastUtil.isStrictTypeScriptUnionType(compositeType) || compositeType instanceof JSIntersectionType && !constructorSignatures) {
                Stream<JSType> stream = resultStream;
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(33);
                }
                return stream;
            }
            List<JSType> types = resultStream.collect(Collectors.toList());
            if (types.size() <= 1 || !compositeType.getSource().isStrict()) {
                Stream<JSType> stream = types.stream();
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(34);
                }
                return stream;
            }
            if (compositeType instanceof JSIntersectionType) {
                Stream<JSType> stream = JSTypeUtils.mergeWithMixins(types);
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(35);
                }
                return stream;
            }
            JSType substitute2 = compositeType.substitute();
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            Stream<JSType> stream = substitute2 != compositeType ? JSTypeUtils.getFunctionTypeImpl(substitute2, constructorSignatures, context, (Collection<JSResolvedTypeId>)visited) : Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(36);
            }
            return stream;
        }
        if (type instanceof JSTypeImpl) {
            Collection<TypeScriptInterface> interfaces;
            JSTypeImpl typeImpl = (JSTypeImpl)type;
            JSTypeSource source = type.getSource();
            if (((JSTypeImpl)type).inheritsFunction()) {
                Stream<JSType> stream = Stream.of(type);
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(37);
                }
                return stream;
            }
            if (source.isJavaScript() && typeImpl.getTypeContext() != JSTypeContext.STATIC && (interfaces = JSTypeUtils.getTypeScriptInterfaceInJavaScriptContext(type)).size() > 0) {
                Stream<JSType> stream = interfaces.stream().flatMap(anInterface -> TypeScriptSignatureChooser.getCallSignatures(anInterface, constructorSignatures).stream()).map(function -> TypeScriptTypeParser.buildFunctionType(function.myFunctionItem));
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(38);
                }
                return stream;
            }
            JSType substitute3 = type.substitute();
            if (substitute3 != type) {
                Stream<JSType> typeStream;
                List types;
                if (visited == null) {
                    visited = ContainerUtil.newTroveSet();
                }
                if (!(types = (typeStream = JSTypeUtils.getFunctionTypeImpl(substitute3, constructorSignatures, context, (Collection<JSResolvedTypeId>)visited)).collect(Collectors.toList())).isEmpty() || !constructorSignatures) {
                    Stream<JSType> stream = types.stream();
                    if (stream == null) {
                        JSTypeUtils.$$$reportNull$$$0(39);
                    }
                    return stream;
                }
            }
            if (constructorSignatures) {
                Stream<JSType> stream = Stream.of(new JSFunctionTypeImpl(type.getSource(), ContainerUtil.emptyList(), JSNamedTypeFactory.createType(type.getTypeText(JSType.TypeTextFormat.PRESENTABLE), type.getSource(), JSContext.INSTANCE)));
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(40);
                }
                return stream;
            }
        } else {
            JSGenericParameterImpl genericParameter;
            JSType constraintType;
            if (type instanceof JSRecordType) {
                Stream<JSType> stream = ((JSRecordType)type).getCallSignatures().stream().filter(typeMember -> typeMember.hasNew() == constructorSignatures).map(typeMember -> typeMember.getFunctionType());
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(41);
                }
                return stream;
            }
            if (type instanceof JSGenericTypeImpl) {
                JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
                JSType substitute4 = genericType.substitute();
                if (substitute4 != genericType) {
                    Stream<JSType> typeStream;
                    List types;
                    if (visited == null) {
                        visited = ContainerUtil.newTroveSet();
                    }
                    if (!(types = (typeStream = JSTypeUtils.getFunctionTypeImpl(substitute4, constructorSignatures, context, (Collection<JSResolvedTypeId>)visited)).collect(Collectors.toList())).isEmpty()) {
                        Stream<JSType> stream = types.stream();
                        if (stream == null) {
                            JSTypeUtils.$$$reportNull$$$0(42);
                        }
                        return stream;
                    }
                }
                JSType innerType = genericType.getType();
                Stream<JSType> stream = JSTypeUtils.getFunctionTypeImpl(innerType, constructorSignatures, context, (Collection<JSResolvedTypeId>)visited).map(functionType -> {
                    JSType resultType;
                    if (genericType.getSource().isStrict() && !genericType.getSource().isTypeScript() && (resultType = JSTypeUtils.applyJSGenericsForType(genericType.getArguments(), innerType, genericType.getScope(), functionType)) != functionType) {
                        return resultType;
                    }
                    PsiElement sourceElement = functionType.getSource().getSourceElement();
                    if (functionType instanceof JSFunctionTypeImpl) {
                        TypeScriptTypeParameter[] tsSignatureTypeParameters;
                        if (sourceElement instanceof TypeScriptFunction && (tsSignatureTypeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement)).length > 0) {
                            JSTypeSubstitutor arguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(tsSignatureTypeParameters, genericType.getArguments());
                            return JSTypeUtils.applyGenericArguments(functionType, arguments);
                        }
                        JSType newType = JSTypeUtils.getNewOrReturnType(functionType, true);
                        return new JSFunctionTypeImpl(functionType.getSource(), ((JSFunctionTypeImpl)functionType).getParameters(), JSTypeUtils.wrapWithGenerics(newType, genericType));
                    }
                    return new JSGenericTypeImpl(genericType.getSource(), (JSType)functionType, genericType.getArguments());
                });
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(43);
                }
                return stream;
            }
            if (type instanceof JSGenericParameterImpl && (constraintType = (genericParameter = (JSGenericParameterImpl)type).getConstraintType()) != null) {
                Stream<JSType> stream = JSTypeUtils.getFunctionTypeImpl(constraintType, constructorSignatures, context, (Collection<JSResolvedTypeId>)visited);
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(44);
                }
                return stream;
            }
        }
        if ((substitute = type.substitute()) != type) {
            if (visited == null && !(substitute instanceof JSRecordType)) {
                visited = ContainerUtil.newTroveSet();
            }
            Stream<JSType> stream = JSTypeUtils.getFunctionTypeImpl(substitute, constructorSignatures, context, (Collection<JSResolvedTypeId>)visited);
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(45);
            }
            return stream;
        }
        if (type instanceof JSEvaluableType) {
            Stream<JSType> stream = Stream.of(type);
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(46);
            }
            return stream;
        }
        Stream<JSType> stream = Stream.empty();
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(47);
        }
        return stream;
    }

    @NotNull
    private static Stream<JSType> mergeWithMixins(@NotNull List<JSType> originalTypes) {
        if (originalTypes == null) {
            JSTypeUtils.$$$reportNull$$$0(48);
        }
        List functionTypes = ContainerUtil.newSmartList();
        List mixinReturnTypes = ContainerUtil.newSmartList();
        List nonFunctionTypes = ContainerUtil.newSmartList();
        for (JSType type : originalTypes) {
            if (type instanceof JSFunctionType) {
                JSFunctionType functionType = (JSFunctionType)type;
                if (ES6ReferenceListImpl.isMixinConstructor(functionType)) {
                    ContainerUtil.addIfNotNull((Collection)mixinReturnTypes, (Object)functionType.getReturnType());
                    continue;
                }
                functionTypes.add(functionType);
                continue;
            }
            nonFunctionTypes.add(type);
        }
        if (mixinReturnTypes.size() == 0 || functionTypes.size() == 0) {
            Stream<JSType> stream = originalTypes.stream();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(49);
            }
            return stream;
        }
        Stream<JSType> functionWithMixin = functionTypes.stream().map(el -> {
            JSType mixinType = JSIntersectionTypeImpl.getIntersectionType(mixinReturnTypes, el.getSource());
            JSType newReturnType = JSIntersectionTypeImpl.getIntersectionType(StreamEx.of((Object[])new JSType[]{mixinType, el.getReturnType()}).nonNull().toList(), el.getSource());
            return el.copyWithReturnType(newReturnType);
        });
        Stream<JSType> stream = Stream.concat(nonFunctionTypes.stream(), functionWithMixin);
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(50);
        }
        return stream;
    }

    @NotNull
    public static Collection<TypeScriptInterface> getTypeScriptInterfaceInJavaScriptContext(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(51);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (sourceElement == null || qName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeUtils.$$$reportNull$$$0(52);
            }
            return list;
        }
        JSTypeResolveResult result2 = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveTypeName(qName, sourceElement);
        List list = ContainerUtil.mapNotNull(result2.getElements(), TypeScriptUtil.TYPESCRIPT_INTERFACE_FILTER);
        if (list == null) {
            JSTypeUtils.$$$reportNull$$$0(53);
        }
        return list;
    }

    public static boolean hasAnyType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(54);
        }
        if (type instanceof JSAnyType) {
            return true;
        }
        if (type instanceof JSCompositeTypeImpl) {
            return JSTypeUtils.hasAnyType(((JSCompositeTypeImpl)type).getTypes());
        }
        if (type instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.hasAnyType(((JSTypeofTypeImpl)type).evaluateType());
        }
        return false;
    }

    public static boolean hasAnyType(@NotNull Collection<? extends JSType> types) {
        if (types == null) {
            JSTypeUtils.$$$reportNull$$$0(55);
        }
        for (JSType jSType : types) {
            if (!JSTypeUtils.hasAnyType(jSType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static JSType tryGetReturnType(@NotNull JSType functionType, @NotNull JSApplyCallElement applyCallElement) {
        if (functionType == null) {
            JSTypeUtils.$$$reportNull$$$0(56);
        }
        if (applyCallElement == null) {
            JSTypeUtils.$$$reportNull$$$0(57);
        }
        if (functionType instanceof JSFunctionTypeImpl && !(functionType instanceof TypeScriptJSFunctionTypeImpl)) {
            return ((JSFunctionTypeImpl)functionType).getReturnType();
        }
        JSExpression methodExpression = applyCallElement.getMethodExpression();
        if (methodExpression == null) {
            return null;
        }
        List<JSType> arguments = applyCallElement.getArgumentTypes((PsiElement)methodExpression);
        return JSTypeUtils.getReturnType(functionType, methodExpression, arguments, TypeScriptPsiUtil.getNestedTypeArguments(methodExpression.getParent()));
    }

    @Nullable
    public static JSType tryGetReturnType(@NotNull JSType functionType, @NotNull JSApplyInstanceContextElement applyInstanceContextElement) {
        JSNewExpression newExpression;
        if (functionType == null) {
            JSTypeUtils.$$$reportNull$$$0(58);
        }
        if (applyInstanceContextElement == null) {
            JSTypeUtils.$$$reportNull$$$0(59);
        }
        if ((newExpression = applyInstanceContextElement.getNewExpression()) == null) {
            return null;
        }
        return JSTypeUtils.getReturnType(functionType, (JSCallExpression)newExpression);
    }

    public static boolean hasTypeArguments(@NotNull JSCallExpression expression) {
        if (expression == null) {
            JSTypeUtils.$$$reportNull$$$0(60);
        }
        if (!(expression instanceof TypeScriptNewExpression)) {
            return false;
        }
        TypeScriptNewExpression newExpression = (TypeScriptNewExpression)expression;
        TypeScriptTypeArgumentList arguments = newExpression.getTypeArguments();
        return arguments != null && arguments.getTypeArguments().length > 0;
    }

    @Nullable
    private static JSType getReturnType(@NotNull JSType startFunction, @NotNull JSCallExpression callExpression) {
        JSExpression methodExpression;
        if (startFunction == null) {
            JSTypeUtils.$$$reportNull$$$0(61);
        }
        if (callExpression == null) {
            JSTypeUtils.$$$reportNull$$$0(62);
        }
        if ((methodExpression = callExpression.getMethodExpression()) == null) {
            return null;
        }
        return JSTypeUtils.getReturnType(startFunction, methodExpression, TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(callExpression.getArguments(), true), TypeScriptPsiUtil.getNestedTypeArguments((PsiElement)callExpression));
    }

    @Nullable
    private static JSType getReturnType(@NotNull JSType startFunction, @NotNull JSExpression methodExpression, @NotNull List<JSType> arguments, @NotNull JSTypeDeclaration[] callArguments) {
        if (startFunction == null) {
            JSTypeUtils.$$$reportNull$$$0(63);
        }
        if (methodExpression == null) {
            JSTypeUtils.$$$reportNull$$$0(64);
        }
        if (arguments == null) {
            JSTypeUtils.$$$reportNull$$$0(65);
        }
        if (callArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(66);
        }
        boolean includeConstructors = methodExpression.getParent() instanceof JSNewExpression;
        List<JSType> overloadTypes = JSTypeUtils.chooseOverloadFunctionTypes(startFunction, methodExpression, arguments, callArguments);
        JSType overloadType = (JSType)ContainerUtil.getFirstItem(overloadTypes);
        return overloadType == null ? null : JSTypeUtils.getNewOrReturnType(overloadType, includeConstructors);
    }

    @NotNull
    public static List<JSType> chooseOverloadFunctionTypes(@NotNull List<? extends JSType> candidates, @NotNull JSCallExpression callExpression) {
        if (candidates == null) {
            JSTypeUtils.$$$reportNull$$$0(67);
        }
        if (callExpression == null) {
            JSTypeUtils.$$$reportNull$$$0(68);
        }
        JSTypeDeclaration[] generics = TypeScriptPsiUtil.getNestedTypeArguments((PsiElement)callExpression);
        boolean includeConstructors = callExpression instanceof JSNewExpression;
        JSExpression[] arguments = callExpression.getArguments();
        List<JSType> providers = TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(arguments, true);
        List<JSType> list = JSTypeUtils.chooseOverloadFunctionTypes(candidates, callExpression.getMethodExpression(), providers, generics, includeConstructors, false);
        if (list == null) {
            JSTypeUtils.$$$reportNull$$$0(69);
        }
        return list;
    }

    @NotNull
    private static List<JSType> chooseOverloadFunctionTypes(@NotNull JSType startFunction, @NotNull JSExpression methodExpression, @NotNull List<JSType> arguments, @NotNull JSTypeDeclaration[] callArguments) {
        boolean includeConstructors;
        List candidates;
        if (startFunction == null) {
            JSTypeUtils.$$$reportNull$$$0(70);
        }
        if (methodExpression == null) {
            JSTypeUtils.$$$reportNull$$$0(71);
        }
        if (arguments == null) {
            JSTypeUtils.$$$reportNull$$$0(72);
        }
        if (callArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(73);
        }
        if ((candidates = JSTypeUtils.getFunctionType(startFunction, includeConstructors = methodExpression.getParent() instanceof JSNewExpression, (PsiElement)methodExpression).collect(Collectors.toList())).size() == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeUtils.$$$reportNull$$$0(74);
            }
            return list;
        }
        List<JSType> list = JSTypeUtils.chooseOverloadFunctionTypes(candidates, methodExpression, arguments, callArguments, includeConstructors, true);
        if (list == null) {
            JSTypeUtils.$$$reportNull$$$0(75);
        }
        return list;
    }

    @NotNull
    public static List<JSType> chooseOverloadFunctionTypes(@NotNull List<? extends JSType> candidates, @NotNull JSExpression methodExpression, @NotNull List<JSType> argumentProviders, @NotNull JSTypeDeclaration[] callTypeArguments, boolean includeConstructors, boolean applyGenerics) {
        if (candidates == null) {
            JSTypeUtils.$$$reportNull$$$0(76);
        }
        if (methodExpression == null) {
            JSTypeUtils.$$$reportNull$$$0(77);
        }
        if (argumentProviders == null) {
            JSTypeUtils.$$$reportNull$$$0(78);
        }
        if (callTypeArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(79);
        }
        List resultCandidates = ContainerUtil.newSmartList();
        OverloadPriority candidatePriority = OverloadPriority.UNKNOWN;
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCallEnvironment((PsiElement)methodExpression);
        for (JSType jSType : candidates) {
            OverloadPriority priority;
            if (!(jSType instanceof JSFunctionTypeImpl)) continue;
            JSFunctionTypeImpl type = (JSFunctionTypeImpl)jSType;
            JSTypeSource source = type.getSource();
            boolean typeScript = source.isTypeScript();
            PsiElement rawSourceElement = source.getSourceElement();
            if (includeConstructors && rawSourceElement instanceof JSFunction && ((JSFunction)rawSourceElement).isConstructor()) {
                JSClass jsClass = JSUtils.getMemberContainingClass(rawSourceElement);
                rawSourceElement = jsClass == null || jsClass instanceof TypeScriptInterface ? rawSourceElement : jsClass;
            }
            PsiElement sourceElement = rawSourceElement;
            JSFunctionTypeImpl result2 = type;
            TypeScriptTypeParameter[] tsTypeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement);
            List actualArguments = ContainerUtil.map(argumentProviders, el -> {
                if (methodExpression == null) {
                    JSTypeUtils.$$$reportNull$$$0(153);
                }
                return TypeScriptGenericTypesEvaluator.getExplicitTypeOrAnyIfTypeScript((PsiElement)methodExpression, TypeScriptSignatureChooser.mapContextualTypeForOverload(el, source.getSourceElement()));
            });
            List<JSParameterTypeDecorator> decorators = JSTypeUtils.getParameterTypeDecorators(actualArguments);
            if (tsTypeParameters.length > 0 && applyGenerics) {
                result2 = TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments(type, methodExpression, includeConstructors, callTypeArguments, sourceElement);
            }
            if ((priority = JSTypeUtils.checkOverload(type, decorators, actualArguments, callTypeArguments, tsTypeParameters, processingContext, typeScript)) == OverloadPriority.ASSIGNABLE_EXACT) {
                List<JSType> list = Collections.singletonList(result2);
                if (list == null) {
                    JSTypeUtils.$$$reportNull$$$0(80);
                }
                return list;
            }
            if (candidatePriority == priority && priority != OverloadPriority.ASSIGNABLE) {
                resultCandidates.add(result2);
                continue;
            }
            if (candidatePriority.ordinal() <= priority.ordinal()) continue;
            resultCandidates.clear();
            resultCandidates.add(result2);
            candidatePriority = priority;
        }
        List list = resultCandidates;
        if (list == null) {
            JSTypeUtils.$$$reportNull$$$0(81);
        }
        return list;
    }

    private static OverloadPriority checkOverload(@NotNull JSFunctionTypeImpl type, @NotNull List<JSParameterTypeDecorator> decorators, @NotNull List<JSType> actualArguments, @NotNull JSTypeDeclaration[] callTypeArguments, TypeScriptTypeParameter[] tsTypeParameters, @NotNull ProcessingContext processingContext, boolean typeScript) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(82);
        }
        if (decorators == null) {
            JSTypeUtils.$$$reportNull$$$0(83);
        }
        if (actualArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(84);
        }
        if (callTypeArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(85);
        }
        if (processingContext == null) {
            JSTypeUtils.$$$reportNull$$$0(86);
        }
        int argumentsLength = actualArguments.size();
        List<JSParameterTypeDecorator> parameters = type.getParameters();
        int min = TypeScriptSignatureChooser.getMinArgumentCount(parameters);
        int max = TypeScriptSignatureChooser.getMaxArgumentCount(parameters);
        if (min > argumentsLength || argumentsLength > max) {
            return OverloadPriority.INCORRECT_PARAMETERS_LENGTH;
        }
        if (callTypeArguments.length > tsTypeParameters.length) {
            return OverloadPriority.INCORRECT_GENERICS_LENGTH;
        }
        if (!JSTypeUtils.areArgumentsAssignable(type.getParameters(), decorators, processingContext, false, false, typeScript)) {
            return argumentsLength == parameters.size() ? OverloadPriority.NOT_ASSIGNABLE_SAME_PARAMETERS_LENGTH : OverloadPriority.NOT_ASSIGNABLE_PARAMETERS;
        }
        if (callTypeArguments.length == 0 || tsTypeParameters.length == callTypeArguments.length) {
            return OverloadPriority.ASSIGNABLE_EXACT;
        }
        return OverloadPriority.ASSIGNABLE;
    }

    private static JSType applyJSGenericsForType(List<JSType> generics, JSType type, PsiFile scope, JSType resultType) {
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(type.getResolvedTypeText(), scope);
        if (genericParameters != null && genericParameters.size() == generics.size()) {
            JSTypeSubstitutor map = new JSTypeSubstitutor(ContainerUtil.newHashMap(genericParameters, generics));
            resultType = JSTypeUtils.applyGenericArguments(resultType, map);
        }
        return resultType;
    }

    @Nullable
    private static JSType wrapWithGenerics(@Nullable JSType type, @Nullable JSGenericTypeImpl genericType) {
        if (genericType == null || type == null) {
            return type;
        }
        return new JSGenericTypeImpl(genericType.getSource(), type, genericType.getArguments());
    }

    @Nullable
    public static JSType getNewOrReturnType(@Nullable JSType rawType, boolean includeConstructors) {
        JSFunctionTypeImpl functionType = null;
        JSGenericTypeImpl genericType = null;
        if (rawType instanceof JSGenericTypeImpl) {
            genericType = (JSGenericTypeImpl)rawType;
            rawType = ((JSGenericTypeImpl)rawType).getType();
        }
        if (rawType instanceof JSFunctionTypeImpl) {
            functionType = (JSFunctionTypeImpl)rawType;
        }
        if (functionType == null) {
            return null;
        }
        if (!includeConstructors) {
            return JSTypeUtils.wrapWithGenerics(functionType.getReturnType(), genericType);
        }
        JSType type = functionType.getNewType();
        return JSTypeUtils.wrapWithGenerics(type == null ? functionType.getReturnType() : type, genericType);
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType getValuableType(@Nullable JSType type) {
        return JSTypeUtils.getValuableType(type, false, true);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType getValuableType(@Nullable JSType type, boolean completeSubstitution) {
        return JSTypeUtils.getValuableType(type, false, completeSubstitution);
    }

    @Contract(value="!null, _, _ -> !null")
    private static JSType getValuableType(@Nullable JSType type, boolean typedefExpanded, boolean completeSubstitution) {
        return JSTypeUtils.getValuableType(type, typedefExpanded, completeSubstitution, true);
    }

    @Nullable
    @Contract(value="!null, _, _,_ -> !null")
    public static JSType getValuableType(@Nullable JSType type, boolean typedefExpanded, boolean completeSubstitution, boolean expandDecorators) {
        if (type == null) {
            return null;
        }
        JSTypeSource source = type.getSource();
        JSType jSType = type = expandDecorators ? JSTypeUtils.unwrapDecorations(type) : type;
        if (type instanceof JSTypeImpl && !typedefExpanded) {
            JSType typedefValue;
            if (source.isStrict() && source.getLanguage() == JSTypeSource.SourceLanguage.JS && (typedefValue = ((JSTypeImpl)type).getJSTypedef()) != null) {
                return JSTypeUtils.getValuableType(typedefValue, true, completeSubstitution, expandDecorators);
            }
        } else if (type instanceof JSEvaluableType) {
            JSType substitute;
            JSType jSType2 = substitute = completeSubstitution ? JSTypeWithIncompleteSubstitution.substituteCompletely((JSType)type) : type.substitute();
            if (substitute != type) {
                return JSTypeUtils.getValuableType(substitute, typedefExpanded, completeSubstitution, expandDecorators);
            }
        }
        return type;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType unwrapDecorations(@Nullable JSType type) {
        if (type instanceof JSDecoratedTypeImpl) {
            return ((JSDecoratedTypeImpl)type).getType();
        }
        return type;
    }

    public static boolean canBeCalledWithArguments(@Nullable JSType functionType, List<? extends JSType> arguments, boolean inNewExpression, @NotNull ProcessingContext context) {
        if (context == null) {
            JSTypeUtils.$$$reportNull$$$0(87);
        }
        JSTypeComparingContextService.setCallEnvironment(context, true);
        return JSTypeUtils.canBeCalledWithArguments(functionType, arguments, inNewExpression, context, null);
    }

    private static boolean canBeCalledWithArguments(@Nullable JSType functionType, List<? extends JSType> arguments, boolean inNewExpression, @NotNull ProcessingContext processingContext, @Nullable Set<? super JSResolvedTypeId> visited) {
        JSType substitute;
        if (processingContext == null) {
            JSTypeUtils.$$$reportNull$$$0(88);
        }
        if (functionType == null || functionType instanceof JSAnyType || functionType instanceof JSPrimitiveFunctionType || functionType instanceof JSNullType && functionType.isTypeScript()) {
            return true;
        }
        if (visited != null && !JSTypeUtils.checkTypeForVisited(functionType, visited)) {
            return true;
        }
        if (functionType instanceof JSFunctionTypeImpl) {
            boolean typescript = functionType.isTypeScript();
            return JSTypeUtils.areArgumentsAssignable(((JSFunctionTypeImpl)functionType).getParameters(), JSTypeUtils.getParameterTypeDecorators(arguments), processingContext, false, false, typescript);
        }
        if (functionType instanceof JSCompositeTypeImpl) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            for (JSType type : ((JSCompositeTypeImpl)functionType).getTypes()) {
                if (!JSTypeUtils.canBeCalledWithArguments(type, arguments, inNewExpression, processingContext, visited)) continue;
                return true;
            }
        } else if (functionType instanceof JSRecordType) {
            for (JSRecordType.CallSignature typeMember : ((JSRecordType)functionType).getCallSignatures()) {
                if (typeMember.hasNew() != inNewExpression || !JSTypeUtils.canBeCalledWithArguments((JSType)typeMember.getFunctionType(), arguments, inNewExpression, processingContext, visited)) continue;
                return true;
            }
        }
        if ((substitute = functionType.substitute()) != functionType) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            return JSTypeUtils.canBeCalledWithArguments(substitute, arguments, inNewExpression, processingContext, visited);
        }
        return false;
    }

    private static boolean checkTypeForVisited(@NotNull JSType type, @NotNull Collection<? super JSResolvedTypeId> visited) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(89);
        }
        if (visited == null) {
            JSTypeUtils.$$$reportNull$$$0(90);
        }
        return visited.add((JSResolvedTypeId)type.getResolvedTypeId());
    }

    @Deprecated
    @Contract(value="!null -> !null")
    public static JSType resolveType(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) != null && type.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS) {
            return type.substitute();
        }
        return type;
    }

    public static boolean areArgumentsAssignable(@NotNull List<JSParameterTypeDecorator> parameters, @Nullable List<JSParameterTypeDecorator> arguments, @Nullable ProcessingContext processingContext, boolean functionAssignment, boolean jsDocFunctionAssignment, boolean typescript) {
        if (parameters == null) {
            JSTypeUtils.$$$reportNull$$$0(91);
        }
        if (arguments == null) {
            return parameters.isEmpty();
        }
        arguments = JSTypeUtils.spreadArguments(arguments);
        if (typescript && !functionAssignment) {
            int min = TypeScriptSignatureChooser.getMinArgumentCount(parameters);
            int max = TypeScriptSignatureChooser.getMaxArgumentCount(parameters);
            int argumentSize = arguments.size();
            if (min > argumentSize || argumentSize > max) {
                return false;
            }
        }
        Iterator<JSParameterTypeDecorator> paramIterator = parameters.iterator();
        Iterator<JSParameterTypeDecorator> argIterator = arguments.iterator();
        Ref paramRestType = null;
        Ref argRestType = null;
        boolean remainingArgumentsAreOptional = false;
        boolean remainingParametersAreOptional = false;
        int paramIndex = -1;
        int argIndex = -1;
        while (paramIterator.hasNext() || argIterator.hasNext()) {
            int tupleOffset;
            JSType restTuple;
            JSType argument;
            boolean isParameterRest;
            JSType parameter;
            JSParameterTypeDecorator parameterTypeDecorator = null;
            boolean hasParameter = true;
            if (paramIterator.hasNext()) {
                parameterTypeDecorator = paramIterator.next();
                ++paramIndex;
                parameter = parameterTypeDecorator.getType();
            } else if (paramRestType != null) {
                parameter = (JSType)paramRestType.get();
            } else {
                parameter = null;
                hasParameter = false;
            }
            boolean bl = isParameterRest = parameterTypeDecorator != null && parameterTypeDecorator.isRest();
            if (isParameterRest) {
                paramRestType = Ref.create((Object)parameter);
                remainingParametersAreOptional = true;
            }
            if (parameterTypeDecorator != null && parameterTypeDecorator.isOptional()) {
                remainingParametersAreOptional = true;
            }
            JSParameterTypeDecorator argumentTypeDecorator = null;
            boolean hasArgument = true;
            if (argIterator.hasNext()) {
                argumentTypeDecorator = argIterator.next();
                argument = JSTypeUtils.getArgumentType(argumentTypeDecorator, isParameterRest);
                ++argIndex;
            } else if (argRestType != null) {
                argument = (JSType)argRestType.get();
            } else {
                hasArgument = false;
                argument = null;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isRest()) {
                argRestType = Ref.create((Object)argument);
                remainingArgumentsAreOptional = true;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isOptional()) {
                remainingArgumentsAreOptional = true;
            }
            if (!hasParameter) {
                return functionAssignment && !typescript || remainingArgumentsAreOptional;
            }
            if (!hasArgument) {
                return remainingParametersAreOptional || functionAssignment && typescript;
            }
            if (parameter instanceof JSTupleType && JSTypeUtils.checkTuple(processingContext, (restTuple = argRestType == null ? null : (JSType)argRestType.get()) instanceof JSTupleType ? (JSTupleType)restTuple : null, (JSTupleType)parameter, argument, tupleOffset = argIndex - paramIndex) || JSTypeUtils.matchRestTuples(processingContext, argIterator, argRestType != null, paramRestType == null ? null : (JSType)paramRestType.get(), -argIndex + paramIndex, parameterTypeDecorator, parameter, argumentTypeDecorator, argument) || JSTypeUtils.isAssignableType(parameter, argument, processingContext) || functionAssignment && !jsDocFunctionAssignment && JSTypeUtils.isAssignableType(argument, parameter, processingContext)) continue;
            return false;
        }
        return typescript || !functionAssignment || remainingParametersAreOptional || paramRestType != null || !remainingArgumentsAreOptional && (!jsDocFunctionAssignment || argRestType == null);
    }

    @Nullable
    private static JSType getArgumentType(@NotNull JSParameterTypeDecorator argumentTypeDecorator, boolean isParameterRest) {
        JSType argument;
        if (argumentTypeDecorator == null) {
            JSTypeUtils.$$$reportNull$$$0(92);
        }
        if ((argument = argumentTypeDecorator.getType()) instanceof JSSimpleRecordTypeImpl && argument.getSourceElement() instanceof JSDestructuringObject) {
            Collection<JSRecordType.PropertySignature> properties = ((JSSimpleRecordTypeImpl)argument).getProperties();
            StreamEx newProperties = StreamEx.of(properties).map(el -> new JSRecordTypeImpl.PropertySignatureImpl(el.getMemberName(), el.getType(), true, el.getMemberSource()));
            return new JSSimpleRecordTypeImpl(argument.getSource(), newProperties.toList());
        }
        if (argument instanceof JSSpreadType && isParameterRest) {
            argument = ((JSSpreadType)argument).getComponentType();
        }
        return argument;
    }

    private static boolean checkTuple(@Nullable ProcessingContext processingContext, @Nullable JSTupleType argRestType, @NotNull JSTupleType parameter, @Nullable JSType argument, int tupleOffset) {
        if (parameter == null) {
            JSTypeUtils.$$$reportNull$$$0(93);
        }
        if (parameter.hasTypeByIndex(tupleOffset) && JSTypeUtils.isAssignableType(parameter.getTypeByIndex(tupleOffset), argument, processingContext)) {
            return true;
        }
        if (argRestType != null) {
            int offset = -1;
            boolean fail = false;
            for (JSType type : argRestType.getTypes()) {
                ++offset;
                if (type instanceof JSSpreadType) {
                    type = ((JSSpreadType)type).getComponentType();
                }
                if (parameter.hasTypeByIndex(tupleOffset + offset) && JSTypeUtils.isAssignableType(parameter.getTypeByIndex(tupleOffset + offset), type, processingContext)) continue;
                fail = true;
                break;
            }
            if (!fail) {
                return true;
            }
        }
        return false;
    }

    private static boolean matchRestTuples(@Nullable ProcessingContext processingContext, @NotNull Iterator<? extends JSParameterTypeDecorator> argIterator, boolean argIsRest, @Nullable JSType paramRestType, int tupleOffset, @Nullable JSParameterTypeDecorator parameterTypeDecorator, @Nullable JSType parameter, @Nullable JSParameterTypeDecorator argumentTypeDecorator, @Nullable JSType argument) {
        if (argIterator == null) {
            JSTypeUtils.$$$reportNull$$$0(94);
        }
        if (parameterTypeDecorator == null) {
            return false;
        }
        if (!parameterTypeDecorator.isRest()) {
            if (argIsRest && argument instanceof JSTupleType && ((JSTupleType)argument).hasTypeByIndex(tupleOffset)) {
                return JSTypeUtils.isAssignableType(parameter, ((JSTupleType)argument).getTypeByIndex(tupleOffset), processingContext);
            }
            return false;
        }
        if (!(parameter instanceof JSGenericParameterImpl)) {
            if (argIsRest && argument instanceof JSTupleType && paramRestType != null) {
                return JSTypeUtils.checkTuple(processingContext, paramRestType instanceof JSTupleType ? (JSTupleType)paramRestType : null, (JSTupleType)argument, paramRestType, tupleOffset);
            }
            return false;
        }
        JSType constraintType = ((JSGenericParameterImpl)parameter).getConstraintType();
        if (constraintType == null || !JSTypeUtils.isIterableCollectionType(constraintType)) {
            return false;
        }
        ArrayList argumentTypes = ContainerUtil.newArrayList();
        if (argIsRest && argument instanceof JSTupleType) {
            if (((JSTupleType)argument).hasTypeByIndex(tupleOffset)) {
                argumentTypes.add(((JSTupleType)argument).getTypeByIndex(tupleOffset));
            }
        } else {
            argumentTypes.add(argument);
        }
        int firstOptional = argumentTypeDecorator != null && argumentTypeDecorator.isOptional() ? 0 : -1;
        int i = -1;
        while (argIterator.hasNext()) {
            JSType type;
            ++i;
            JSParameterTypeDecorator nextDecorator = argIterator.next();
            if (nextDecorator == null) continue;
            if (firstOptional == -1 && nextDecorator.isOptional()) {
                firstOptional = i;
            }
            argumentTypes.add((type = nextDecorator.getTypeWithOptional()) != null && nextDecorator.isRest() ? new JSSpreadTypeImpl(type.getSource(), type) : type);
        }
        return JSTypeUtils.isAssignableType(parameter, new JSTupleTypeImpl(parameter.getSource(), argumentTypes, true, firstOptional), processingContext);
    }

    @NotNull
    private static List<JSParameterTypeDecorator> spreadArguments(@NotNull List<JSParameterTypeDecorator> arguments) {
        JSParameterTypeDecorator lastItem;
        if (arguments == null) {
            JSTypeUtils.$$$reportNull$$$0(95);
        }
        if ((lastItem = (JSParameterTypeDecorator)ContainerUtil.getLastItem(arguments)) == null) {
            List<JSParameterTypeDecorator> list = arguments;
            if (list == null) {
                JSTypeUtils.$$$reportNull$$$0(96);
            }
            return list;
        }
        JSType type = lastItem.getType();
        if (!(type instanceof JSSpreadType)) {
            List<JSParameterTypeDecorator> list = arguments;
            if (list == null) {
                JSTypeUtils.$$$reportNull$$$0(97);
            }
            return list;
        }
        JSType innerType = ((JSSpreadType)type).getInnerType();
        if (!(innerType instanceof JSTupleType)) {
            List<JSParameterTypeDecorator> list = arguments;
            if (list == null) {
                JSTypeUtils.$$$reportNull$$$0(98);
            }
            return list;
        }
        ArrayList expanded = ContainerUtil.newArrayListWithCapacity((int)arguments.size());
        expanded.addAll(arguments);
        expanded.remove(expanded.size() - 1);
        int maxLength = ((JSTupleType)innerType).getMaxLength();
        if (maxLength != Integer.MAX_VALUE) {
            for (int i = 0; i < maxLength; ++i) {
                expanded.add(new JSParameterTypeDecoratorImpl(((JSTupleType)innerType).getTypeByIndex(i), i >= ((JSTupleType)innerType).getOptionalStart(), false, false));
            }
        } else {
            List types = ((JSTupleType)innerType).getTypes();
            for (int i = 0; i < types.size(); ++i) {
                JSType jsType = (JSType)types.get(i);
                expanded.add(new JSParameterTypeDecoratorImpl(jsType instanceof JSSpreadType ? ((JSSpreadType)jsType).getComponentType() : jsType, false, i == types.size() - 1, false));
            }
        }
        ArrayList arrayList = expanded;
        if (arrayList == null) {
            JSTypeUtils.$$$reportNull$$$0(99);
        }
        return arrayList;
    }

    @Contract(value="!null,_,_,_->!null")
    public static JSType applyGenericArguments(@Nullable JSType _type, final @Nullable JSTypeSubstitutor typeArguments, boolean call, final @Nullable JSGenericTypesEvaluator.GenericErrorReporter report) {
        if (_type == null || typeArguments == null || typeArguments.isEmpty()) {
            return _type;
        }
        PsiElement element = _type.getSource().getSourceElement();
        final ProcessingContext context = JSTypeComparingContextService.setCallEnvironment(JSTypeComparingContextService.getProcessingContextWithCache(element), call);
        return _type.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSRecursiveExpandTransformer(true){

            @Override
            @NotNull
            protected JSType processExpanded(@NotNull JSType type) {
                JSTypeWithOuterGenerics remappedType;
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type instanceof JSGenericTypeImpl) {
                    boolean applyForArguments = this.shouldApplyForArguments(type);
                    JSType jSType = applyForArguments ? type : JSTypeBaseImpl.getSelfNoTransformationType();
                    if (jSType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return jSType;
                }
                if (type instanceof JSTypeWithOuterGenerics && (remappedType = JSTypeUtils.concatGenericsToJSGenericTypeIfNestedLocal((JSTypeWithOuterGenerics)type, typeArguments)) != null) {
                    JSType nestedType = JSTypeUtils.applyCompositeMapping(remappedType.getType(), (Function<JSType, JSType>)this);
                    JSTypeWithOuterGenerics jSTypeWithOuterGenerics = new JSTypeWithOuterGenerics(nestedType, remappedType.getOuterArguments(), remappedType.getSource());
                    if (jSTypeWithOuterGenerics == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return jSTypeWithOuterGenerics;
                }
                if (type instanceof TypeScriptGenericThisTypeImpl && typeArguments.containsId((JSTypeSubstitutor.JSTypeGenericId)((TypeScriptGenericThisTypeImpl)type).getGenericId())) {
                    JSType substitutionType = typeArguments.get((JSTypeSubstitutor.JSTypeGenericId)((TypeScriptGenericThisTypeImpl)type).getGenericId());
                    boolean useSelf = substitutionType == null || substitutionType instanceof TypeScriptGenericThisTypeImpl && type.getResolvedTypeId().equals(substitutionType.getResolvedTypeId());
                    JSType jSType = useSelf ? JSTypeBaseImpl.getSelfNoTransformationType() : substitutionType;
                    if (jSType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return jSType;
                }
                boolean isTypeImpl = type instanceof JSTypeImpl;
                if (isTypeImpl || type instanceof JSGenericParameterImpl) {
                    JSResolvedTypeInfo resolvedType;
                    JSType jsType;
                    JSType jSType = isTypeImpl && type.isTypeScript() ? null : (jsType = typeArguments.get((JSTypeSubstitutor.JSTypeGenericId)(isTypeImpl ? new JSTypeSubstitutor.StringGenericId(type.getTypeText()) : ((JSGenericParameterImpl)type).getGenericId())));
                    if (jsType instanceof JSTypeofTypeImpl) {
                        jsType = ((JSTypeofTypeImpl)jsType).evaluateType();
                    }
                    if (jsType != null) {
                        if (isTypeImpl && jsType.isTypeScript()) {
                            JSType jSType2 = type;
                            if (jSType2 == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            return jSType2;
                        }
                        if (type instanceof JSGenericParameterImpl) {
                            JSType afterProcess = this.processGenericParameter((JSGenericParameterImpl)type, jsType);
                            JSType jSType3 = afterProcess == type ? JSTypeBaseImpl.getSelfNoTransformationType() : afterProcess;
                            if (jSType3 == null) {
                                1.$$$reportNull$$$0(5);
                            }
                            return jSType3;
                        }
                        JSType jSType4 = jsType == type ? JSTypeBaseImpl.getSelfNoTransformationType() : jsType;
                        if (jSType4 == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        return jSType4;
                    }
                    if (type instanceof JSResolvableType && (resolvedType = ((JSResolvableType)type).resolveType()).isLocal()) {
                        JSTypeWithOuterGenerics jSTypeWithOuterGenerics = new JSTypeWithOuterGenerics(type, typeArguments);
                        if (jSTypeWithOuterGenerics == null) {
                            1.$$$reportNull$$$0(7);
                        }
                        return jSTypeWithOuterGenerics;
                    }
                }
                JSType jSType = type;
                if (jSType == null) {
                    1.$$$reportNull$$$0(8);
                }
                return jSType;
            }

            @NotNull
            private JSType processGenericParameter(@NotNull JSGenericParameterImpl currentType, @NotNull JSType replacement) {
                JSType newConstraint;
                if (currentType == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (replacement == null) {
                    1.$$$reportNull$$$0(10);
                }
                JSType oldConstraint = currentType.getConstraintType();
                if (report != null && oldConstraint != null && !(newConstraint = JSTypeUtils.applyCompositeMapping(oldConstraint, (Function<JSType, JSType>)this)).isDirectlyAssignableType(replacement, context)) {
                    PsiElement sourceElement = currentType.getSource().getSourceElement();
                    TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{TypeScriptPropertySignature.class});
                    if (propertySignature == null || !propertySignature.isOptional()) {
                        report.error("typescript.validation.cannot.find.best.common.type");
                    }
                    JSType jSType = newConstraint;
                    if (jSType == null) {
                        1.$$$reportNull$$$0(11);
                    }
                    return jSType;
                }
                JSType jSType = replacement instanceof JSGenericParameterImpl && replacement != currentType && replacement.getResolvedTypeId().equals(currentType.getResolvedTypeId()) ? currentType : replacement;
                if (jSType == null) {
                    1.$$$reportNull$$$0(12);
                }
                return jSType;
            }

            public boolean shouldApplyForArguments(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(13);
                }
                JSResolvedTypeId ownId = type.getResolvedTypeId();
                return typeArguments.types().stream().noneMatch(subst -> subst != null && Objects.equals(ownId, subst.getResolvedTypeId()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils$1";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentType";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "replacement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processExpanded";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processGenericParameter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processExpanded";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "processGenericParameter";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldApplyForArguments";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Nullable
    private static JSTypeWithOuterGenerics concatGenericsToJSGenericTypeIfNestedLocal(@NotNull JSTypeWithOuterGenerics genericType, @NotNull JSTypeSubstitutor typeArguments) {
        JSType jsType;
        JSResolvedTypeInfo resolvedType;
        JSType innerType;
        if (genericType == null) {
            JSTypeUtils.$$$reportNull$$$0(100);
        }
        if (typeArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(101);
        }
        if ((innerType = genericType.getType()) instanceof JSResolvableType && (resolvedType = ((JSResolvableType)innerType).resolveType()).isLocal() && (jsType = typeArguments.getForJSGenerics(innerType.getTypeText())) == null) {
            JSTypeSubstitutor newOuterArguments = typeArguments;
            JSTypeSubstitutor outerArguments = genericType.getOuterArguments();
            if (!outerArguments.isEmpty()) {
                newOuterArguments = JSTypeSubstitutor.combine((JSTypeSubstitutor)newOuterArguments, (JSTypeSubstitutor)outerArguments);
            }
            return new JSTypeWithOuterGenerics(innerType, newOuterArguments);
        }
        return null;
    }

    public static JSType applyGenericArguments(@NotNull JSType _type, @Nullable JSTypeSubstitutor typeArguments, @Nullable JSGenericTypesEvaluator.GenericErrorReporter report) {
        if (_type == null) {
            JSTypeUtils.$$$reportNull$$$0(102);
        }
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, false, report);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyGenericArguments(@Nullable JSType _type, @Nullable JSTypeSubstitutor typeArguments) {
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, false, null);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType addJSGenericParameters(@Nullable JSType _type, @NotNull Set<String> genericParameters) {
        if (genericParameters == null) {
            JSTypeUtils.$$$reportNull$$$0(103);
        }
        if (_type == null || genericParameters.isEmpty()) {
            return _type;
        }
        return JSTypeUtils.applyCompositeMapping(_type, (Function<JSType, JSType>)((Function)type -> {
            if (genericParameters == null) {
                JSTypeUtils.$$$reportNull$$$0(152);
            }
            if (type instanceof JSTypeImpl && genericParameters.contains(type.getTypeText())) {
                JSTypeBaseImpl result2 = new JSGenericParameterImpl(type.getTypeText(), type.getSource());
                if (((JSTypeImpl)type).getJSContext() == JSContext.STATIC) {
                    result2 = new JSApplyTypeofType(result2, result2.getSource());
                }
                return result2;
            }
            return type;
        }));
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyCompositeMapping(@Nullable JSType type, @NotNull Function<JSType, JSType> f) {
        if (f == null) {
            JSTypeUtils.$$$reportNull$$$0(104);
        }
        return JSTypeUtils.transformTypeHierarchySafe(type, f);
    }

    public static boolean hasForeignGenericParameter(@Nullable JSType startType) {
        if (startType == null) {
            return false;
        }
        if (startType instanceof JSGenericParameterImpl) {
            return true;
        }
        final Ref result2 = Ref.create((Object)Boolean.FALSE);
        final HashSet ignoredNames = ContainerUtil.newHashSet();
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor(false){

            public void visitJSType(@NotNull JSType currentType) {
                boolean hasNewIgnored;
                if (currentType == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (currentType instanceof JSGenericParameterImpl && !ignoredNames.contains(((JSGenericParameterImpl)currentType).getName())) {
                    result2.set((Object)Boolean.TRUE);
                    return;
                }
                Collection<String> currentIgnoredNames = null;
                if (currentType instanceof TypeScriptMappedJSTypeImpl) {
                    String name = ((TypeScriptMappedJSTypeImpl)currentType).getParameterName();
                    if (name != null && !ignoredNames.contains(name)) {
                        currentIgnoredNames = Collections.singleton(name);
                    }
                } else if (currentType instanceof TypeScriptConditionalTypeJSTypeImpl) {
                    currentIgnoredNames = (Collection)((StreamEx)StreamEx.of(((TypeScriptConditionalTypeJSTypeImpl)currentType).getOwnGenericParameters()).map(el -> el.getName()).filter(el -> !ignoredNames.contains(el))).collect(Collectors.toSet());
                } else if (currentType instanceof TypeScriptJSFunctionTypeImpl) {
                    currentIgnoredNames = (Collection)((StreamEx)StreamEx.of(((TypeScriptJSFunctionTypeImpl)currentType).getGenericDeclarations()).map(el -> el.getName()).filter(el -> !ignoredNames.contains(el))).collect(Collectors.toList());
                }
                boolean bl = hasNewIgnored = currentIgnoredNames != null && !currentIgnoredNames.isEmpty();
                if (hasNewIgnored) {
                    ignoredNames.addAll(currentIgnoredNames);
                }
                super.visitJSType(currentType);
                if (hasNewIgnored) {
                    ignoredNames.removeAll(currentIgnoredNames);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentType", "com/intellij/lang/javascript/psi/JSTypeUtils$2", "visitJSType"));
            }
        };
        visitor.visitJSType(startType);
        return (Boolean)result2.get();
    }

    public static boolean hasTypes(@Nullable JSType type, Class<?> ... typeClasses) {
        if (typeClasses == null) {
            JSTypeUtils.$$$reportNull$$$0(105);
        }
        return JSTypeUtils.hasTypes(type, false, typeClasses);
    }

    public static boolean hasTypes(@Nullable JSType type, boolean expandTypeOfType, Class<?> ... typeClasses) {
        if (typeClasses == null) {
            JSTypeUtils.$$$reportNull$$$0(106);
        }
        return JSTypeUtils.hasTypes(type, expandTypeOfType, (Condition<? super JSType>)((Condition)t -> {
            if (typeClasses == null) {
                JSTypeUtils.$$$reportNull$$$0(151);
            }
            for (Class typeClass : typeClasses) {
                if (!typeClass.isInstance(t)) continue;
                return true;
            }
            return false;
        }));
    }

    public static boolean hasTypes(@Nullable JSType type, final boolean expandTypeOfType, final @NotNull Condition<? super JSType> condition) {
        if (condition == null) {
            JSTypeUtils.$$$reportNull$$$0(107);
        }
        if (type == null) {
            return false;
        }
        if (condition.value((Object)type)) {
            return true;
        }
        final Ref result2 = Ref.create((Object)Boolean.FALSE);
        type.acceptChildren(new JSRecursiveTypeVisitor(expandTypeOfType){

            public void visitJSType(@NotNull JSType typeToVisit) {
                if (typeToVisit == null) {
                    3.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (condition.value((Object)typeToVisit)) {
                    result2.set((Object)Boolean.TRUE);
                    return;
                }
                if (expandTypeOfType && typeToVisit instanceof JSTypeofTypeImpl) {
                    ((JSTypeofTypeImpl)typeToVisit).evaluateType().accept((JSRecursiveTypeVisitor)this);
                    return;
                }
                super.visitJSType(typeToVisit);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeToVisit", "com/intellij/lang/javascript/psi/JSTypeUtils$3", "visitJSType"));
            }
        });
        return (Boolean)result2.get();
    }

    public static boolean hasThisGenericType(@Nullable JSType type) {
        return JSTypeUtils.hasTypes(type, true, TypeScriptGenericThisTypeImpl.class);
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithStrictRecursive(@Nullable JSType type, final boolean strict) {
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy((Function)new Function<JSType, JSType>(){

            public JSType fun(@Nullable JSType type) {
                if (type == null || type.getSource().isStrict() == strict) {
                    return type;
                }
                JSType newType = JSTypeUtils.copyWithStrict(type, strict);
                if (newType != type) {
                    return newType.transformTypeHierarchy((Function)this);
                }
                return type;
            }
        });
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithStrict(@Nullable JSType type, boolean strict) {
        if (type == null) {
            return null;
        }
        return type.copyWithStrict(strict);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static JSType copyWithLanguageOfContext(@Nullable JSType jsType, @NotNull PsiElement context) {
        if (context == null) {
            JSTypeUtils.$$$reportNull$$$0(108);
        }
        return JSTypeUtils.copyWithLanguageRecursive(jsType, JSTypeSourceFactory.getSourceLanguage(context));
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static JSType copyWithLanguageRecursive(@Nullable JSType jsType, @NotNull JSTypeSource.SourceLanguage language) {
        if (language == null) {
            JSTypeUtils.$$$reportNull$$$0(109);
        }
        return JSTypeBaseImpl.copyWithLanguageRecursive(jsType, language);
    }

    @NotNull
    public static List<JSType> addPossibleOption(@NotNull Collection<? extends JSType> types, @NotNull JSType newOption) {
        if (types == null) {
            JSTypeUtils.$$$reportNull$$$0(110);
        }
        if (newOption == null) {
            JSTypeUtils.$$$reportNull$$$0(111);
        }
        boolean hasAnyType = false;
        int typesCount = 0;
        for (JSType jSType : types) {
            ++typesCount;
            if (!(jSType instanceof JSAnyType)) continue;
            hasAnyType = true;
        }
        JSTypeSource optionSource = newOption.getSource();
        List<JSType> list = newOption instanceof JSCompositeTypeImpl && !optionSource.isStrict() ? ((JSCompositeTypeImpl)newOption).getTypes() : Collections.singletonList(newOption);
        SmartList result2 = new SmartList();
        if (types.isEmpty()) {
            result2.addAll(list);
            SmartList smartList = result2;
            if (smartList == null) {
                JSTypeUtils.$$$reportNull$$$0(112);
            }
            return smartList;
        }
        for (JSType typeToAdd : list) {
            boolean alreadyPresent = false;
            for (JSType jSType : types) {
                if (!typeToAdd.isEquivalentTo(jSType, null, false)) continue;
                alreadyPresent = true;
                break;
            }
            if (alreadyPresent) continue;
            if (!newOption.isTypeScript() && typesCount > 5) {
                if (hasAnyType) continue;
                result2.add(JSAnyType.get((PsiElement)optionSource.getScope(), false));
                ++typesCount;
                continue;
            }
            result2.add(typeToAdd);
            ++typesCount;
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSTypeUtils.$$$reportNull$$$0(113);
        }
        return smartList;
    }

    public static boolean processExpandedType(JSTypeProcessor processor, JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
        if (context == null) {
            JSTypeUtils.$$$reportNull$$$0(114);
        }
        return JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)type1 -> {
            if (context == null) {
                JSTypeUtils.$$$reportNull$$$0(150);
            }
            processor.process((JSType)type1, context, source);
            return true;
        }), type, true, false, false);
    }

    public static boolean processExpandedType(@NotNull Processor<? super JSType> processor, @Nullable JSType type) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(115);
        }
        return JSTypeUtils.processExpandedType(processor, type, false, true, true);
    }

    public static boolean processExpandedType(@NotNull Processor<? super JSType> processor, @Nullable JSType type, boolean completeSubstitute, boolean recurse, boolean processOnlyFinalType) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(116);
        }
        return JSTypeUtils.processExpandedType(processor, type, completeSubstitute, recurse, processOnlyFinalType, null);
    }

    private static Set<JSResolvedTypeId> getOrCreateProcessingSet(@NotNull JSType type, @Nullable Set<JSResolvedTypeId> processedTypeIds) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(117);
        }
        if (processedTypeIds != null) {
            return processedTypeIds;
        }
        HashSet set = ContainerUtil.newHashSet();
        set.add(type.getResolvedTypeId());
        return set;
    }

    public static boolean processExpandedType(@NotNull Processor<? super JSType> processor, @Nullable JSType type, boolean completeSubstitute, boolean recurse, boolean processOnlyFinalType, @Nullable Set<JSResolvedTypeId> processedTypeIds) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(118);
        }
        if (type != null && processedTypeIds != null && !processedTypeIds.add(type.getResolvedTypeId())) {
            return false;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            boolean isStrictTypeScript = JSTypeCastUtil.isStrictTypeScriptUnionType((JSUnionOrIntersectionType)type);
            if (isStrictTypeScript && completeSubstitute) {
                JSType resolveUnionType = type.substitute();
                processor.process((Object)resolveUnionType);
            } else {
                processedTypeIds = JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds);
                for (JSType jsType : ((JSUnionOrIntersectionType)type).getTypes()) {
                    if (!processOnlyFinalType) {
                        processor.process((Object)jsType);
                    }
                    if (!recurse) continue;
                    JSTypeUtils.processExpandedType(processor, jsType, completeSubstitute, true, processOnlyFinalType, processedTypeIds);
                }
            }
            return false;
        }
        if (type instanceof JSTypeImpl) {
            JSType typedefValue;
            JSTypeSource typeSource = type.getSource();
            if (typeSource.isStrict() && type.resolveClass() == null && (typedefValue = ((JSTypeImpl)type).getJSTypedef()) != null || (typedefValue = ((JSTypeImpl)type).resolveType().getAliasedType()) != null) {
                if (!processOnlyFinalType) {
                    processor.process((Object)typedefValue);
                }
                if (!recurse) {
                    return true;
                }
                return JSTypeUtils.processExpandedType(processor, typedefValue, completeSubstitute, true, processOnlyFinalType, JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds));
            }
        } else if (type instanceof TypeScriptGenericThisTypeImpl || type instanceof JSTypeWithIncompleteSubstitution || type instanceof JSEvaluableType || type instanceof JSWrapperType) {
            JSType newType;
            JSType jSType = newType = completeSubstitute && type instanceof JSTypeWithIncompleteSubstitution ? ((JSTypeWithIncompleteSubstitution)type).substituteCompletely() : type.substitute();
            if (type != newType) {
                if (!processOnlyFinalType) {
                    processor.process((Object)newType);
                }
                if (recurse) {
                    JSTypeUtils.processExpandedType(processor, newType, completeSubstitute, true, processOnlyFinalType, JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds));
                }
                return false;
            }
        }
        if (processOnlyFinalType) {
            processor.process((Object)type);
        }
        return true;
    }

    public static boolean areTypesCompatible(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext processingContext, @Nullable PsiElement psiContext) {
        boolean eq;
        if (type1 == null) {
            type1 = JSAnyType.get(psiContext, false);
        }
        if (type2 == null) {
            type2 = JSAnyType.get(psiContext, false);
        }
        if (type1 instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.areTypesCompatible(((JSTypeofTypeImpl)type1).evaluateType(), type2, processingContext, psiContext);
        }
        if (type2 instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.areTypesCompatible(type1, ((JSTypeofTypeImpl)type2).evaluateType(), processingContext, psiContext);
        }
        if (type1 instanceof JSStringLiteralTypeImpl) {
            return type2 instanceof JSStringType;
        }
        if (type2 instanceof JSStringLiteralTypeImpl) {
            return type1 instanceof JSStringType;
        }
        if (type1 instanceof JSArrayTypeImpl) {
            if (type2 instanceof JSPrimitiveArrayType) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type2)) {
                return true;
            }
        }
        if (type2 instanceof JSArrayTypeImpl) {
            if (type1 instanceof JSPrimitiveArrayType) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type1)) {
                return true;
            }
        }
        if (eq = type1.isEquivalentTo(type2, processingContext)) {
            return true;
        }
        if (psiContext != null && !DialectDetector.isActionScript(psiContext)) {
            return type1.isDirectlyAssignableType(type2, processingContext) && type2.isDirectlyAssignableType(type1, processingContext);
        }
        return false;
    }

    @Nullable
    public static JSType getTypeOfElement(@Nullable PsiElement element) {
        if (element instanceof JSLocalImplicitElementImpl) {
            return ((JSLocalImplicitElementImpl)element).getJSType();
        }
        if (element instanceof JSImplicitElement) {
            return JSTypeUtils.createType(((JSImplicitElement)element).getTypeString(), JSTypeSourceFactory.createTypeSource(element, true));
        }
        if (element instanceof JSFieldVariable) {
            return ((JSFieldVariable)element).getType();
        }
        if (element instanceof JSFunction && ((JSFunction)element).isGetProperty()) {
            return ((JSFunction)element).getReturnType();
        }
        if (element instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)element).getType();
        }
        if (element instanceof JSProperty) {
            return ((JSProperty)element).getType();
        }
        if (element instanceof JSClass) {
            String name = ((JSClass)element).getQualifiedName();
            if (StringUtil.isNotEmpty((String)name)) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(element, DialectDetector.isTypeScript(element));
                return JSNamedTypeFactory.createType(name, typeSource, JSContext.STATIC);
            }
            return TypeScriptTypeParser.buildTypeFromClass((JSClass)element, false);
        }
        return null;
    }

    public static boolean isActionScriptVectorType(@Nullable JSType type) {
        if (type != null && type.getSource().isTypeScript()) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        return type instanceof JSTypeImpl && "Vector".equals(type.getTypeText());
    }

    @NotNull
    public static String defaultValueOfType(@Nullable JSType retType) {
        if (retType == null) {
            if ("undefined" == null) {
                JSTypeUtils.$$$reportNull$$$0(119);
            }
            return "undefined";
        }
        String string = retType.getDefaultValue();
        if (string == null) {
            JSTypeUtils.$$$reportNull$$$0(120);
        }
        return string;
    }

    @Deprecated
    @NonNls
    public static String defaultValueOfType(@NonNls String retType) {
        if (retType == null) {
            return "null";
        }
        switch (retType) {
            case "int": 
            case "uint": 
            case "Number": {
                return "0";
            }
            case "Boolean": {
                return "false";
            }
            case "String": {
                return "\"\"";
            }
        }
        return "null";
    }

    @Nullable
    public static List<JSType> getGenericTypeArguments(@Nullable JSType type) {
        if (type instanceof JSGenericTypeImpl) {
            return ((JSGenericTypeImpl)type).getArguments();
        }
        if (type instanceof JSTupleType) {
            return JSTypeUtils.getGenericTypeArguments(((JSTupleType)type).toArrayType(true));
        }
        if (type instanceof JSArrayTypeImpl) {
            return Collections.singletonList(((JSArrayTypeImpl)type).getType());
        }
        if (type instanceof JSPrimitiveArrayType) {
            return Collections.singletonList(JSAnyType.get(type.getSource().getSourceElement(), type.getSource().isStrict()));
        }
        return null;
    }

    @Nullable
    public static JSType expandEnumAndLiteralTypeByExpectedType(@Nullable JSType original, @Nullable JSType expectedType) {
        if (JSTypeUtils.containsLiteralTypes(expectedType) || JSTypeUtils.isEnumLiteralWithContextNumberOrString(original, expectedType)) {
            return original;
        }
        return JSTypeUtils.expandEnumLiteralIfNeeded(JSTypeUtils.widenLiteralTypes(original));
    }

    private static boolean isEnumLiteralWithContextNumberOrString(@Nullable JSType expressionJSType, @Nullable JSType expectedType) {
        return JSTypeUtils.isEnumLiteral(expressionJSType) && (expectedType instanceof JSStringType || expectedType instanceof JSNumberType);
    }

    @Contract(value="null -> false")
    public static boolean containsLiteralTypes(@Nullable JSType type) {
        Ref hasLiteral = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (JSTypeUtils.isLiteralType(t, true)) {
                hasLiteral.set((Object)true);
                return false;
            }
            return true;
        }), type);
        return (Boolean)hasLiteral.get();
    }

    public static boolean isLiteralType(@Nullable JSType t, boolean expandTypeof) {
        if (t instanceof JSLiteralType) {
            return true;
        }
        if (t instanceof TypeScriptTypeOperatorJSTypeImpl) {
            return true;
        }
        if (JSTypeUtils.isEnumLiteral(t)) {
            return true;
        }
        if (expandTypeof) {
            if (t instanceof JSTypeofTypeImpl) {
                return JSTypeUtils.isLiteralType(((JSTypeofTypeImpl)t).evaluateType(), false);
            }
            return JSTypeUtils.isLiteralType(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(t), false);
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isEnumLiteral(@Nullable JSType type) {
        if (!(type instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        return info.isEnumLiteral();
    }

    @Contract(value="null, _ -> false")
    public static boolean isStringOrStringUnion(@Nullable JSType type, boolean allowResolve) {
        if (type == null) {
            return false;
        }
        if (allowResolve) {
            type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type);
        }
        if (type instanceof JSStringType) {
            return true;
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            return ((JSUnionType)type).getTypes().stream().allMatch(el -> JSTypeUtils.isStringOrStringUnion(el, allowResolve));
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isLiteralOrCompositeWithLiteralType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (JSTypeUtils.isLiteralType(type, true)) {
            return true;
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            return ((JSUnionType)type).getTypes().stream().anyMatch(el -> JSTypeUtils.isLiteralOrCompositeWithLiteralType(el));
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean containsLiteralOrEnumOrPrimitiveTypes(@Nullable JSType type) {
        Ref hasLiteralOrPrimitiveOrEnum = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            JSResolvedTypeInfo info;
            if (t instanceof JSStringType || t instanceof JSNumberType || t instanceof JSBooleanType || t instanceof JSBigIntType || JSTypeUtils.isLiteralType(t, true)) {
                hasLiteralOrPrimitiveOrEnum.set((Object)true);
            }
            if (t instanceof JSTypeImpl && (info = ((JSTypeImpl)t).resolveType()).isEnum()) {
                hasLiteralOrPrimitiveOrEnum.set((Object)true);
            }
            return true;
        }), type);
        return (Boolean)hasLiteralOrPrimitiveOrEnum.get();
    }

    @Contract(value="null -> null")
    public static JSType expandEnumLiteralIfNeeded(@Nullable JSType exprType) {
        JSResolvedTypeInfo resolvedType;
        if (exprType instanceof JSResolvableType && ((JSResolvableType)exprType).isWidened() && (resolvedType = ((JSResolvableType)exprType).resolveType()).isEnumLiteral()) {
            return TypeScriptUtil.getBaseTypeOfEnumLiteralType((JSResolvableType)exprType);
        }
        if (exprType instanceof JSUnionType) {
            List<JSType> originalTypes = ((JSUnionType)exprType).getTypes();
            List expanded = StreamEx.of(originalTypes).map(el -> JSTypeUtils.expandEnumLiteralIfNeeded(el)).toList();
            if (ContainerUtil.equalsIdentity((List)expanded, originalTypes)) {
                return exprType;
            }
            return JSCompositeTypeImpl.getCommonType(expanded, exprType.getSource(), true);
        }
        return exprType;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType widenLiteralTypes(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSLiteralType && ((JSLiteralType)type).allowWidening()) {
            return ((JSLiteralType)type).asPrimitiveType();
        }
        if (type instanceof JSTypeImpl) {
            return ((JSTypeImpl)type).widen(false);
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            List<JSType> types = ((JSUnionType)type).getTypes();
            ArrayList newTypes = ContainerUtil.newArrayListWithCapacity((int)types.size());
            for (JSType part : types) {
                newTypes.add(JSTypeUtils.widenLiteralTypes(part));
            }
            return new JSCompositeTypeImpl(type.getSource(), newTypes);
        }
        return type;
    }

    private static boolean isUnionTypeWithLiteralCandidate(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(121);
        }
        return type instanceof JSUnionType && JSTypeUtils.hasTypes(type, JSStringLiteralTypeImpl.class, JSNumberLiteralTypeImpl.class, JSBigIntLiteralTypeImpl.class, JSBooleanLiteralTypeImpl.class, JSTypeImpl.class);
    }

    public static JSType getApparentType(@Nullable JSType type) {
        if ((type = JSTypeUtils.widenLiteralTypes(type)) instanceof JSNullType || type instanceof JSUndefinedType) {
            return JSAnyType.getByTypeSource(type.getSource());
        }
        if (type instanceof JSTypeofTypeImpl) {
            return ((JSTypeofTypeImpl)type).copyWithAllowWidening(true);
        }
        if (JSTypeUtils.hasTypes(type, JSUnionOrIntersectionType.class, JSTupleTypeImpl.class)) {
            Function<JSType, JSType> transformation = new Function<JSType, JSType>(){

                public JSType fun(JSType type) {
                    JSType optimizeTypeIfComposite;
                    if (type instanceof JSUnionOrIntersectionType && type != (optimizeTypeIfComposite = JSCompositeTypeImpl.optimizeTypeIfComposite(type, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE))) {
                        return optimizeTypeIfComposite.transformTypeHierarchy((Function)this);
                    }
                    if (type instanceof JSTupleTypeImpl) {
                        return new JSTupleTypeImpl(type.getSource(), ContainerUtil.map(((JSTupleTypeImpl)type).getTypes(), t -> t.transformTypeHierarchy((Function)this)), true, ((JSTupleTypeImpl)type).getOptionalStart());
                    }
                    return type;
                }
            };
            type = type.transformTypeHierarchy((Function)transformation);
        }
        return type;
    }

    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable DialectOptionHolder holder, boolean allowResolve) {
        boolean isTypeScript;
        if (type1 == null) {
            JSTypeUtils.$$$reportNull$$$0(122);
        }
        if (type2 == null) {
            JSTypeUtils.$$$reportNull$$$0(123);
        }
        JSTypeSource source = type1.getSource();
        boolean bl = isTypeScript = holder != null && holder.isTypeScript;
        if (!(!(type1 instanceof JSStringType) || !(type2 instanceof JSStringType) || isTypeScript && type1 instanceof JSStringLiteralTypeImpl && type2 instanceof JSStringLiteralTypeImpl)) {
            return JSNamedTypeFactory.createType("string", source, ((JSStringType)type1).isStaticOrInstance());
        }
        if (isTypeScript) {
            return JSCompositeTypeImpl.getCommonType(type1, type2, null, allowResolve);
        }
        if (type1.isEquivalentTo(type2, null, allowResolve)) {
            return type1;
        }
        return JSAnyType.get((PsiElement)source.getScope(), false);
    }

    @NotNull
    public static JSType replaceImplicitTypesWithAny(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(124);
        }
        JSType jSType = type.transformTypeHierarchy(jsType -> {
            JSType toProcess = JSTypeUtils.getValuableType(jsType);
            if (jsType instanceof JSAnyType) {
                return jsType;
            }
            if (!toProcess.isSourceStrict() && toProcess.isTypeScript()) {
                PsiElement sourceElement = toProcess.getSource().getSourceElement();
                return sourceElement != null ? JSAnyType.get(sourceElement, true) : JSAnyType.getWithLanguage(toProcess.getSource().getLanguage(), true);
            }
            return jsType;
        });
        if (jSType == null) {
            JSTypeUtils.$$$reportNull$$$0(125);
        }
        return jSType;
    }

    public static boolean isEnumType(@Nullable JSType expectedType) {
        if (expectedType == null) {
            return false;
        }
        if (!(expectedType instanceof JSResolvableType)) {
            return false;
        }
        return ((JSResolvableType)expectedType).resolveType().isEnum();
    }

    @NotNull
    public static JSGenericTypeImpl wrapWithIterableIterator(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(126);
        }
        JSTypeSource source = JSTypeSourceFactory.copyTypeSource(type.getSource(), true);
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, JSNamedTypeFactory.createType("IterableIterator", source, JSTypeContext.INSTANCE), type);
        if (jSGenericTypeImpl == null) {
            JSTypeUtils.$$$reportNull$$$0(127);
        }
        return jSGenericTypeImpl;
    }

    @NotNull
    public static JSGenericTypeImpl wrapWithAsyncIterableIterator(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(128);
        }
        JSTypeSource source = JSTypeSourceFactory.copyTypeSource(type.getSource(), true);
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, JSNamedTypeFactory.createType("AsyncIterableIterator", source, JSTypeContext.INSTANCE), type);
        if (jSGenericTypeImpl == null) {
            JSTypeUtils.$$$reportNull$$$0(129);
        }
        return jSGenericTypeImpl;
    }

    public static JSType getCommonType(@NotNull Collection<? extends TypeProvider> providers, @Nullable PsiElement context, boolean allowResolve) {
        DialectOptionHolder holder;
        if (providers == null) {
            JSTypeUtils.$$$reportNull$$$0(130);
        }
        DialectOptionHolder dialectOptionHolder = holder = context == null ? null : DialectDetector.dialectOfElement(context);
        if (holder != null && holder.isTypeScript) {
            return JSTypeUtils.getTypeScriptCommonType(providers, context, allowResolve);
        }
        JSAnyType commonType = null;
        for (TypeProvider typeProvider : providers) {
            JSType exprType = typeProvider.getType();
            if (!((commonType = commonType != null && exprType != null ? JSTypeUtils.getCommonType(commonType, exprType, holder, allowResolve) : exprType) instanceof JSAnyType)) continue;
            break;
        }
        if (commonType == null) {
            commonType = JSAnyType.get(context, false);
        }
        return commonType;
    }

    public static JSType getTypeScriptCommonType(@NotNull Collection<? extends TypeProvider> providers, @Nullable PsiElement context, boolean allowResolve) {
        if (providers == null) {
            JSTypeUtils.$$$reportNull$$$0(131);
        }
        List<JSType> types = ContainerUtil.newArrayListWithCapacity((int)providers.size());
        boolean hasStringType = false;
        for (TypeProvider typeProvider : providers) {
            JSType type = typeProvider.getType();
            if (type instanceof JSAnyType) {
                return type;
            }
            types.add(type);
            if (!(type instanceof JSStringType) || type instanceof JSStringLiteralTypeImpl) continue;
            hasStringType = true;
        }
        if (hasStringType) {
            types = ContainerUtil.filter((Collection)types, el -> !(el instanceof JSStringLiteralTypeImpl));
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context, true);
        return JSCompositeTypeImpl.getCommonType((Collection<? extends JSType>)types, source, allowResolve);
    }

    private static boolean isAssignableType(@Nullable JSType thisType, @Nullable JSType elementType, ProcessingContext processingContext) {
        return thisType == null || thisType.isDirectlyAssignableType(elementType, processingContext);
    }

    public static List<JSParameterTypeDecorator> getParameterTypeDecorators(List<? extends JSType> parameters) {
        ArrayList<JSParameterTypeDecorator> decorators = new ArrayList<JSParameterTypeDecorator>(parameters.size());
        for (JSType jSType : parameters) {
            decorators.add(new JSParameterTypeDecoratorImpl(jSType, false, false, true));
        }
        return decorators;
    }

    @NotNull
    public static JSContext combineJSContexts(@NotNull JSContext f, @NotNull JSContext g) {
        if (f == null) {
            JSTypeUtils.$$$reportNull$$$0(132);
        }
        if (g == null) {
            JSTypeUtils.$$$reportNull$$$0(133);
        }
        if (f == JSContext.STATIC && g == JSContext.STATIC) {
            JSContext jSContext = JSContext.STATIC;
            if (jSContext == null) {
                JSTypeUtils.$$$reportNull$$$0(134);
            }
            return jSContext;
        }
        if (f == JSContext.INSTANCE || g == JSContext.INSTANCE) {
            JSContext jSContext = JSContext.INSTANCE;
            if (jSContext == null) {
                JSTypeUtils.$$$reportNull$$$0(135);
            }
            return jSContext;
        }
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            JSTypeUtils.$$$reportNull$$$0(136);
        }
        return jSContext;
    }

    @NotNull
    public static Object getTypeInvalidationDependency() {
        Key key = PsiModificationTracker.MODIFICATION_COUNT;
        if (key == null) {
            JSTypeUtils.$$$reportNull$$$0(137);
        }
        return key;
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromProperties(@NotNull Map<JSQualifiedName, String> properties, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (properties == null) {
            JSTypeUtils.$$$reportNull$$$0(138);
        }
        if (optional == null) {
            JSTypeUtils.$$$reportNull$$$0(139);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(140);
        }
        ArrayList<Pair> list = new ArrayList<Pair>(properties.size());
        for (Map.Entry<JSQualifiedName, String> entry : properties.entrySet()) {
            list.add(Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
        }
        return JSTypeUtils.buildRecordTypeFromQualifiedNames(list, optional, typeSource);
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromQualifiedNames(@NotNull Collection<? extends Pair<JSQualifiedName, String>> qualifiedNames, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (qualifiedNames == null) {
            JSTypeUtils.$$$reportNull$$$0(141);
        }
        if (optional == null) {
            JSTypeUtils.$$$reportNull$$$0(142);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(143);
        }
        RecordTypeNode root = new RecordTypeNode();
        for (Pair<JSQualifiedName, String> pair : qualifiedNames) {
            List components = ((JSQualifiedName)pair.getFirst()).toComponents();
            RecordTypeNode currentPath = root;
            for (int i = 0; i < components.size(); ++i) {
                String component = (String)components.get(i);
                RecordTypeNode child = currentPath.myChildren.get(component);
                if (child == null) {
                    child = new RecordTypeNode();
                    child.myOptional = optional.contains(pair.getFirst());
                    currentPath.myChildren.put(component, child);
                }
                currentPath = child;
                if (i != components.size() - 1) continue;
                String typeString = (String)pair.getSecond();
                currentPath.myType = JSTypeUtils.createTypeFromJSDoc(typeString, typeSource);
            }
        }
        return (JSRecordType)JSTypeUtils.buildTypeFromRecordTypeNode(root, typeSource);
    }

    @Nullable
    private static JSType buildTypeFromRecordTypeNode(@NotNull RecordTypeNode node, @NotNull JSTypeSource typeSource) {
        if (node == null) {
            JSTypeUtils.$$$reportNull$$$0(144);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(145);
        }
        if (node.myChildren.isEmpty()) {
            return node.myType;
        }
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> typeMembers = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>(node.myChildren.size());
        for (Map.Entry<String, RecordTypeNode> entry : node.myChildren.entrySet()) {
            JSType type = JSTypeUtils.buildTypeFromRecordTypeNode(entry.getValue(), typeSource);
            typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(entry.getKey(), type, entry.getValue().myOptional));
        }
        return new JSRecordTypeImpl(typeSource, typeMembers);
    }

    @NotNull
    public static Collection<JSImplicitElement> getImplicitMembersFromRecordType(@NotNull JSRecordType type, @Nullable JSQualifiedName namespace, @Nullable PsiElement parent) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(146);
        }
        SmartList elements = new SmartList();
        for (JSRecordType.TypeMember member : type.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            String name = ((JSRecordType.PropertySignature)member).getMemberName();
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, parent).setNamespace(namespace).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(namespace != null);
            JSType jsType = ((JSRecordType.PropertySignature)member).getType();
            if (jsType instanceof JSRecordType) {
                Collection<JSImplicitElement> childElements = JSTypeUtils.getImplicitMembersFromRecordType((JSRecordType)jsType, JSQualifiedNameImpl.create(name, namespace), parent);
                elements.addAll(childElements);
            }
            if (jsType != null) {
                builder.setTypeString(jsType.getTypeText(JSType.TypeTextFormat.SIMPLE));
            }
            JSImplicitElementImpl element = new JSImplicitElementImpl(builder);
            elements.add((Object)element);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            JSTypeUtils.$$$reportNull$$$0(147);
        }
        return smartList;
    }

    @Contract(value="!null,_ -> !null")
    public static JSType transformTypeHierarchySafe(@Nullable JSType type, @NotNull Function<JSType, JSType> transformation) {
        if (transformation == null) {
            JSTypeUtils.$$$reportNull$$$0(148);
        }
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy(transformation);
    }

    public static boolean isNeedWrapTypeForSerialization(@Nullable JSType type) {
        return type instanceof JSUnionOrIntersectionType || type instanceof JSFunctionTypeImpl || type instanceof TypeScriptTypeOperatorJSTypeImpl;
    }

    @Nullable
    public static PsiElement getLocalScopeFromSource(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            JSTypeUtils.$$$reportNull$$$0(149);
        }
        if (!namespace.isLocal()) {
            return null;
        }
        PsiElement sourceElement = namespace.getSource().getSourceElement();
        boolean strict = !(sourceElement instanceof PsiFile);
        return sourceElement != null ? JSPsiImplUtils.getExecutionScope(sourceElement, strict) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 69: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 112: 
            case 113: 
            case 119: 
            case 120: 
            case 125: 
            case 127: 
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 147: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 69: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 112: 
            case 113: 
            case 119: 
            case 120: 
            case 125: 
            case 127: 
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 147: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 51: 
            case 54: 
            case 82: 
            case 89: 
            case 117: 
            case 121: 
            case 124: 
            case 126: 
            case 128: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 12: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 69: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 112: 
            case 113: 
            case 119: 
            case 120: 
            case 125: 
            case 127: 
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils";
                break;
            }
            case 14: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 15: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 26: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedType";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalTypes";
                break;
            }
            case 55: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyCallElement";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyInstanceContextElement";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 61: 
            case 63: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFunction";
                break;
            }
            case 62: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 64: 
            case 71: 
            case 77: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 65: 
            case 72: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 66: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArguments";
                break;
            }
            case 67: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentProviders";
                break;
            }
            case 79: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callTypeArguments";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorators";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualArguments";
                break;
            }
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 87: 
            case 108: 
            case 114: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypeDecorator";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argIterator";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 103: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericParameters";
                break;
            }
            case 104: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 105: 
            case 106: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClasses";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOption";
                break;
            }
            case 115: 
            case 116: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 130: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 139: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optional";
                break;
            }
            case 140: 
            case 143: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInPromiseType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMatchingNamespace";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypeName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionType";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypeImpl";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWithMixins";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptInterfaceInJavaScriptContext";
                break;
            }
            case 69: 
            case 74: 
            case 75: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseOverloadFunctionTypes";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "spreadArguments";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "addPossibleOption";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultValueOfType";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceImplicitTypesWithAny";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithIterableIterator";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithAsyncIterableIterator";
                break;
            }
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "combineJSContexts";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInvalidationDependency";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitMembersFromRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScopeInOriginalTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseSerializedOrJSDocType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseSerializedType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromJSDoc";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createParameterType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIterableCollectionType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIndexableType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMapType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "wrapInPromiseType";
                break;
            }
            case 12: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 69: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 112: 
            case 113: 
            case 119: 
            case 120: 
            case 125: 
            case 127: 
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 147: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPromiseComponentTypeOrNull";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSingleGenericArgTypeFromGenericType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSingleGenericComponentType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIterableComponentType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "typeCanBeAssignedWithoutCoercion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMatchingNamespace";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameMatchingType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceMatchingType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasFunctionType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypeImpl";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithMixins";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptInterfaceInJavaScriptContext";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyType";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "tryGetReturnType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeArguments";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "chooseOverloadFunctionTypes";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "checkOverload";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "canBeCalledWithArguments";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeForVisited";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "areArgumentsAssignable";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentType";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "checkTuple";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "matchRestTuples";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "spreadArguments";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "concatGenericsToJSGenericTypeIfNestedLocal";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "applyGenericArguments";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "addJSGenericParameters";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "applyCompositeMapping";
                break;
            }
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "hasTypes";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "copyWithLanguageOfContext";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "copyWithLanguageRecursive";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleOption";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "processExpandedType";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProcessingSet";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "isUnionTypeWithLiteralCandidate";
                break;
            }
            case 122: 
            case 123: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "replaceImplicitTypesWithAny";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithIterableIterator";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithAsyncIterableIterator";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptCommonType";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "combineJSContexts";
                break;
            }
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromProperties";
                break;
            }
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromQualifiedNames";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromRecordTypeNode";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitMembersFromRecordType";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchySafe";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getLocalScopeFromSource";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExpandedType$14";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasTypes$13";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addJSGenericParameters$12";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "lambda$chooseOverloadFunctionTypes$10";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSingleGenericArgTypeFromGenericType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 69: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 112: 
            case 113: 
            case 119: 
            case 120: 
            case 125: 
            case 127: 
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 147: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RecordTypeNode {
        Map<String, RecordTypeNode> myChildren = new LinkedHashMap<String, RecordTypeNode>();
        boolean myOptional;
        JSType myType;

        private RecordTypeNode() {
        }
    }

    public static interface TypeProvider {
        @Nullable
        public JSType getType();
    }

    static enum OverloadPriority {
        ASSIGNABLE_EXACT,
        ASSIGNABLE,
        NOT_ASSIGNABLE_SAME_PARAMETERS_LENGTH,
        NOT_ASSIGNABLE_PARAMETERS,
        INCORRECT_GENERICS_LENGTH,
        INCORRECT_PARAMETERS_LENGTH,
        UNKNOWN;

    }
}

