/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.refactoring.extractSuper.JSCustomExtractInterfaceHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSInsertCastFix;
import com.intellij.lang.typescript.refactoring.TypeScriptExtractInterfaceFromTypeHandler;
import com.intellij.lang.typescript.refactoring.TypeScriptExtractNamedTypeHandler;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptExtractInterfaceFromObjectLiteralHandler
implements JSCustomExtractInterfaceHandler {
    @Override
    public boolean isAvailableOnEditorAndFile(@NotNull Editor editor, @NotNull PsiFile file2) {
        JSObjectLiteralExpression literal;
        if (editor == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(1);
        }
        return (literal = TypeScriptExtractInterfaceFromObjectLiteralHandler.findObjectLiteral(editor, file2)) != null && PsiTreeUtil.getParentOfType((PsiElement)literal, JSStatement.class) != null;
    }

    @Nullable
    private static JSObjectLiteralExpression findObjectLiteral(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(3);
        }
        return (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), JSObjectLiteralExpression.class);
    }

    @Override
    public void invoke(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(5);
        }
        JSObjectLiteralExpression literal = TypeScriptExtractInterfaceFromObjectLiteralHandler.findObjectLiteral(editor, file2);
        assert (literal != null);
        String semi = JSCodeStyleSettings.getSemicolon((PsiElement)file2);
        if (StringUtil.isEmptyOrSpaces((String)semi)) {
            semi = "\n";
        }
        StringBuilder typeBuilder = new StringBuilder("{");
        for (JSProperty property : literal.getProperties()) {
            typeBuilder.append(JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)property, false));
            if (property instanceof JSFunction && ((JSFunction)property).getParameterList() != null) {
                typeBuilder.append(((JSFunction)property).getParameterList().getText());
                PsiElement returnTypeElement = ((JSFunction)property).getReturnTypeElement();
                if (returnTypeElement != null) {
                    typeBuilder.append(": ").append(returnTypeElement.getText());
                } else {
                    JSType returnType = ((JSFunction)property).getReturnType();
                    if (returnType != null) {
                        typeBuilder.append(": ").append(returnType.getTypeText(JSType.TypeTextFormat.CODE));
                    }
                }
                typeBuilder.append(semi);
                continue;
            }
            typeBuilder.append(": ");
            JSType type = JSResolveUtil.getExpressionJSType(property.getValue());
            typeBuilder.append(type == null ? "any" : JSTypeUtils.widenLiteralTypes(type).getTypeText(JSType.TypeTextFormat.CODE)).append(semi);
        }
        typeBuilder.append("}");
        PsiElement parent = literal.getParent();
        WriteCommandAction.runWriteCommandAction((Project)file2.getProject(), (String)JSBundle.message((String)"extract.interface.command.name", (Object[])new Object[0]), null, () -> {
            if (editor == null) {
                TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(11);
            }
            TypeScriptExtractInterfaceFromObjectLiteralHandler.doExtract(editor, typeBuilder.toString(), parent, literal);
        }, (PsiFile[])new PsiFile[]{file2});
    }

    private static boolean isSuitableTypeElement(PsiElement typeDeclaration) {
        if (typeDeclaration == null) {
            return true;
        }
        if (!(typeDeclaration instanceof JSTypeDeclaration)) {
            return false;
        }
        JSType parsed = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)typeDeclaration);
        return parsed instanceof JSAnyType || parsed instanceof JSObjectType || parsed instanceof JSRecordTypeImpl && !((JSRecordTypeImpl)parsed).hasMembers();
    }

    private static boolean isSuitableParent(@NotNull PsiElement parent) {
        if (parent == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(6);
        }
        return parent instanceof JSField || parent instanceof JSVariable && parent.getParent() instanceof JSVarStatement;
    }

    private static void doExtract(@NotNull Editor editor, @NotNull String typeDesc, @NotNull PsiElement parent, @NotNull JSObjectLiteralExpression literal) {
        TypeScriptExtractNamedTypeHandler.Candidate typeCandidate;
        if (editor == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(7);
        }
        if (typeDesc == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(9);
        }
        if (literal == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(10);
        }
        JSObjectLiteralExpression scope = literal;
        if (TypeScriptExtractInterfaceFromObjectLiteralHandler.isSuitableParent(parent) && TypeScriptExtractInterfaceFromObjectLiteralHandler.isSuitableTypeElement(((JSTypeDeclarationOwner)parent).getTypeElement())) {
            JSRefactoringUtil.setType((JSElement)parent, typeDesc);
            JSTypeDeclaration typeElement = (JSTypeDeclaration)((JSTypeDeclarationOwner)parent).getTypeElement();
            assert (typeElement != null);
            typeCandidate = new TypeScriptExtractNamedTypeHandler.Candidate(typeElement, null);
        } else {
            DialectOptionHolder dialect = DialectDetector.dialectOfElement(parent);
            if (dialect == null) {
                dialect = DialectOptionHolder.TSX;
            }
            PsiElement expression = JSChangeUtil.createExpressionFromText(parent.getProject(), JSInsertCastFix.getCast(typeDesc, literal.getText(), dialect, parent.getContainingFile()), DialectDetector.languageDialectOfElement(parent), false).getPsi();
            expression = literal.replace((JSExpression)expression);
            scope = expression;
            TypeScriptType type = TypeScriptExtractInterfaceFromObjectLiteralHandler.getTypeElementFromCast(expression);
            assert (type != null);
            typeCandidate = new TypeScriptExtractNamedTypeHandler.Candidate((JSTypeDeclaration)type, null);
        }
        Pair<JSElement, Collection<TypeScriptGenericOrMappedTypeParameter>> scopeAndGenerics = TypeScriptExtractNamedTypeHandler.getScopeAndGenerics(typeCandidate);
        TypeScriptExtractNamedTypeHandler.getScopeAndGenerics((PsiElement)scope, null, (Ref<PsiElement>)Ref.create(), (Collection)scopeAndGenerics.second);
        new TypeScriptExtractInterfaceFromTypeHandler().invokeForOccurrences(editor, typeCandidate, ContainerUtil.emptyList(), (JSElement)scopeAndGenerics.first, (Collection)scopeAndGenerics.second);
    }

    private static TypeScriptType getTypeElementFromCast(PsiElement expression) {
        if (expression instanceof JSParenthesizedExpression) {
            expression = ((JSParenthesizedExpression)expression).getInnerExpression();
        }
        assert (expression instanceof TypeScriptCastExpression);
        return ((TypeScriptCastExpression)expression).getType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDesc";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractInterfaceFromObjectLiteralHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnEditorAndFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findObjectLiteral";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableParent";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doExtract";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

