/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.angularjs.codeInsight.AngularJSPluralCategories;
import org.angularjs.lang.parser.AngularJSMessageFormatParser;
import org.angularjs.lang.psi.AngularJSElementVisitor;
import org.angularjs.lang.psi.AngularJSMessageFormatExpression;
import org.jetbrains.annotations.NotNull;

public class AngularJSMessageFormatAnnotator
extends AngularJSElementVisitor
implements Annotator {
    private AnnotationHolder myHolder;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            AngularJSMessageFormatAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AngularJSMessageFormatAnnotator.$$$reportNull$$$0(1);
        }
        try {
            assert (this.myHolder == null);
            this.myHolder = holder;
            element.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitMessageFormatExpression(@NotNull AngularJSMessageFormatExpression expression) {
        AngularJSMessageFormatParser.ExtensionType type;
        if (expression == null) {
            AngularJSMessageFormatAnnotator.$$$reportNull$$$0(2);
        }
        if ((type = expression.getExtensionType()) == null) {
            this.myHolder.createErrorAnnotation((PsiElement)expression, "missing or unknown message format extension");
        }
        List<PsiElement> elements = expression.getSelectionKeywordElements();
        List selectionKeywords = ContainerUtil.map(elements, element -> element.getText());
        this.checkOptions(type, expression);
        if (expression.getNode().getLastChildNode() instanceof PsiErrorElement) {
            return;
        }
        this.checkForRequiredSelectionKeywords(type, expression, selectionKeywords);
        this.checkForDuplicateSelectionKeywords(selectionKeywords, elements);
        this.checkForSelectionKeywordValues(type, selectionKeywords, elements);
    }

    private void checkOptions(AngularJSMessageFormatParser.ExtensionType type, AngularJSMessageFormatExpression expression) {
        PsiElement[] options;
        if (AngularJSMessageFormatParser.ExtensionType.plural.equals((Object)type) && (options = expression.getOptions()) != null) {
            for (PsiElement option : options) {
                ASTNode lastChild;
                if (!"offset".equals(option.getNode().getFirstChildNode().getText()) || (lastChild = option.getNode().getLastChildNode()).getElementType() == JSTokenTypes.NUMERIC_LITERAL) continue;
                this.myHolder.createErrorAnnotation(option, "Expected integer value");
            }
        }
    }

    private void checkForSelectionKeywordValues(AngularJSMessageFormatParser.ExtensionType type, List<String> keywords, List<PsiElement> elements) {
        if (AngularJSMessageFormatParser.ExtensionType.plural.equals((Object)type)) {
            HashMap<String, String> errors = new HashMap<String, String>();
            for (String keyword : keywords) {
                if (keyword.startsWith("=")) {
                    try {
                        Integer.parseInt(keyword.substring(1));
                    }
                    catch (NumberFormatException e) {
                        errors.put(keyword, "Integer expected after =");
                    }
                    continue;
                }
                try {
                    AngularJSPluralCategories.valueOf(keyword);
                }
                catch (IllegalArgumentException e) {
                    errors.put(keyword, "Expected plural category");
                }
            }
            if (!errors.isEmpty()) {
                for (PsiElement element : elements) {
                    String errorText = (String)errors.get(element.getText());
                    if (errorText == null) continue;
                    this.myHolder.createErrorAnnotation(element, errorText);
                }
            }
        }
    }

    private void checkForDuplicateSelectionKeywords(List<String> keywords, List<PsiElement> elements) {
        HashSet passedSet = new HashSet();
        HashSet duplicate = new HashSet(ContainerUtil.filter(keywords, s -> {
            boolean contains = passedSet.contains(s);
            if (!contains) {
                passedSet.add(s);
            }
            return contains;
        }));
        if (!duplicate.isEmpty()) {
            for (PsiElement element : elements) {
                if (!duplicate.contains(element.getText())) continue;
                this.myHolder.createErrorAnnotation(element, "Duplicate selection keyword");
            }
        }
    }

    private void checkForRequiredSelectionKeywords(AngularJSMessageFormatParser.ExtensionType type, @NotNull AngularJSMessageFormatExpression expression, List<String> selectionKeywords) {
        Set<String> requiredKeywords;
        if (expression == null) {
            AngularJSMessageFormatAnnotator.$$$reportNull$$$0(3);
        }
        if (type != null && !(requiredKeywords = type.getRequiredSelectionKeywords()).isEmpty()) {
            for (String requiredKeyword : requiredKeywords) {
                if (selectionKeywords.contains(requiredKeyword)) continue;
                this.myHolder.createErrorAnnotation((PsiElement)expression, "Missing required selection keyword '" + requiredKeyword + "'");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/angularjs/codeInsight/AngularJSMessageFormatAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMessageFormatExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForRequiredSelectionKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

