/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffTool {
    private static final Logger LOG = Logger.getInstance(ExternalDiffTool.class);

    public static boolean isDefault() {
        return ExternalDiffSettings.getInstance().isDiffEnabled() && ExternalDiffSettings.getInstance().isDiffDefault();
    }

    public static boolean isEnabled() {
        return ExternalDiffSettings.getInstance().isDiffEnabled();
    }

    public static void show(@Nullable Project project, @NotNull DiffRequestChain chain, @NotNull DiffDialogHints hints) {
        if (chain == null) {
            ExternalDiffTool.$$$reportNull$$$0(0);
        }
        if (hints == null) {
            ExternalDiffTool.$$$reportNull$$$0(1);
        }
        try {
            List<DiffRequest> requests = ExternalDiffTool.loadRequestsUnderProgress(project, chain);
            if (requests == null) {
                return;
            }
            ArrayList<DiffRequest> showInBuiltin = new ArrayList<DiffRequest>();
            for (DiffRequest request : requests) {
                if (ExternalDiffTool.canShow(request)) {
                    ExternalDiffTool.showRequest(project, request);
                    continue;
                }
                showInBuiltin.add(request);
            }
            if (!showInBuiltin.isEmpty()) {
                DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)new SimpleDiffRequestChain(showInBuiltin), hints);
            }
        }
        catch (ProcessCanceledException requests) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"Can't Show Diff In External Tool");
        }
    }

    @Nullable
    private static List<DiffRequest> loadRequestsUnderProgress(@Nullable Project project, @NotNull DiffRequestChain chain) throws Throwable {
        if (chain == null) {
            ExternalDiffTool.$$$reportNull$$$0(2);
        }
        if (chain instanceof AsyncDiffRequestChain) {
            return (List)ExternalDiffTool.loadInBackground(project, "Loading Requests", indicator -> {
                if (chain == null) {
                    ExternalDiffTool.$$$reportNull$$$0(14);
                }
                ListSelection<? extends DiffRequestProducer> listSelection = ((AsyncDiffRequestChain)chain).loadRequestsInBackground();
                return ExternalDiffTool.collectRequests(project, listSelection.getList(), listSelection.getSelectedIndex(), indicator);
            });
        }
        List allProducers = chain.getRequests();
        int index = chain.getIndex();
        return (List)ExternalDiffTool.loadInBackground(project, "Loading Requests", indicator -> ExternalDiffTool.collectRequests(project, allProducers, index, indicator));
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> allProducers, int index, @NotNull ProgressIndicator indicator) {
        if (allProducers == null) {
            ExternalDiffTool.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            ExternalDiffTool.$$$reportNull$$$0(4);
        }
        if (allProducers.isEmpty()) {
            List<DiffRequest> list2 = Collections.emptyList();
            if (list2 == null) {
                ExternalDiffTool.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List<DiffRequestProducer> producers = Collections.singletonList(allProducers.get(index));
        List<DiffRequest> list3 = ExternalDiffTool.collectRequests(project, producers, indicator);
        if (list3 == null) {
            ExternalDiffTool.$$$reportNull$$$0(6);
        }
        return list3;
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> producers, @NotNull ProgressIndicator indicator) {
        if (producers == null) {
            ExternalDiffTool.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            ExternalDiffTool.$$$reportNull$$$0(8);
        }
        ArrayList<DiffRequest> requests = new ArrayList<DiffRequest>();
        UserDataHolderBase context = new UserDataHolderBase();
        ArrayList<String> errorRequests = new ArrayList<String>();
        for (DiffRequestProducer diffRequestProducer : producers) {
            try {
                requests.add(diffRequestProducer.process((UserDataHolder)context, indicator));
            }
            catch (DiffRequestProducerException e) {
                LOG.warn((Throwable)e);
                errorRequests.add(diffRequestProducer.getName());
            }
        }
        if (!errorRequests.isEmpty()) {
            new Notification("Diff", "Can't Load Some Changes", StringUtil.join(errorRequests, (String)"<br>"), NotificationType.ERROR).notify(project);
        }
        ArrayList<DiffRequest> arrayList = requests;
        if (arrayList == null) {
            ExternalDiffTool.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static void showRequest(@Nullable Project project, @NotNull DiffRequest request) throws ExecutionException, IOException {
        if (request == null) {
            ExternalDiffTool.$$$reportNull$$$0(10);
        }
        request.onAssigned(true);
        ExternalDiffSettings settings = ExternalDiffSettings.getInstance();
        List contents = ((ContentDiffRequest)request).getContents();
        List titles = ((ContentDiffRequest)request).getContentTitles();
        ExternalDiffToolUtil.execute(project, settings, contents, titles, request.getTitle());
        request.onAssigned(false);
    }

    public static boolean canShow(@NotNull DiffRequest request) {
        if (request == null) {
            ExternalDiffTool.$$$reportNull$$$0(11);
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2 && contents.size() != 3) {
            return false;
        }
        for (DiffContent content : contents) {
            if (ExternalDiffToolUtil.canCreateFile(content)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static <T> T loadInBackground(@Nullable Project project, @NotNull String title, final @NotNull ThrowableConvertor<ProgressIndicator, T, Throwable> computable) throws Throwable {
        if (title == null) {
            ExternalDiffTool.$$$reportNull$$$0(12);
        }
        if (computable == null) {
            ExternalDiffTool.$$$reportNull$$$0(13);
        }
        final Ref requestsRef = new Ref();
        final Ref exceptionRef = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    requestsRef.set(computable.convert((Object)indicator));
                }
                catch (Throwable e) {
                    exceptionRef.set((Object)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffTool$1", "run"));
            }
        });
        if (!exceptionRef.isNull()) {
            throw (Throwable)exceptionRef.get();
        }
        return (T)requestsRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProducers";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffTool";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffTool";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadRequestsUnderProgress";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectRequests";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showRequest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canShow";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadInBackground";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadRequestsUnderProgress$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

