/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsAdapter;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

class MacEventReader {
    private static final int MAX_MESSAGE_LENGTH = 100;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.impl.MacEventReader");
    private static final NotificationsAdapter ourNotificationAdapter = new NotificationsAdapter(){

        public void notify(@NotNull Notification notification) {
            if (notification == null) {
                1.$$$reportNull$$$0(0);
            }
            MacEventReader.process(notification);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/MacEventReader$1", "notify"));
        }
    };
    private static ExecutorService ourService = null;

    MacEventReader() {
        if (SystemInfo.isMac) {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)ourNotificationAdapter);
        }
    }

    private static void process(Notification notification) {
        if (!NotificationsConfigurationImpl.getSettings(notification.getGroupId()).isShouldReadAloud()) {
            return;
        }
        String message = notification.getTitle();
        if (message.isEmpty()) {
            message = notification.getContent();
        }
        if ((message = StringUtil.stripHtml((String)message, (boolean)false)).length() > 100) {
            String[] words = message.split("\\s");
            StringBuilder sb = new StringBuilder();
            for (String word : words) {
                if (sb.length() + word.length() >= 99) break;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(word);
            }
            message = sb.toString();
        }
        if (!message.isEmpty()) {
            String copy = message;
            MacEventReader.getService().submit(() -> {
                try {
                    Runtime.getRuntime().exec("say " + copy).waitFor();
                }
                catch (IOException | InterruptedException e) {
                    LOG.warn((Throwable)e);
                }
            });
        }
    }

    private static synchronized ExecutorService getService() {
        if (ourService == null) {
            ourService = ConcurrencyUtil.newSingleThreadExecutor((String)"Mac event reader");
        }
        return ourService;
    }

    public static class ProjectTracker {
        public ProjectTracker(@NotNull Project project) {
            if (project == null) {
                ProjectTracker.$$$reportNull$$$0(0);
            }
            project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)ourNotificationAdapter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/impl/MacEventReader$ProjectTracker", "<init>"));
        }
    }
}

